/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;
import javax.management.InvalidAttributeValueException;
import weblogic.application.DeploymentManager;
import weblogic.application.MBeanFactory;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.AppDeployment;
import weblogic.management.ApplicationException;
import weblogic.management.DeploymentException;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.ArrayUtils;
import weblogic.utils.NestedException;

public class MBeanConverter {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static ApplicationMBean createApplicationForAppDeployment(DomainMBean domainMBean, AppDeploymentMBean appDeploymentMBean, String string) throws DeploymentException {
        if (!(ManagementService.getRuntimeAccess(kernelId).isAdminServer() || TargetHelper.isTargetedLocaly(appDeploymentMBean) || TargetHelper.isPinnedToServerInCluster(appDeploymentMBean))) {
            return null;
        }
        ApplicationMBean applicationMBean = domainMBean.lookupApplication(appDeploymentMBean.getName());
        try {
            if (applicationMBean != null) {
                return applicationMBean;
            }
            if (MBeanConverter.isDebugEnabled()) {
                MBeanConverter.debug("Creating appmeans for " + appDeploymentMBean.getObjectName() + " In " + domainMBean.getObjectName() + " from " + string);
            }
            if (appDeploymentMBean.getSourcePath().toLowerCase(Locale.US).endsWith(".xml")) {
                applicationMBean = MBeanConverter.createTEMPCompatMBean(appDeploymentMBean, domainMBean, string);
            } else {
                applicationMBean = MBeanConverter.createApplicationMBean(appDeploymentMBean, domainMBean, string);
                MBeanConverter.setApplicationTargets(appDeploymentMBean, applicationMBean);
            }
            applicationMBean.setLoadOrder(appDeploymentMBean.getDeploymentOrder());
            applicationMBean.setDelegationEnabled(true);
        }
        catch (Throwable throwable) {
            MBeanConverter.handleException(appDeploymentMBean, throwable);
        }
        return applicationMBean;
    }

    private static ApplicationMBean createApplicationMBean(AppDeploymentMBean appDeploymentMBean, DomainMBean domainMBean, String string) throws InvalidAttributeValueException, IOException, ApplicationException {
        File file = BootStrap.apply((String)string);
        if (!file.isAbsolute()) {
            file = file.getCanonicalFile();
        }
        ApplicationMBean applicationMBean = MBeanFactory.getMBeanFactory().initializeMBeans(domainMBean, file, appDeploymentMBean.getName(), null, null, appDeploymentMBean);
        return applicationMBean;
    }

    private static void setApplicationTargets(AppDeploymentMBean appDeploymentMBean, ApplicationMBean applicationMBean) throws DistributedManagementException, InvalidAttributeValueException {
        ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
        for (int i = 0; i < componentMBeanArray.length; ++i) {
            ComponentMBean componentMBean = componentMBeanArray[i];
            componentMBean.setTargets(MBeanConverter.getTargetsForComponent(appDeploymentMBean, componentMBean));
        }
    }

    public static TargetMBean[] getTargetsForComponent(AppDeploymentMBean appDeploymentMBean, ComponentMBean componentMBean) {
        SubDeploymentMBean subDeploymentMBean = MBeanConverter.findSubDeployment(appDeploymentMBean, componentMBean);
        if (subDeploymentMBean == null || subDeploymentMBean.getTargets() == null) {
            return appDeploymentMBean.getTargets();
        }
        return subDeploymentMBean.getTargets();
    }

    public static void addTargetFromComponent(AppDeploymentMBean appDeploymentMBean, ComponentMBean componentMBean, TargetMBean targetMBean) {
        SubDeploymentMBean subDeploymentMBean = MBeanConverter.findOrCreateSubDeployment(appDeploymentMBean, componentMBean);
        try {
            subDeploymentMBean.addTarget(targetMBean);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Object)invalidAttributeValueException);
        }
        catch (DistributedManagementException distributedManagementException) {
            throw new AssertionError((Object)distributedManagementException);
        }
    }

    public static void removeTargetFromComponent(AppDeploymentMBean appDeploymentMBean, ComponentMBean componentMBean, TargetMBean targetMBean) {
        SubDeploymentMBean subDeploymentMBean = MBeanConverter.findOrCreateSubDeployment(appDeploymentMBean, componentMBean);
        try {
            subDeploymentMBean.removeTarget(targetMBean);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Object)invalidAttributeValueException);
        }
        catch (DistributedManagementException distributedManagementException) {
            throw new AssertionError((Object)distributedManagementException);
        }
    }

    private static SubDeploymentMBean findSubDeployment(AppDeploymentMBean appDeploymentMBean, ComponentMBean componentMBean) {
        SubDeploymentMBean subDeploymentMBean = appDeploymentMBean.lookupSubDeployment(componentMBean.getName());
        if (subDeploymentMBean == null) {
            subDeploymentMBean = appDeploymentMBean.lookupSubDeployment(componentMBean.getURI());
        }
        return subDeploymentMBean;
    }

    private static SubDeploymentMBean findOrCreateSubDeployment(AppDeploymentMBean appDeploymentMBean, ComponentMBean componentMBean) {
        SubDeploymentMBean subDeploymentMBean = MBeanConverter.findSubDeployment(appDeploymentMBean, componentMBean);
        if (subDeploymentMBean == null) {
            subDeploymentMBean = appDeploymentMBean.createSubDeployment(componentMBean.getName());
        }
        return subDeploymentMBean;
    }

    private static void handleException(AppDeploymentMBean appDeploymentMBean, Throwable throwable) throws DeploymentException {
        Throwable throwable2;
        DeploymentException deploymentException = null;
        String string = DeploymentManagerLogger.logConfigureAppMBeanFailedLoggable(appDeploymentMBean.getName()).getMessage();
        deploymentException = throwable instanceof DeploymentException ? (DeploymentException)((Object)throwable) : (throwable instanceof NestedException ? ((throwable2 = ((NestedException)throwable).getNestedException()) == null ? new DeploymentException(string, throwable) : (throwable2 instanceof DeploymentException ? (DeploymentException)((Object)throwable2) : new DeploymentException(string, throwable2))) : new DeploymentException(string, throwable));
        DeploymentManagerLogger.logConversionToAppMBeanFailed(appDeploymentMBean.getName(), (Throwable)((Object)deploymentException));
        if (MBeanConverter.isDebugEnabled()) {
            deploymentException.printStackTrace();
        }
        throw deploymentException;
    }

    public static void setTargetsForComponent(AppDeploymentMBean appDeploymentMBean, ComponentMBean componentMBean, TargetMBean[] targetMBeanArray) {
    }

    private static ApplicationMBean createTEMPCompatMBean(AppDeploymentMBean appDeploymentMBean, DomainMBean domainMBean, String string) throws InvalidAttributeValueException, ManagementException, FileNotFoundException {
        ComponentMBean[] componentMBeanArray;
        File file = BootStrap.apply((String)string);
        if (!file.exists()) {
            throw new FileNotFoundException(file + " not found.");
        }
        ApplicationMBean applicationMBean = domainMBean.lookupApplication(appDeploymentMBean.getName());
        if (applicationMBean == null) {
            applicationMBean = domainMBean.createApplication(appDeploymentMBean.getName());
            applicationMBean.setAppDeployment(appDeploymentMBean);
            applicationMBean.setPath(file.getParent());
            applicationMBean.setDelegationEnabled(true);
        }
        if ((componentMBeanArray = applicationMBean.getComponents()) == null || componentMBeanArray.length == 0) {
            ComponentMBean componentMBean = MBeanConverter.createComponent(applicationMBean, file.getName());
            componentMBean.setTargets(appDeploymentMBean.getTargets());
            componentMBean.setURI(file.getName());
        }
        return applicationMBean;
    }

    private static ComponentMBean createComponent(ApplicationMBean applicationMBean, String string) throws ManagementException {
        ComponentMBean componentMBean;
        if (string.toLowerCase(Locale.US).endsWith("-jms.xml")) {
            componentMBean = applicationMBean.createDummyComponent(applicationMBean.getName());
        } else if (string.toLowerCase(Locale.US).endsWith("-jdbc.xml")) {
            componentMBean = applicationMBean.createJDBCPoolComponent(applicationMBean.getName());
        } else if (string.toLowerCase(Locale.US).endsWith("-interception.xml")) {
            componentMBean = applicationMBean.createDummyComponent(applicationMBean.getName());
        } else {
            String string2 = DeploymentManagerLogger.logUnknownDeployable(string);
            throw new DeploymentException(string2);
        }
        return componentMBean;
    }

    public static void debug(String string) {
        Debug.deploymentDebug(string);
    }

    public static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    public static void reconcile81MBeans(DeploymentData deploymentData, AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        if (appDeploymentMBean.getAppMBean() == null) {
            MBeanConverter.setupNew81MBean(appDeploymentMBean);
        } else {
            if (MBeanConverter.isDebugEnabled()) {
                MBeanConverter.debug("Reconcile appmbean for" + appDeploymentMBean.getObjectName());
            }
            String[] stringArray = deploymentData.getFiles();
            try {
                DeploymentManager.getDeploymentManager().getMBeanFactory().reconcileMBeans(appDeploymentMBean, AppDeployment.getFile(appDeploymentMBean));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DeploymentException(fileNotFoundException);
            }
            catch (ApplicationException applicationException) {
                throw new DeploymentException((Throwable)((Object)applicationException));
            }
        }
    }

    public static void setupNew81MBean(AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        DomainMBean domainMBean = (DomainMBean)appDeploymentMBean.getParent();
        if (appDeploymentMBean.getSourcePath().toLowerCase(Locale.US).endsWith("-jms.xml")) {
            return;
        }
        ApplicationMBean applicationMBean = MBeanConverter.createApplicationForAppDeployment(domainMBean, appDeploymentMBean, AppDeployment.getFile(appDeploymentMBean).getPath());
        if (applicationMBean != null) {
            applicationMBean.setAppDeployment(appDeploymentMBean);
        }
    }

    public static void remove81MBean(AppDeploymentMBean appDeploymentMBean) {
        DomainMBean domainMBean = (DomainMBean)appDeploymentMBean.getParent();
        ApplicationMBean applicationMBean = domainMBean.lookupApplication(appDeploymentMBean.getName());
        if (applicationMBean != null) {
            domainMBean.destroyApplication(applicationMBean);
        }
    }

    public static void addStagedTarget(AppDeploymentMBean appDeploymentMBean, String string) {
        ApplicationMBean applicationMBean = appDeploymentMBean.getAppMBean();
        if (applicationMBean != null) {
            applicationMBean.addStagedTarget(string);
        }
    }

    private static class SubDTargetDiffHandler
    implements ArrayUtils.DiffHandler {
        private final SubDeploymentMBean subDeployment;

        public SubDTargetDiffHandler(SubDeploymentMBean subDeploymentMBean) {
            this.subDeployment = subDeploymentMBean;
        }

        public void addObject(Object object) {
            try {
                this.subDeployment.addTarget((TargetMBean)object);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new AssertionError((Object)invalidAttributeValueException);
            }
            catch (DistributedManagementException distributedManagementException) {
                throw new AssertionError((Object)distributedManagementException);
            }
        }

        public void removeObject(Object object) {
            try {
                this.subDeployment.removeTarget((TargetMBean)object);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new AssertionError((Object)invalidAttributeValueException);
            }
            catch (DistributedManagementException distributedManagementException) {
                throw new AssertionError((Object)distributedManagementException);
            }
        }
    }
}

