/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import javax.management.MBeanException;
import javax.management.ObjectName;
import weblogic.management.DeploymentNotification;
import weblogic.management.deploy.DeploymentCompatibilityEvent;
import weblogic.management.deploy.DeploymentCompatibilityEventHandler;
import weblogic.management.deploy.DeploymentCompatibilityEventManager;
import weblogic.management.jmx.modelmbean.NotificationGenerator;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;

public class NotificationTranslator
implements DeploymentCompatibilityEventHandler {
    private ObjectName objName;
    private NotificationGenerator generator;

    public NotificationTranslator(WLSModelMBeanContext wLSModelMBeanContext, Object object, NotificationGenerator notificationGenerator) {
        this.generator = notificationGenerator;
        this.objName = notificationGenerator.getObjectName();
        ((DeploymentCompatibilityEventManager)object).addHandler(this);
    }

    public void handleEvent(DeploymentCompatibilityEvent deploymentCompatibilityEvent) {
        if (!this.generator.isSubscribed()) {
            return;
        }
        DeploymentNotification deploymentNotification = null;
        if ("weblogic.deployment.application.module".equals(deploymentCompatibilityEvent.getEventType())) {
            deploymentNotification = new DeploymentNotification(this.objName, this.generator.incrementSequenceNumber(), deploymentCompatibilityEvent.getServerName(), deploymentCompatibilityEvent.getApplicationName(), deploymentCompatibilityEvent.getModuleName(), deploymentCompatibilityEvent.getTransition(), deploymentCompatibilityEvent.getCurrentState(), deploymentCompatibilityEvent.getTargetState());
        } else if ("weblogic.deployment.application".equals(deploymentCompatibilityEvent.getEventType())) {
            deploymentNotification = new DeploymentNotification(this.objName, this.generator.incrementSequenceNumber(), deploymentCompatibilityEvent.getServerName(), deploymentCompatibilityEvent.getApplicationName(), deploymentCompatibilityEvent.getApplicationPhase());
            deploymentNotification.setTask(deploymentCompatibilityEvent.getTaskID());
        }
        if (deploymentNotification == null) {
            throw new AssertionError((Object)("Invalid Deployment Notfication Type " + deploymentCompatibilityEvent));
        }
        try {
            this.generator.sendNotification(deploymentNotification);
        }
        catch (MBeanException mBeanException) {
            throw new AssertionError((Object)mBeanException);
        }
    }
}

