/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.common.Debug;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.DeployerRuntimeImpl;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.DeploymentServerService;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManagerFactory;

public class RetirementManager {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final int RETIREMENT_SCHEDULED = 1;
    private static final int RETIREMENT_STARTED = 2;
    private static final int RETIREMENT_CANCELLED = 3;
    private static final String RETIRE_TASK_ID_PREFIX = "weblogic.retire.";
    private static final AppRuntimeStateManager appRTStateMgr = AppRuntimeStateManager.getManager();
    private static final Hashtable retireInfoMap = new Hashtable();
    private static HashMap retireOnRestartApps = null;
    private static int curTaskId = 0;
    private static Timer retireTimer = null;
    private static final int MAX_RETIRE_WAIT_TIME_SECS = 20;

    public static void retire(AppDeploymentMBean appDeploymentMBean, DeploymentData deploymentData) throws ManagementException {
        if (appDeploymentMBean == null) {
            return;
        }
        String string = appDeploymentMBean.getApplicationIdentifier();
        if (retireInfoMap.get(string) != null) {
            return;
        }
        int n = RetirementManager.getRetireTimeoutSecs(deploymentData);
        boolean bl = RetirementManager.getIgnoreSessions(deploymentData);
        int n2 = RetirementManager.getRMIGracePeriodSecs(deploymentData);
        long l = System.currentTimeMillis();
        if (n > 0) {
            l += (long)(n * 1000);
        }
        appRTStateMgr.setRetireTimeoutSeconds(string, n);
        appRTStateMgr.setRetireTimeMillis(string, l);
        if (n == -1) {
            DeployerRuntimeLogger.logRetireGracefully((String)ApplicationVersionUtils.getDisplayName(string));
            RetirementManager.stopForGracefulRetire(string, bl, n2);
        } else {
            RetirementManager.scheduleRetire(string, n, l, bl);
        }
    }

    public static void retireAppsOnStartup() {
        ArrayList arrayList = RetirementManager.getToBeRetiredApps();
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        if (serverRuntimeMBean != null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Registering " + arrayList.size() + " app(s) for retirement");
            }
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                hashMap.put(((AppDeploymentMBean)arrayList.get(i)).getApplicationIdentifier(), new Integer(1));
            }
            retireOnRestartApps = hashMap;
            serverRuntimeMBean.addPropertyChangeListener(new RetireOnRestartListener(arrayList));
        } else if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Cannot register apps for retirement");
        }
    }

    private static ArrayList getToBeRetiredApps() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (!runtimeAccess.isAdminServer()) {
            return null;
        }
        AppDeploymentMBean[] appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(runtimeAccess.getDomain());
        ArrayList<AppDeploymentMBean> arrayList = new ArrayList<AppDeploymentMBean>();
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            AppDeploymentMBean appDeploymentMBean = appDeploymentMBeanArray[i];
            if (appDeploymentMBean == null || appDeploymentMBean.getVersionIdentifier() == null || appDeploymentMBean instanceof LibraryMBean || appRTStateMgr.getCurrentState(appDeploymentMBean) == null || appRTStateMgr.isActiveVersion(appDeploymentMBean) || appRTStateMgr.isRetiredVersion(appDeploymentMBean) || appRTStateMgr.isFailedVersion(appDeploymentMBean)) continue;
            arrayList.add(appDeploymentMBean);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retireOnRestart(ArrayList arrayList) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("RetireOnRestart " + arrayList.size() + " app(s)");
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            RetirementManager.retireOnRestart((AppDeploymentMBean)object.next());
            object.remove();
        }
        object = retireInfoMap;
        synchronized (object) {
            retireOnRestartApps = null;
        }
    }

    private static void retireOnRestart(AppDeploymentMBean appDeploymentMBean) {
        if (appDeploymentMBean == null) {
            return;
        }
        String string = appDeploymentMBean.getApplicationIdentifier();
        int n = appRTStateMgr.getRetireTimeoutSeconds(string);
        long l = appRTStateMgr.getRetireTimeMillis(string);
        long l2 = System.currentTimeMillis();
        if (l <= 0L) {
            return;
        }
        if (l <= l2) {
            if (n == -1) {
                DeployerRuntimeLogger.logRetireGracefully((String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean));
                RetirementManager.retireNow(string, true, true);
            } else {
                DeployerRuntimeLogger.logRetireNow((String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean));
                RetirementManager.retireNow(string, false, true);
            }
        } else {
            RetirementManager.scheduleRetire(string, (int)((l - l2) / 1000L), l, true);
        }
    }

    private static void stopForGracefulRetire(String string, boolean bl, int n) {
        String string2 = RetirementManager.getRetireTaskId(string);
        RetireInfo retireInfo = new RetireInfo(2, string, string2, true, bl, n, System.currentTimeMillis());
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("RM.putRetireInfo for stop, app=" + retireInfo.appId + ", taskId=" + retireInfo.taskId);
        }
        retireInfoMap.put(string, retireInfo);
        RetirementManager.stopForGracefulRetire(retireInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retireNow(String string, boolean bl, boolean bl2) {
        String string2 = RetirementManager.getRetireTaskId(string);
        RetireInfo retireInfo = new RetireInfo(2, string, string2, bl, bl2, -1, System.currentTimeMillis());
        Hashtable hashtable = retireInfoMap;
        synchronized (hashtable) {
            if (retireOnRestartApps != null && retireOnRestartApps.containsKey(string) && (Integer)retireOnRestartApps.remove(string) == 3) {
                return;
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("RM.putRetireInfo for retireNow, app=" + retireInfo.appId + ", taskId=" + retireInfo.taskId);
            }
            retireInfoMap.put(string, retireInfo);
        }
        RetirementManager.retire(retireInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleRetire(String string, int n, long l, boolean bl) {
        DeployerRuntimeLogger.logRetireTimeout((String)ApplicationVersionUtils.getDisplayName(string), (int)n);
        String string2 = RetirementManager.getRetireTaskId(string);
        RetireInfo retireInfo = new RetireInfo(1, string, string2, false, bl, -1, l);
        Hashtable hashtable = retireInfoMap;
        synchronized (hashtable) {
            if (retireOnRestartApps != null && retireOnRestartApps.containsKey(string) && (Integer)retireOnRestartApps.remove(string) == 3) {
                return;
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("RM.putRetireInfo for scheduleRetire, app=" + retireInfo.appId + ", taskId=" + retireInfo.taskId);
            }
            retireInfoMap.put(string, retireInfo);
        }
        RetirementManager.startTimerIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancelIfNeeded(String string, String string2) throws ManagementException {
        RetireInfo retireInfo;
        String string3 = ApplicationVersionUtils.getApplicationId(string, string2);
        Hashtable hashtable = retireInfoMap;
        synchronized (hashtable) {
            if (retireOnRestartApps != null && retireOnRestartApps.containsKey(string3)) {
                retireOnRestartApps.put(string3, new Integer(3));
                return true;
            }
            retireInfo = (RetireInfo)retireInfoMap.get(string3);
        }
        if (retireInfo == null) {
            return true;
        }
        boolean bl = false;
        RetireInfo retireInfo2 = retireInfo;
        synchronized (retireInfo2) {
            if (retireInfo.state == 1) {
                retireInfo.state = 3;
                bl = true;
            } else if (retireInfo.state == 2) {
                return false;
            }
        }
        if (bl) {
            retireInfoMap.remove(string3);
            DeployerRuntimeLogger.logRetirementCancelled((String)ApplicationVersionUtils.getDisplayName(string, string2), (long)((retireInfo.retireTimeMillis - System.currentTimeMillis()) / 1000L));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRetirementInProgress(String string, String string2) {
        String string3 = ApplicationVersionUtils.getApplicationId(string, string2);
        Hashtable hashtable = retireInfoMap;
        synchronized (hashtable) {
            return retireInfoMap.get(string3) != null || retireOnRestartApps != null && retireOnRestartApps.containsKey(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForRetirementCompleteIfNeeded(String string, String string2) {
        String string3 = ApplicationVersionUtils.getApplicationId(string, string2);
        RetireInfo retireInfo = (RetireInfo)retireInfoMap.get(string3);
        if (retireInfo != null) {
            RetireInfo retireInfo2 = retireInfo;
            synchronized (retireInfo2) {
                try {
                    if (!retireInfo.notificationDone()) {
                        if (Debug.isDeploymentDebugEnabled()) {
                            Debug.deploymentDebug("RM.waitForRetirementComplete for, app=" + retireInfo.appId + ", taskId=" + retireInfo.taskId);
                        }
                        retireInfo.wait(20000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retireExpiredApps() {
        HashMap hashMap;
        Cloneable cloneable = retireInfoMap;
        synchronized (cloneable) {
            hashMap = new HashMap(retireInfoMap);
        }
        cloneable = new ArrayList();
        for (RetireInfo retireInfo : hashMap.values()) {
            long l = System.currentTimeMillis();
            RetireInfo retireInfo2 = retireInfo;
            synchronized (retireInfo2) {
                if (retireInfo.state != 1 || retireInfo.retireTimeMillis > l) {
                    continue;
                }
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("Retirement timer expired for app=" + retireInfo.appId);
                }
                retireInfo.state = 2;
            }
            ((ArrayList)cloneable).add(retireInfo);
        }
        RetirementManager.initiateRetire((ArrayList)cloneable);
    }

    private static void initiateRetire(final ArrayList arrayList) {
        WorkManagerFactory.getInstance().getDefault().schedule(new Runnable(){

            public void run() {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    RetirementManager.retire((RetireInfo)iterator.next());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retire(RetireInfo retireInfo) {
        AppDeploymentMBean appDeploymentMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupAppDeployment(retireInfo.appId);
        if (appDeploymentMBean == null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("RM.retire skip undeployed app=" + retireInfo.appId);
            }
            RetirementManager.retireTaskDone(retireInfo);
            RetireInfo retireInfo2 = retireInfo;
            synchronized (retireInfo2) {
                retireInfo.notifyAll();
                retireInfo.setNotificationDone(true);
            }
            return;
        }
        try {
            DeployerRuntimeImpl deployerRuntimeImpl = (DeployerRuntimeImpl)DeploymentServerService.getDeployerRuntime();
            if (deployerRuntimeImpl == null) {
                return;
            }
            DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = deployerRuntimeImpl.retire(retireInfo.appId, RetirementManager.getDeployData(retireInfo), retireInfo.taskId, false);
            if (deploymentTaskRuntimeMBean != null) {
                deploymentTaskRuntimeMBean.addPropertyChangeListener(new RetireTaskListener(retireInfo));
            }
            deploymentTaskRuntimeMBean.start();
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
    }

    private static void retireTaskDone(RetireInfo retireInfo) {
        if (retireInfo == null || retireInfo.appId == null || retireInfo.taskId == null) {
            return;
        }
        RetireInfo retireInfo2 = (RetireInfo)retireInfoMap.get(retireInfo.appId);
        if (retireInfo2 != null && retireInfo.taskId.equals(retireInfo2.taskId)) {
            retireInfoMap.remove(retireInfo2.appId);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("RM.retireTaskDone for app=" + retireInfo2.appId + ", taskId=" + retireInfo2.taskId);
            }
        }
    }

    private static void stopForGracefulRetire(RetireInfo retireInfo) {
        AppDeploymentMBean appDeploymentMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupAppDeployment(retireInfo.appId);
        if (appDeploymentMBean == null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("RM.stopForGracefulRetire skip app=" + retireInfo.appId);
            }
            return;
        }
        try {
            DeployerRuntimeImpl deployerRuntimeImpl = (DeployerRuntimeImpl)DeploymentServerService.getDeployerRuntime();
            if (deployerRuntimeImpl == null) {
                return;
            }
            DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = deployerRuntimeImpl.stopForGracefulRetire(retireInfo.appId, RetirementManager.getDeployData(retireInfo), retireInfo.taskId, false);
            if (deploymentTaskRuntimeMBean != null) {
                deploymentTaskRuntimeMBean.addPropertyChangeListener(new GracefulStopTaskListener(retireInfo));
            }
            deploymentTaskRuntimeMBean.start();
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
    }

    public static synchronized String getRetireTaskId(String string) {
        return RETIRE_TASK_ID_PREFIX + string + "." + curTaskId++;
    }

    public static boolean isRetireTaskId(String string) {
        return string != null && string.startsWith(RETIRE_TASK_ID_PREFIX);
    }

    private static int getRetireTimeoutSecs(DeploymentData deploymentData) {
        if (deploymentData == null || deploymentData.getDeploymentOptions() == null) {
            return -1;
        }
        return deploymentData.getDeploymentOptions().getRetireTime();
    }

    private static boolean getIgnoreSessions(DeploymentData deploymentData) {
        if (deploymentData == null || deploymentData.getDeploymentOptions() == null) {
            return false;
        }
        return deploymentData.getDeploymentOptions().isGracefulIgnoreSessions();
    }

    private static int getRMIGracePeriodSecs(DeploymentData deploymentData) {
        if (deploymentData == null || deploymentData.getDeploymentOptions() == null) {
            return -1;
        }
        return deploymentData.getDeploymentOptions().getRMIGracePeriodSecs();
    }

    private static DeploymentData getDeployData(RetireInfo retireInfo) {
        DeploymentData deploymentData = new DeploymentData();
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setRetireGracefully(retireInfo.graceful);
        if (retireInfo.graceful) {
            deploymentData.setTimeOut(Integer.MAX_VALUE);
            deploymentOptions.setTimeout(Long.MAX_VALUE);
        }
        deploymentOptions.setGracefulProductionToAdmin(retireInfo.graceful);
        deploymentOptions.setGracefulIgnoreSessions(retireInfo.ignoreSessions);
        deploymentOptions.setRMIGracePeriodSecs(retireInfo.rmiGracePeriodSecs);
        deploymentData.setDeploymentOptions(deploymentOptions);
        return deploymentData;
    }

    private static synchronized void startTimerIfNeeded() {
        if (retireTimer == null) {
            retireTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule(new TimerListener(){

                public void timerExpired(Timer timer) {
                    RetirementManager.retireExpiredApps();
                }
            }, 5000L, 5000L);
        }
    }

    private static class RetireOnRestartListener
    implements PropertyChangeListener {
        private ArrayList apps;

        private RetireOnRestartListener(ArrayList arrayList) {
            this.apps = arrayList;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("State") && (object = propertyChangeEvent.getNewValue()) instanceof String && ((String)object).equalsIgnoreCase("RUNNING")) {
                TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule(new TimerListener(){

                    public void timerExpired(Timer timer) {
                        RetirementManager.retireOnRestart(RetireOnRestartListener.this.apps);
                    }
                }, (long)(ManagementService.getRuntimeAccess(kernelId).getServer().getAdminReconnectIntervalSeconds() * 1000));
            }
        }
    }

    private static class RetireTaskListener
    implements PropertyChangeListener {
        private RetireInfo info;

        private RetireTaskListener(RetireInfo retireInfo) {
            this.info = retireInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n;
            Object object;
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("State") && (object = propertyChangeEvent.getNewValue()) instanceof Integer && ((n = ((Integer)object).intValue()) == 2 || n == 3 || n == 4)) {
                RetirementManager.retireTaskDone(this.info);
                RetireInfo retireInfo = this.info;
                synchronized (retireInfo) {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("RetireTaskListener.propertyChange for, app=" + this.info.appId + ", taskId=" + this.info.taskId);
                    }
                    this.info.notifyAll();
                    this.info.setNotificationDone(true);
                }
                try {
                    ((RuntimeMBeanDelegate)propertyChangeEvent.getSource()).removePropertyChangeListener((PropertyChangeListener)this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class GracefulStopTaskListener
    implements PropertyChangeListener {
        private RetireInfo info;

        private GracefulStopTaskListener(RetireInfo retireInfo) {
            this.info = retireInfo;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n;
            Object object;
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("State") && (object = propertyChangeEvent.getNewValue()) instanceof Integer && ((n = ((Integer)object).intValue()) == 2 || n == 3 || n == 4)) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("RM.stopForGracefulRetire done for app=" + this.info.appId + ", taskId=" + this.info.taskId);
                }
                RetirementManager.retireTaskDone(this.info);
                this.info.taskId = RetirementManager.getRetireTaskId(this.info.appId);
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("RM.putRetireInfo for retire, app=" + this.info.appId + ", taskId=" + this.info.taskId);
                }
                retireInfoMap.put(this.info.appId, this.info);
                RetirementManager.retire(this.info);
                try {
                    ((RuntimeMBeanDelegate)propertyChangeEvent.getSource()).removePropertyChangeListener((PropertyChangeListener)this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class RetireInfo {
        private int state;
        private String appId;
        private String taskId;
        private boolean graceful;
        private boolean ignoreSessions;
        private int rmiGracePeriodSecs;
        private long retireTimeMillis;
        private boolean notificationDone;

        RetireInfo(int n, String string, String string2, boolean bl, boolean bl2, int n2, long l) {
            this.state = n;
            this.appId = string;
            this.taskId = string2;
            this.graceful = bl;
            this.ignoreSessions = bl2;
            this.rmiGracePeriodSecs = n2;
            this.retireTimeMillis = l;
            this.notificationDone = false;
        }

        boolean notificationDone() {
            return this.notificationDone;
        }

        void setNotificationDone(boolean bl) {
            this.notificationDone = bl;
        }

        public String toString() {
            return "RetireInfo[appId=" + this.appId + ",taskId=" + this.taskId + ",state=" + this.state + "]";
        }
    }
}

