/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.status;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.management.TargetAvailabilityStatus;
import weblogic.management.deploy.internal.ComponentTarget;
import weblogic.management.deploy.status.ServerTargetAvailabilityStatus;
import weblogic.utils.Debug;

public abstract class BaseTargetAvailabilityStatus
implements Serializable,
TargetAvailabilityStatus {
    private static final long serialVersionUID = 346425021436708210L;
    protected String componentTargetName;
    protected int componentTargetType;
    protected boolean isStaged = false;
    protected HashSet availableServers = null;
    protected HashMap unavailableServersAvailabilityMap = null;

    public BaseTargetAvailabilityStatus(String string, int n, boolean bl) {
        this.componentTargetName = string;
        this.componentTargetType = n;
        this.isStaged = bl;
        this.availableServers = new HashSet();
        this.unavailableServersAvailabilityMap = new HashMap();
    }

    public String getTargetName() {
        return this.componentTargetName;
    }

    public int getTargetType() {
        return this.componentTargetType;
    }

    public int getDeploymentStatus() {
        int n = 0;
        if (this.unavailableServersAvailabilityMap.size() == 0 && this.availableServers.size() > 0) {
            n = 1;
        } else if (this.unavailableServersAvailabilityMap.size() > 0 && this.availableServers.size() > 0) {
            n = 2;
        }
        return n;
    }

    public int getAvailabilityStatus() {
        Debug.assertion((boolean)false, (String)"This is not a valid call");
        return -1;
    }

    public Set getServersAvailabilityStatus() {
        Iterator iterator = this.availableServers.iterator();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = new ServerTargetAvailabilityStatus(string, this.isStaged, true, 1);
            hashSet.add(object);
        }
        for (Object object : this.unavailableServersAvailabilityMap.keySet()) {
            int n = (Integer)this.unavailableServersAvailabilityMap.get(object);
            ServerTargetAvailabilityStatus serverTargetAvailabilityStatus = new ServerTargetAvailabilityStatus((String)object, this.isStaged, false, n);
            hashSet.add(serverTargetAvailabilityStatus);
        }
        return hashSet;
    }

    public Set getClustersAvailabilityStatus() {
        Debug.assertion((boolean)false, (String)"This is not a valid call");
        return null;
    }

    public void updateAvailabilityStatus(ComponentTarget componentTarget) {
        String string = componentTarget.getPhysicalTarget();
        if (this.unavailableServersAvailabilityMap.keySet().contains(string)) {
            this.unavailableServersAvailabilityMap.remove(string);
            this.availableServers.add(string);
        } else {
            String string2 = componentTarget.getComponentTarget() + " not targeted to " + string;
            Debug.assertion((boolean)false, (String)string2);
        }
    }

    public void updateUnavailabilityStatus(List list) {
        if (this.isStaged) {
            for (String string : this.unavailableServersAvailabilityMap.keySet()) {
                if (list.contains(string)) continue;
                this.unavailableServersAvailabilityMap.put(string, new Integer(3));
            }
        } else {
            Debug.assertion((boolean)false, (String)"updateUnavailabilityStatus applicable only for staged applications.");
        }
    }
}

