/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.status;

import weblogic.management.TargetAvailabilityStatus;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.deploy.status.BaseTargetAvailabilityStatus;
import weblogic.management.deploy.status.ClusterTargetAvailabilityStatus;
import weblogic.management.deploy.status.ServerTargetAvailabilityStatus;
import weblogic.management.deploy.status.VirtualHostTargetAvailabilityStatus;
import weblogic.utils.Debug;

public class StatusFactory {
    private static StatusFactory instance = new StatusFactory();

    public static StatusFactory getInstance() {
        return instance;
    }

    private StatusFactory() {
    }

    public TargetAvailabilityStatus createStatus(ApplicationMBean applicationMBean, ConfigurationMBean configurationMBean) {
        BaseTargetAvailabilityStatus baseTargetAvailabilityStatus = null;
        boolean bl = applicationMBean.getStagingMode().equals("stage");
        if (configurationMBean instanceof ServerMBean) {
            baseTargetAvailabilityStatus = new ServerTargetAvailabilityStatus((ServerMBean)configurationMBean, bl);
        } else if (configurationMBean instanceof ClusterMBean) {
            baseTargetAvailabilityStatus = new ClusterTargetAvailabilityStatus((ClusterMBean)configurationMBean, bl);
        } else if (configurationMBean instanceof VirtualHostMBean) {
            baseTargetAvailabilityStatus = new VirtualHostTargetAvailabilityStatus((VirtualHostMBean)configurationMBean, bl);
        } else {
            Debug.assertion((boolean)false, (String)"Invalid ConfigurationMBean");
        }
        return baseTargetAvailabilityStatus;
    }
}

