/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.status;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.deploy.internal.ComponentTarget;
import weblogic.management.deploy.status.BaseTargetAvailabilityStatus;
import weblogic.management.deploy.status.ClusterTargetAvailabilityStatus;
import weblogic.utils.Debug;

public class VirtualHostTargetAvailabilityStatus
extends BaseTargetAvailabilityStatus {
    private static final long serialVersionUID = 8676607003211923506L;
    private HashSet clusterSet = new HashSet();

    public VirtualHostTargetAvailabilityStatus(VirtualHostMBean virtualHostMBean, boolean bl) {
        super(virtualHostMBean.getName(), 3, bl);
        TargetMBean[] targetMBeanArray = virtualHostMBean.getTargets();
        if (targetMBeanArray != null) {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (targetMBeanArray[i] instanceof ClusterMBean) {
                    ClusterTargetAvailabilityStatus clusterTargetAvailabilityStatus = new ClusterTargetAvailabilityStatus((ClusterMBean)targetMBeanArray[i], bl);
                    this.clusterSet.add(clusterTargetAvailabilityStatus);
                    continue;
                }
                if (bl) {
                    this.unavailableServersAvailabilityMap.put(targetMBeanArray[i].getName(), new Integer(2));
                    continue;
                }
                this.unavailableServersAvailabilityMap.put(targetMBeanArray[i].getName(), new Integer(0));
            }
        }
    }

    public int getDeploymentStatus() {
        int n = 0;
        if (this.clusterSet.size() > 0) {
            Iterator iterator = this.clusterSet.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                ClusterTargetAvailabilityStatus clusterTargetAvailabilityStatus = (ClusterTargetAvailabilityStatus)iterator.next();
                if (n2 == 0) {
                    n = clusterTargetAvailabilityStatus.getDeploymentStatus();
                    ++n2;
                    continue;
                }
                if (n == clusterTargetAvailabilityStatus.getDeploymentStatus()) continue;
                n = 2;
            }
            if ((this.availableServers.size() > 0 || this.unavailableServersAvailabilityMap.size() > 0) && n != super.getDeploymentStatus()) {
                n = 2;
            }
        } else {
            n = super.getDeploymentStatus();
        }
        return n;
    }

    public Set getClustersAvailabilityStatus() {
        return this.clusterSet;
    }

    public void updateAvailabilityStatus(ComponentTarget componentTarget) {
        if (componentTarget.isVirtualHostClustered()) {
            String string = componentTarget.getClusterTarget();
            for (ClusterTargetAvailabilityStatus clusterTargetAvailabilityStatus : this.clusterSet) {
                if (!clusterTargetAvailabilityStatus.getTargetName().equals(string)) continue;
                clusterTargetAvailabilityStatus.updateAvailabilityStatus(componentTarget);
                break;
            }
        } else {
            super.updateAvailabilityStatus(componentTarget);
        }
    }

    public void updateUnavailabilityStatus(List list) {
        if (this.isStaged) {
            for (ClusterTargetAvailabilityStatus clusterTargetAvailabilityStatus : this.clusterSet) {
                clusterTargetAvailabilityStatus.updateUnavailabilityStatus(list);
            }
            super.updateUnavailabilityStatus(list);
        } else {
            Debug.assertion((boolean)false, (String)"updateUnavailabilityStatus applicable only for staged applications.");
        }
    }
}

