/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.descriptors.application.weblogic.jdbc;

import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.application.weblogic.jdbc.ConnectionCheckParamsMBean;
import weblogic.management.tools.ToXML;

public class ConnectionCheckParamsMBeanCustomImpl
extends XMLElementMBeanDelegate
implements ConnectionCheckParamsMBean {
    private String descrEncoding = null;
    private String descriptorVersion = null;
    private Integer inactiveConnectionTimeoutSeconds;
    private Integer creationRetryFrequencySeconds;
    private Integer reserveTimeoutSeconds;
    private Integer testFrequencySeconds;
    private Boolean checkOnCreateEnabled;
    private Boolean checkOnReleaseEnabled;
    private Boolean checkOnReserveEnabled;
    private String tableName;
    private String initTableName;
    private Integer refreshMinutes;

    public void setEncoding(String string) {
        this.descrEncoding = string;
    }

    public void setVersion(String string) {
        String string2 = this.descriptorVersion;
        this.descriptorVersion = string;
        this.checkChange("version", string2, string);
    }

    public void setConnectionCreationRetryFrequencySeconds(int n) {
        Integer n2 = this.creationRetryFrequencySeconds;
        this.creationRetryFrequencySeconds = new Integer(n);
        this.checkChange("creationRetryFrequencySeconds", n2, this.creationRetryFrequencySeconds);
    }

    public void setConnectionReserveTimeoutSeconds(int n) {
        Integer n2 = this.reserveTimeoutSeconds;
        this.reserveTimeoutSeconds = new Integer(n);
        this.checkChange("connectionReserveTimeoutSeconds", n2, this.reserveTimeoutSeconds);
    }

    public void setTestFrequencySeconds(int n) {
        Integer n2 = this.testFrequencySeconds;
        this.testFrequencySeconds = new Integer(n);
        this.checkChange("testFrequencySeconds", n2, this.testFrequencySeconds);
    }

    public void setInactiveConnectionTimeoutSeconds(int n) {
        Integer n2 = this.inactiveConnectionTimeoutSeconds;
        this.inactiveConnectionTimeoutSeconds = new Integer(n);
        this.checkChange("inactiveConnectionTimeoutSeconds", n2, this.inactiveConnectionTimeoutSeconds);
    }

    public void setCheckOnCreateEnabled(boolean bl) {
        Boolean bl2 = this.checkOnCreateEnabled;
        this.checkOnCreateEnabled = new Boolean(bl);
        this.checkChange("checkOnCreateEnabled", bl2, this.checkOnCreateEnabled);
    }

    public void setCheckOnReleaseEnabled(boolean bl) {
        Boolean bl2 = this.checkOnReleaseEnabled;
        this.checkOnReleaseEnabled = new Boolean(bl);
        this.checkChange("checkonreleaseenabled", bl2, this.checkOnReleaseEnabled);
    }

    public void setCheckOnReserveEnabled(boolean bl) {
        Boolean bl2 = this.checkOnReserveEnabled;
        this.checkOnReserveEnabled = new Boolean(bl);
        this.checkChange("checkOnReserveEnabled", bl2, this.checkOnReserveEnabled);
    }

    public void setInitSQL(String string) {
        String string2 = this.initTableName;
        this.initTableName = string;
        this.checkChange("initSQL", string2, string);
    }

    public void setTableName(String string) {
        String string2 = this.tableName;
        this.tableName = string;
        this.checkChange("tableName", string2, this.tableName);
    }

    public void setRefreshMinutes(int n) {
        Integer n2 = this.refreshMinutes;
        this.refreshMinutes = new Integer(n);
        this.checkChange("refreshMinutes", n2, this.refreshMinutes);
    }

    public String getEncoding() {
        return this.descrEncoding;
    }

    public String getVersion() {
        return this.descriptorVersion;
    }

    public int getConnectionCreationRetryFrequencySeconds() {
        return this.creationRetryFrequencySeconds != null ? this.creationRetryFrequencySeconds : 0;
    }

    public int getConnectionReserveTimeoutSeconds() {
        return this.reserveTimeoutSeconds != null ? this.reserveTimeoutSeconds : 10;
    }

    public int getTestFrequencySeconds() {
        return this.testFrequencySeconds != null ? this.testFrequencySeconds : 0;
    }

    public int getInactiveConnectionTimeoutSeconds() {
        return this.inactiveConnectionTimeoutSeconds != null ? this.inactiveConnectionTimeoutSeconds : 0;
    }

    public boolean isCheckOnCreateEnabled() {
        return this.checkOnCreateEnabled != null ? this.checkOnCreateEnabled : false;
    }

    public boolean isCheckOnReleaseEnabled() {
        return this.checkOnReleaseEnabled != null ? this.checkOnReleaseEnabled : false;
    }

    public boolean isCheckOnReserveEnabled() {
        return this.checkOnReserveEnabled != null ? this.checkOnReserveEnabled : false;
    }

    public String getInitSQL() {
        return this.initTableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getRefreshMinutes() {
        return this.refreshMinutes != null ? this.refreshMinutes : 0;
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ToXML.indent(n)).append("<connection-check-params");
        stringBuffer.append(">\n");
        if (null != this.getTableName()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<table-name>").append(this.getTableName()).append("</table-name>\n");
        }
        stringBuffer.append(ToXML.indent(n + 2)).append("<check-on-reserve-enabled>").append(ToXML.capitalize(new Boolean(this.isCheckOnReserveEnabled()).toString())).append("</check-on-reserve-enabled>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<check-on-release-enabled>").append(ToXML.capitalize(new Boolean(this.isCheckOnReleaseEnabled()).toString())).append("</check-on-release-enabled>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<refresh-minutes>").append(this.getRefreshMinutes()).append("</refresh-minutes>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<check-on-create-enabled>").append(ToXML.capitalize(new Boolean(this.isCheckOnCreateEnabled()).toString())).append("</check-on-create-enabled>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<connection-reserve-timeout-seconds>").append(this.getConnectionReserveTimeoutSeconds()).append("</connection-reserve-timeout-seconds>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<connection-creation-retry-frequency-seconds>").append(this.getConnectionCreationRetryFrequencySeconds()).append("</connection-creation-retry-frequency-seconds>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<inactive-connection-timeout-seconds>").append(this.getInactiveConnectionTimeoutSeconds()).append("</inactive-connection-timeout-seconds>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<test-frequency-seconds>").append(this.getTestFrequencySeconds()).append("</test-frequency-seconds>\n");
        if (null != this.getInitSQL()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<init-sql>").append(this.getInitSQL()).append("</init-sql>\n");
        }
        stringBuffer.append(ToXML.indent(n)).append("</connection-check-params>\n");
        return stringBuffer.toString();
    }
}

