/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.descriptors.application.weblogic.jdbc;

import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.application.weblogic.jdbc.ConnectionCheckParamsMBean;
import weblogic.management.descriptors.application.weblogic.jdbc.PoolParamsMBean;
import weblogic.management.descriptors.application.weblogic.jdbc.SizeParamsMBean;
import weblogic.management.descriptors.application.weblogic.jdbc.XaParamsMBean;
import weblogic.management.tools.ToXML;

public class PoolParamsMBeanCustomImpl
extends XMLElementMBeanDelegate
implements PoolParamsMBean {
    private String descrEncoding = null;
    private String descriptorVersion = null;
    private SizeParamsMBean sizeParams;
    private XaParamsMBean xaParams;
    private Integer loginDelay;
    private Integer secondsToTrustAnIdlePoolConnection;
    private Boolean leakProfilingEnabled;
    private ConnectionCheckParamsMBean connCheckParams;
    private Integer xaDebugLevel;
    private Boolean removeConnsEnabled;

    public void setEncoding(String string) {
        this.descrEncoding = string;
    }

    public void setVersion(String string) {
        String string2 = this.descriptorVersion;
        this.descriptorVersion = string;
        this.checkChange("version", string2, string);
    }

    public void setSizeParams(SizeParamsMBean sizeParamsMBean) {
        this.sizeParams = sizeParamsMBean;
    }

    public void setXaParams(XaParamsMBean xaParamsMBean) {
        this.xaParams = xaParamsMBean;
    }

    public void setLoginDelaySeconds(int n) {
        this.loginDelay = new Integer(n);
    }

    public void setSecondsToTrustAnIdlePoolConnection(int n) {
        this.secondsToTrustAnIdlePoolConnection = new Integer(n);
    }

    public void setLeakProfilingEnabled(boolean bl) {
        this.leakProfilingEnabled = new Boolean(bl);
    }

    public void setConnectionCheckParams(ConnectionCheckParamsMBean connectionCheckParamsMBean) {
        this.connCheckParams = connectionCheckParamsMBean;
    }

    public void setJDBCXADebugLevel(int n) {
        Integer n2 = this.xaDebugLevel;
        this.xaDebugLevel = new Integer(n);
        this.checkChange("JDBCXADebugLevel", n2, this.xaDebugLevel);
    }

    public void setRemoveInfectedConnectionsEnabled(boolean bl) {
        Boolean bl2 = this.removeConnsEnabled;
        this.removeConnsEnabled = new Boolean(bl);
        this.checkChange("RemoveInfectedConnectionsEnabled", bl2, this.removeConnsEnabled);
    }

    public String getEncoding() {
        return this.descrEncoding;
    }

    public String getVersion() {
        return this.descriptorVersion;
    }

    public SizeParamsMBean getSizeParams() {
        return this.sizeParams;
    }

    public XaParamsMBean getXaParams() {
        return this.xaParams;
    }

    public int getLoginDelaySeconds() {
        return this.loginDelay != null ? this.loginDelay : 0;
    }

    public int getSecondsToTrustAnIdlePoolConnection() {
        return this.secondsToTrustAnIdlePoolConnection != null ? this.secondsToTrustAnIdlePoolConnection : 0;
    }

    public boolean isLeakProfilingEnabled() {
        return this.leakProfilingEnabled != null ? this.leakProfilingEnabled : false;
    }

    public ConnectionCheckParamsMBean getConnectionCheckParams() {
        return this.connCheckParams;
    }

    public int getJDBCXADebugLevel() {
        return this.xaDebugLevel != null ? this.xaDebugLevel : 0;
    }

    public boolean isRemoveInfectedConnectionsEnabled() {
        return this.removeConnsEnabled != null ? this.removeConnsEnabled : true;
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ToXML.indent(n)).append("<pool-params");
        stringBuffer.append(">\n");
        if (null != this.getSizeParams()) {
            stringBuffer.append(this.getSizeParams().toXML(n + 2)).append("\n");
        }
        if (null != this.getXaParams()) {
            stringBuffer.append(this.getXaParams().toXML(n + 2)).append("\n");
        }
        stringBuffer.append(ToXML.indent(n + 2)).append("<login-delay-seconds>").append(this.getLoginDelaySeconds()).append("</login-delay-seconds>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<secs-to-trust-an-idle-pool-con>").append(this.getSecondsToTrustAnIdlePoolConnection()).append("</secs-to-trust-an-idle-pool-con>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<leak-profiling-enabled>").append(ToXML.capitalize(new Boolean(this.isLeakProfilingEnabled()).toString())).append("</leak-profiling-enabled>\n");
        if (null != this.getConnectionCheckParams()) {
            stringBuffer.append(this.getConnectionCheckParams().toXML(n + 2)).append("\n");
        }
        stringBuffer.append(ToXML.indent(n + 2)).append("<jdbcxa-debug-level>").append(this.getJDBCXADebugLevel()).append("</jdbcxa-debug-level>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<remove-infected-connections-enabled>").append(ToXML.capitalize(new Boolean(this.isRemoveInfectedConnectionsEnabled()).toString())).append("</remove-infected-connections-enabled>\n");
        stringBuffer.append(ToXML.indent(n)).append("</pool-params>\n");
        return stringBuffer.toString();
    }
}

