/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.descriptors.application.weblogic.jdbc;

import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.application.weblogic.jdbc.PreparedStatementMBean;
import weblogic.management.tools.ToXML;

public class PreparedStatementMBeanCustomImpl
extends XMLElementMBeanDelegate
implements PreparedStatementMBean {
    private String descrEncoding;
    private String descriptorVersion;
    private Boolean profilingEnabled;
    private Integer profilingThreshold;
    private Integer cacheSize;
    private Boolean paramLoggingEnabled;
    private Integer maxParamLen;
    private String cacheType;

    public void setEncoding(String string) {
        this.descrEncoding = string;
    }

    public String getEncoding() {
        return this.descrEncoding;
    }

    public void setVersion(String string) {
        String string2 = this.descriptorVersion;
        this.descriptorVersion = string;
        this.checkChange("version", this.descriptorVersion, string2);
    }

    public String getVersion() {
        return this.descriptorVersion;
    }

    public void setProfilingEnabled(boolean bl) {
        Boolean bl2 = this.profilingEnabled;
        this.profilingEnabled = new Boolean(bl);
        this.checkChange("profilingEnabled", bl2, this.profilingEnabled);
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled != null ? this.profilingEnabled : false;
    }

    public void setCacheProfilingThreshold(int n) {
        Integer n2 = this.profilingThreshold;
        this.profilingThreshold = new Integer(n);
        this.checkChange("cacheProfilingThreshold", n2, this.profilingThreshold);
    }

    public int getCacheProfilingThreshold() {
        return this.profilingThreshold != null ? this.profilingThreshold : 10;
    }

    public void setCacheSize(int n) {
        Integer n2 = this.cacheSize;
        this.cacheSize = new Integer(n);
        this.checkChange("cacheSize", n2, this.cacheSize);
    }

    public int getCacheSize() {
        return this.cacheSize != null ? this.cacheSize : 10;
    }

    public void setParameterLoggingEnabled(boolean bl) {
        Boolean bl2 = this.paramLoggingEnabled;
        this.paramLoggingEnabled = new Boolean(bl);
        this.checkChange("parameterLoggingEnabled", bl2, this.paramLoggingEnabled);
    }

    public boolean isParameterLoggingEnabled() {
        return this.paramLoggingEnabled != null ? this.paramLoggingEnabled : false;
    }

    public void setMaxParameterLength(int n) {
        Integer n2 = this.maxParamLen;
        this.maxParamLen = new Integer(n);
        this.checkChange("maxParameterLength", n2, this.maxParamLen);
    }

    public int getMaxParameterLength() {
        return this.maxParamLen != null ? this.maxParamLen : 10;
    }

    public void setCacheType(String string) {
        String string2 = this.cacheType;
        this.cacheType = new String(string);
        this.checkChange("cacheType", string2, this.cacheType);
    }

    public String getCacheType() {
        return this.cacheType != null ? this.cacheType : "LRU";
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ToXML.indent(n)).append("<prepared-statement");
        stringBuffer.append(">\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<profiling-enabled>").append(ToXML.capitalize(new Boolean(this.isProfilingEnabled()).toString())).append("</profiling-enabled>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<cache-profiling-threshold>").append(this.getCacheProfilingThreshold()).append("</cache-profiling-threshold>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<cache-size>").append(this.getCacheSize()).append("</cache-size>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<parameter-logging-enabled>").append(ToXML.capitalize(new Boolean(this.isParameterLoggingEnabled()).toString())).append("</parameter-logging-enabled>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<max-parameter-length>").append(this.getMaxParameterLength()).append("</max-parameter-length>\n");
        if (null != this.getCacheType()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<cache-type>").append(this.getCacheType()).append("</cache-type>\n");
        }
        stringBuffer.append(ToXML.indent(n)).append("</prepared-statement>\n");
        return stringBuffer.toString();
    }
}

