/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.descriptors.application.weblogic.jdbc;

import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.application.weblogic.jdbc.SizeParamsMBean;
import weblogic.management.tools.ToXML;

public class SizeParamsMBeanCustomImpl
extends XMLElementMBeanDelegate
implements SizeParamsMBean {
    private String descrEncoding = null;
    private String descriptorVersion = null;
    private Integer initialCapacity;
    private Integer maxCapacity;
    private Integer capacityIncrement;
    private Boolean shrinkingEnabled;
    private Integer shrinkPeriodMinutes;
    private Integer shrinkFrequencySeconds;
    private Integer highestNumWaiters;
    private Integer highestNumUnavailable;

    public void setEncoding(String string) {
        this.descrEncoding = string;
    }

    public void setVersion(String string) {
        String string2 = this.descriptorVersion;
        this.descriptorVersion = string;
        this.checkChange("version", string2, this.descriptorVersion);
    }

    public void setInitialCapacity(int n) {
        Integer n2 = this.initialCapacity;
        this.initialCapacity = new Integer(n);
        this.checkChange("initialCapacity", n2, this.initialCapacity);
    }

    public void setMaxCapacity(int n) {
        Integer n2 = this.maxCapacity;
        this.maxCapacity = new Integer(n);
        this.checkChange("maxCapacity", n2, this.maxCapacity);
    }

    public void setCapacityIncrement(int n) {
        Integer n2 = this.capacityIncrement;
        this.capacityIncrement = new Integer(n);
        this.checkChange("capacityIncrement", n2, this.capacityIncrement);
    }

    public void setShrinkingEnabled(boolean bl) {
        Boolean bl2 = this.shrinkingEnabled;
        this.shrinkingEnabled = new Boolean(bl);
        this.checkChange("shrinkingEnabled", bl2, this.shrinkingEnabled);
    }

    public void setShrinkPeriodMinutes(int n) {
        Integer n2 = this.shrinkPeriodMinutes;
        this.shrinkPeriodMinutes = new Integer(n);
        this.checkChange("shrinkPeriodMinutes", n2, this.shrinkPeriodMinutes);
    }

    public void setShrinkFrequencySeconds(int n) {
        Integer n2 = this.shrinkFrequencySeconds;
        this.shrinkFrequencySeconds = new Integer(n);
        this.checkChange("shrinkFrequencySeconds", n2, this.shrinkFrequencySeconds);
    }

    public void setHighestNumWaiters(int n) {
        Integer n2 = this.highestNumWaiters;
        this.highestNumWaiters = new Integer(n);
        this.checkChange("highestNumWaiters", n2, this.highestNumWaiters);
    }

    public void setHighestNumUnavailable(int n) {
        Integer n2 = this.highestNumUnavailable;
        this.highestNumUnavailable = new Integer(n);
        this.checkChange("highestNumUnavailable", n2, this.highestNumUnavailable);
    }

    public String getEncoding() {
        return this.descrEncoding;
    }

    public String getVersion() {
        return this.descriptorVersion;
    }

    public int getInitialCapacity() {
        return this.initialCapacity != null ? this.initialCapacity : 1;
    }

    public int getMaxCapacity() {
        return this.maxCapacity != null ? this.maxCapacity : 15;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement != null ? this.capacityIncrement : 1;
    }

    public boolean isShrinkingEnabled() {
        return this.shrinkingEnabled != null ? this.shrinkingEnabled : true;
    }

    public int getShrinkPeriodMinutes() {
        return this.shrinkPeriodMinutes != null ? this.shrinkPeriodMinutes : 15;
    }

    public int getShrinkFrequencySeconds() {
        return this.shrinkFrequencySeconds != null ? this.shrinkFrequencySeconds : 900;
    }

    public int getHighestNumWaiters() {
        return this.highestNumWaiters != null ? this.highestNumWaiters : Integer.MAX_VALUE;
    }

    public int getHighestNumUnavailable() {
        return this.highestNumUnavailable != null ? this.highestNumUnavailable : 0;
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ToXML.indent(n)).append("<size-params");
        stringBuffer.append(">\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<initial-capacity>").append(this.getInitialCapacity()).append("</initial-capacity>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<max-capacity>").append(this.getMaxCapacity()).append("</max-capacity>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<capacity-increment>").append(this.getCapacityIncrement()).append("</capacity-increment>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<shrinking-enabled>").append(ToXML.capitalize(new Boolean(this.isShrinkingEnabled()).toString())).append("</shrinking-enabled>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<shrink-period-minutes>").append(this.getShrinkPeriodMinutes()).append("</shrink-period-minutes>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<shrink-frequency-seconds>").append(this.getShrinkFrequencySeconds()).append("</shrink-frequency-seconds>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<highest-num-waiters>").append(this.getHighestNumWaiters()).append("</highest-num-waiters>\n");
        stringBuffer.append(ToXML.indent(n + 2)).append("<highest-num-unavailable>").append(this.getHighestNumUnavailable()).append("</highest-num-unavailable>\n");
        stringBuffer.append(ToXML.indent(n)).append("</size-params>\n");
        return stringBuffer.toString();
    }
}

