/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.descriptors.toplevel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.management.descriptors.BaseXMLElementMBeanImpl;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.Encoding;
import weblogic.management.descriptors.XMLElementMBean;
import weblogic.management.descriptors.cmp11.WeblogicRDBMSJarMBean;
import weblogic.management.descriptors.cmp20.WeblogicRDBMSBeanMBean;
import weblogic.management.descriptors.ejb11.EJBJarMBean;
import weblogic.management.descriptors.ejb20.EJBJarMBeanImpl;
import weblogic.management.descriptors.ejb20.EnterpriseBeansMBeanImpl;
import weblogic.management.descriptors.toplevel.EJBDescriptorMBean;
import weblogic.management.descriptors.weblogic.WeblogicEJBJarMBean;
import weblogic.management.descriptors.weblogic.WeblogicEJBJarMBeanImpl;
import weblogic.utils.FileUtils;
import weblogic.utils.io.XMLWriter;
import weblogic.utils.jars.RandomAccessJarFile;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class EJBDescriptorMBeanImpl
extends BaseXMLElementMBeanImpl
implements EJBDescriptorMBean {
    private static final String EJB11_DT = "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN' 'http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd'>";
    private static final String EJB20_DT = "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>";
    private static final String WL_EJB20_DT = "<!DOCTYPE weblogic-ejb-jar PUBLIC '-//BEA Systems, Inc.//DTD WebLogic 8.1.0 EJB//EN' 'http://www.bea.com/servers/wls810/dtd/weblogic-ejb-jar.dtd'>";
    private static final String WL_CMP11_DT = "<!DOCTYPE weblogic-rdbms-jar PUBLIC  '-//BEA Systems, Inc.//DTD WebLogic 6.0.0 EJB 1.1 RDBMS Persistence//EN' 'http://www.bea.com/servers/wls600/dtd/weblogic-rdbms11-persistence-600.dtd'>";
    private static final String WL_CMP20_DT = "<!DOCTYPE weblogic-rdbms-jar PUBLIC  '-//BEA Systems, Inc.//DTD WebLogic 8.1.0 EJB RDBMS Persistence//EN' 'http://www.bea.com/servers/wls810/dtd/weblogic-rdbms20-persistence-810.dtd'>";
    private String m_jarFileName;
    private EJBJarMBean m_ejbJar;
    private EjbJarBean ejbJarBean;
    private WeblogicEJBJarMBean m_wlJar;
    private Set m_cmpDescs = new HashSet();
    private Set m_cmp20Descs = new HashSet();
    private String persistentDestination = null;
    private String parsingErrorMessage = null;

    public EJBDescriptorMBeanImpl() {
        EJBJarMBeanImpl eJBJarMBeanImpl = new EJBJarMBeanImpl();
        eJBJarMBeanImpl.setEnterpriseBeans(new EnterpriseBeansMBeanImpl());
        this.setEJBJarMBean(eJBJarMBeanImpl);
        this.setWeblogicEJBJarMBean(new WeblogicEJBJarMBeanImpl());
    }

    private static void ppp(String string) {
        System.out.println("[EJBDescriptorMBeanImpl] " + string);
    }

    public String getParsingErrorMessage() {
        return this.parsingErrorMessage;
    }

    public String getJarFileName() {
        return this.m_jarFileName;
    }

    public EjbJarBean getEjbJarBean() {
        return this.ejbJarBean;
    }

    public EJBJarMBean getEJBJarMBean() {
        return this.m_ejbJar;
    }

    public WeblogicEJBJarMBean getWeblogicEJBJarMBean() {
        return this.m_wlJar;
    }

    public WeblogicRDBMSJarMBean[] getWeblogicRDBMSJarMBeans() {
        return this.m_cmpDescs.toArray(new WeblogicRDBMSJarMBean[this.m_cmpDescs.size()]);
    }

    public weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean[] getWeblogicRDBMSJar20MBeans() {
        return this.m_cmp20Descs.toArray(new weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean[this.m_cmp20Descs.size()]);
    }

    public Set getRDBMSDescriptorFileNames() {
        HashSet hashSet = new HashSet();
        Map map = this.get11RDBMSDescriptorMap();
        hashSet.addAll(map.values());
        Map map2 = this.get20RDBMSDescriptorMap();
        hashSet.addAll(map2.values());
        return hashSet;
    }

    public Map get11RDBMSDescriptorMap() {
        HashMap<WeblogicRDBMSJarMBean, Object> hashMap = new HashMap<WeblogicRDBMSJarMBean, Object>();
        for (WeblogicRDBMSJarMBean weblogicRDBMSJarMBean : this.m_cmpDescs) {
            Object v;
            weblogic.management.descriptors.cmp11.WeblogicRDBMSBeanMBean[] weblogicRDBMSBeanMBeanArray = weblogicRDBMSJarMBean.getWeblogicRDBMSBeans();
            if (weblogicRDBMSBeanMBeanArray.length <= 0) continue;
            String string = weblogicRDBMSBeanMBeanArray[0].getEJBName();
            Object var6_6 = null;
            if (var6_6 == null || (v = null) == null) continue;
            hashMap.put(weblogicRDBMSJarMBean, v);
        }
        return hashMap;
    }

    public Map get20RDBMSDescriptorMap() {
        HashMap<weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean, Object> hashMap = new HashMap<weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean, Object>();
        for (weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean weblogicRDBMSJarMBean : this.m_cmp20Descs) {
            Object v;
            WeblogicRDBMSBeanMBean[] weblogicRDBMSBeanMBeanArray = weblogicRDBMSJarMBean.getWeblogicRDBMSBeans();
            if (weblogicRDBMSBeanMBeanArray.length <= 0) continue;
            String string = weblogicRDBMSBeanMBeanArray[0].getEJBName();
            Object var6_6 = null;
            if (var6_6 == null || (v = null) == null) continue;
            hashMap.put(weblogicRDBMSJarMBean, v);
        }
        return hashMap;
    }

    public void setParsingErrorMessage(String string) {
        this.parsingErrorMessage = string;
    }

    public void setJarFileName(String string) {
        this.m_jarFileName = string;
    }

    public void setEjbJarBean(EjbJarBean ejbJarBean) {
        this.ejbJarBean = ejbJarBean;
    }

    public void setEJBJarMBean(EJBJarMBean eJBJarMBean) {
        this.m_ejbJar = eJBJarMBean;
    }

    public void setWeblogicEJBJarMBean(WeblogicEJBJarMBean weblogicEJBJarMBean) {
        this.m_wlJar = weblogicEJBJarMBean;
    }

    public void setWeblogicRDBMSJarMBeans(WeblogicRDBMSJarMBean[] weblogicRDBMSJarMBeanArray) {
        this.m_cmpDescs.clear();
        this.m_cmpDescs.addAll(Arrays.asList((Object[])weblogicRDBMSJarMBeanArray));
    }

    public void setWeblogicRDBMSJar20MBeans(weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean[] weblogicRDBMSJarMBeanArray) {
        this.m_cmp20Descs.clear();
        this.m_cmp20Descs.addAll(Arrays.asList((Object[])weblogicRDBMSJarMBeanArray));
    }

    public void addWeblogicRDBMSJarMBean(WeblogicRDBMSJarMBean weblogicRDBMSJarMBean) {
        this.m_cmpDescs.add(weblogicRDBMSJarMBean);
    }

    public void removeWeblogicRDBMSJarMBean(WeblogicRDBMSJarMBean weblogicRDBMSJarMBean) {
        this.m_cmpDescs.remove(weblogicRDBMSJarMBean);
    }

    public void addWeblogicRDBMSJar20MBean(weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean weblogicRDBMSJarMBean) {
        this.m_cmp20Descs.add(weblogicRDBMSJarMBean);
    }

    public void removeWeblogicRDBMSJar20MBean(weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean weblogicRDBMSJarMBean) {
        this.m_cmp20Descs.remove(weblogicRDBMSJarMBean);
    }

    public void validate() throws DescriptorValidationException {
        String string = "tempValidationDir";
        File file = new File(string);
        try {
            file.mkdir();
            this.persist(string, null);
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
        }
        catch (Exception exception) {
            throw new DescriptorValidationException("Error during validation", exception);
        }
        finally {
            FileUtils.remove((File)file);
        }
    }

    public void usePersistenceDestination(String string) {
        this.persistentDestination = string;
    }

    public void persist(Properties properties) throws IOException {
        this.persist(this.persistentDestination, properties);
    }

    public void persist() throws IOException {
        this.persist(this.persistentDestination, null);
    }

    public void persist(String string, Properties properties) throws IOException {
        if (string == null) {
            throw new RuntimeException("No persistentDestination set!");
        }
        File file = new File(string);
        if (file.isDirectory()) {
            this.persistToDirectory(file, properties);
        } else {
            this.persistToJarFile(file, properties);
        }
    }

    public void persistEJBJarDescriptor(OutputStream outputStream, boolean bl) throws IOException {
        if (this.m_ejbJar instanceof weblogic.management.descriptors.ejb20.EJBJarMBean) {
            weblogic.management.descriptors.ejb20.EJBJarMBean eJBJarMBean = (weblogic.management.descriptors.ejb20.EJBJarMBean)this.m_ejbJar;
            String string = eJBJarMBean.getEncoding();
            if (string != null) {
                this.persistDescriptor(outputStream, EJB20_DT, eJBJarMBean, bl, string);
            } else {
                this.persistDescriptor(outputStream, EJB20_DT, eJBJarMBean, bl);
            }
        } else {
            String string = this.m_ejbJar.getEncoding();
            if (string != null) {
                this.persistDescriptor(outputStream, EJB11_DT, this.m_ejbJar, bl, string);
            } else {
                this.persistDescriptor(outputStream, EJB11_DT, this.m_ejbJar, bl);
            }
        }
    }

    public void persistWLEJBJarDescriptor(OutputStream outputStream, boolean bl) throws IOException {
        String string = this.m_wlJar.getEncoding();
        if (string != null) {
            this.persistDescriptor(outputStream, WL_EJB20_DT, this.m_wlJar, bl, string);
        } else {
            this.persistDescriptor(outputStream, WL_EJB20_DT, this.m_wlJar, bl);
        }
    }

    public void persist11RDBMSJarDescriptor(OutputStream outputStream, WeblogicRDBMSJarMBean weblogicRDBMSJarMBean, boolean bl) throws IOException {
        String string = weblogicRDBMSJarMBean.getEncoding();
        if (string != null) {
            this.persistDescriptor(outputStream, WL_CMP11_DT, weblogicRDBMSJarMBean, bl, string);
        } else {
            this.persistDescriptor(outputStream, WL_CMP11_DT, weblogicRDBMSJarMBean, bl);
        }
    }

    public void persist20RDBMSJarDescriptor(OutputStream outputStream, weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean weblogicRDBMSJarMBean, boolean bl) throws IOException {
        String string = weblogicRDBMSJarMBean.getEncoding();
        if (string != null) {
            this.persistDescriptor(outputStream, WL_CMP20_DT, weblogicRDBMSJarMBean, bl, string);
        } else {
            this.persistDescriptor(outputStream, WL_CMP20_DT, weblogicRDBMSJarMBean, bl);
        }
    }

    private void persistToDirectory(File file, Properties properties) throws IOException {
        Object object;
        Serializable serializable2;
        Object object22;
        File file2 = new File(file + File.separator + "META-INF");
        file2.mkdirs();
        File file3 = new File(file2, "ejb-jar.xml");
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        this.persistEJBJarDescriptor(fileOutputStream, true);
        File file4 = new File(file2, "weblogic-ejb-jar.xml");
        FileOutputStream fileOutputStream2 = new FileOutputStream(file4);
        this.persistWLEJBJarDescriptor(fileOutputStream2, true);
        Map map = this.get11RDBMSDescriptorMap();
        for (Object object22 : map.keySet()) {
            String string = (String)map.get(object22);
            serializable2 = new File(file, string);
            ((File)serializable2).getParentFile().mkdirs();
            object = new FileOutputStream((File)serializable2);
            this.persist11RDBMSJarDescriptor((OutputStream)object, (WeblogicRDBMSJarMBean)object22, true);
        }
        object22 = this.get20RDBMSDescriptorMap();
        for (Serializable serializable2 : object22.keySet()) {
            object = (String)object22.get(serializable2);
            File file5 = new File(file, (String)object);
            FileOutputStream fileOutputStream3 = new FileOutputStream(file5);
            this.persist20RDBMSJarDescriptor(fileOutputStream3, (weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean)serializable2, true);
        }
        if (properties != null) {
            serializable2 = new File(file2.getPath(), "_wl_dynamic_change_list.properties");
            object = new FileOutputStream((File)serializable2);
            properties.store((OutputStream)object, "Dynamic DD change list");
            ((FileOutputStream)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistToJarFile(File file, Properties properties) throws IOException {
        String string = ".";
        RandomAccessJarFile randomAccessJarFile = new RandomAccessJarFile(new File(string), file);
        try {
            Object object3;
            Object object22;
            OutputStream outputStream = randomAccessJarFile.writeEntry("META-INF/ejb-jar.xml", true);
            this.persistEJBJarDescriptor(outputStream, true);
            OutputStream outputStream2 = randomAccessJarFile.writeEntry("META-INF/weblogic-ejb-jar.xml", true);
            this.persistWLEJBJarDescriptor(outputStream2, true);
            Map map = this.get11RDBMSDescriptorMap();
            for (Object object22 : map.keySet()) {
                String string2 = (String)map.get(object22);
                object3 = randomAccessJarFile.writeEntry(string2, true);
                this.persist11RDBMSJarDescriptor((OutputStream)object3, (WeblogicRDBMSJarMBean)object22, true);
            }
            object22 = this.get20RDBMSDescriptorMap();
            for (Object object3 : object22.keySet()) {
                String string3 = (String)object22.get(object3);
                OutputStream outputStream3 = randomAccessJarFile.writeEntry(string3, true);
                this.persist20RDBMSJarDescriptor(outputStream3, (weblogic.management.descriptors.cmp20.WeblogicRDBMSJarMBean)object3, true);
            }
            if (properties != null) {
                object3 = randomAccessJarFile.writeEntry("META-INF/_wl_dynamic_change_list.properties", true);
                properties.store((OutputStream)object3, "Dynamic DD change list");
                ((OutputStream)object3).close();
            }
        }
        finally {
            if (randomAccessJarFile != null) {
                randomAccessJarFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistDescriptor(OutputStream outputStream, String string, XMLElementMBean xMLElementMBean, boolean bl) throws IOException {
        XMLWriter xMLWriter = null;
        try {
            xMLWriter = new XMLWriter(outputStream);
            xMLWriter.println(string + "\n\n");
            xMLWriter.println("<!-- Generated XML! -->\n");
            xMLWriter.print(xMLElementMBean.toXML(0));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        finally {
            if (xMLWriter != null) {
                xMLWriter.flush();
                if (bl) {
                    xMLWriter.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistDescriptor(OutputStream outputStream, String string, XMLElementMBean xMLElementMBean, boolean bl, String string2) throws IOException {
        XMLWriter xMLWriter = null;
        try {
            String string3 = Encoding.getIANA2JavaMapping(string2);
            if (string3 == null) {
                string3 = Encoding.getJava2IANAMapping(string2);
            }
            if (string3 == null) {
                if (Charset.isSupported(string2)) {
                    string3 = string2;
                } else {
                    throw new UnsupportedEncodingException("Unsupported encoding " + string2);
                }
            }
            xMLWriter = new XMLWriter(outputStream, string3);
            xMLWriter.println("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
            xMLWriter.println(string + "\n\n");
            xMLWriter.println("<!-- Generated XML! -->\n");
            xMLWriter.print(xMLElementMBean.toXML(0));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        finally {
            if (xMLWriter != null) {
                xMLWriter.flush();
                if (bl) {
                    xMLWriter.close();
                }
            }
        }
    }
}

