/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.descriptors.weblogic;

import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.weblogic.EntityCacheMBean;
import weblogic.management.tools.ToXML;

public class EntityCacheMBeanImpl
extends XMLElementMBeanDelegate
implements EntityCacheMBean {
    static final long serialVersionUID = 1L;
    private boolean isSet_maxBeansInCache = false;
    private int maxBeansInCache = 1000;
    private boolean isSet_cacheBetweenTransactions = false;
    private boolean cacheBetweenTransactions = false;
    private boolean isSet_readTimeoutSeconds = false;
    private int readTimeoutSeconds = 600;
    private boolean isSet_idleTimeoutSeconds = false;
    private int idleTimeoutSeconds = 600;
    private boolean isSet_concurrencyStrategy = false;
    private String concurrencyStrategy = "Database";

    public int getMaxBeansInCache() {
        return this.maxBeansInCache;
    }

    public void setMaxBeansInCache(int n) {
        int n2 = this.maxBeansInCache;
        this.maxBeansInCache = n;
        this.isSet_maxBeansInCache = n != -1;
        this.checkChange("maxBeansInCache", n2, this.maxBeansInCache);
    }

    public boolean getCacheBetweenTransactions() {
        return this.cacheBetweenTransactions;
    }

    public void setCacheBetweenTransactions(boolean bl) {
        boolean bl2 = this.cacheBetweenTransactions;
        this.cacheBetweenTransactions = bl;
        this.isSet_cacheBetweenTransactions = true;
        this.checkChange("cacheBetweenTransactions", bl2, this.cacheBetweenTransactions);
    }

    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(int n) {
        int n2 = this.readTimeoutSeconds;
        this.readTimeoutSeconds = n;
        this.isSet_readTimeoutSeconds = n != -1;
        this.checkChange("readTimeoutSeconds", n2, this.readTimeoutSeconds);
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void setIdleTimeoutSeconds(int n) {
        int n2 = this.idleTimeoutSeconds;
        this.idleTimeoutSeconds = n;
        this.isSet_idleTimeoutSeconds = n != -1;
        this.checkChange("idleTimeoutSeconds", n2, this.idleTimeoutSeconds);
    }

    public String getConcurrencyStrategy() {
        return this.concurrencyStrategy;
    }

    public void setConcurrencyStrategy(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        String string2 = this.concurrencyStrategy;
        this.concurrencyStrategy = string;
        this.isSet_concurrencyStrategy = string != null;
        this.checkChange("concurrencyStrategy", string2, this.concurrencyStrategy);
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ToXML.indent(n)).append("<entity-cache");
        stringBuffer.append(">\n");
        if (this.isSet_maxBeansInCache || 1000 != this.getMaxBeansInCache()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<max-beans-in-cache>").append(this.getMaxBeansInCache()).append("</max-beans-in-cache>\n");
        }
        if (this.isSet_idleTimeoutSeconds || 600 != this.getIdleTimeoutSeconds()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<idle-timeout-seconds>").append(this.getIdleTimeoutSeconds()).append("</idle-timeout-seconds>\n");
        }
        if (this.isSet_readTimeoutSeconds || 600 != this.getReadTimeoutSeconds()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<read-timeout-seconds>").append(this.getReadTimeoutSeconds()).append("</read-timeout-seconds>\n");
        }
        if ((this.isSet_concurrencyStrategy || !"Database".equals(this.getConcurrencyStrategy())) && null != this.getConcurrencyStrategy()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<concurrency-strategy>").append(this.getConcurrencyStrategy()).append("</concurrency-strategy>\n");
        }
        if (this.isSet_cacheBetweenTransactions || this.getCacheBetweenTransactions()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<cache-between-transactions>").append(ToXML.capitalize(Boolean.valueOf(this.getCacheBetweenTransactions()).toString())).append("</cache-between-transactions>\n");
        }
        stringBuffer.append(ToXML.indent(n)).append("</entity-cache>\n");
        return stringBuffer.toString();
    }
}

