/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.descriptors.weblogic;

import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.weblogic.StatefulSessionCacheMBean;
import weblogic.management.tools.ToXML;

public class StatefulSessionCacheMBeanImpl
extends XMLElementMBeanDelegate
implements StatefulSessionCacheMBean {
    static final long serialVersionUID = 1L;
    private boolean isSet_cacheType = false;
    private String cacheType = "NRU";
    private boolean isSet_maxBeansInCache = false;
    private int maxBeansInCache = 1000;
    private boolean isSet_sessionTimeoutSeconds = false;
    private int sessionTimeoutSeconds = 600;
    private boolean isSet_idleTimeoutSeconds = false;
    private int idleTimeoutSeconds = 600;

    public String getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        String string2 = this.cacheType;
        this.cacheType = string;
        this.isSet_cacheType = string != null;
        this.checkChange("cacheType", string2, this.cacheType);
    }

    public int getMaxBeansInCache() {
        return this.maxBeansInCache;
    }

    public void setMaxBeansInCache(int n) {
        int n2 = this.maxBeansInCache;
        this.maxBeansInCache = n;
        this.isSet_maxBeansInCache = n != -1;
        this.checkChange("maxBeansInCache", n2, this.maxBeansInCache);
    }

    public int getSessionTimeoutSeconds() {
        return this.sessionTimeoutSeconds;
    }

    public void setSessionTimeoutSeconds(int n) {
        int n2 = this.sessionTimeoutSeconds;
        this.sessionTimeoutSeconds = n;
        this.isSet_sessionTimeoutSeconds = n != -1;
        this.checkChange("sessionTimeoutSeconds", n2, this.sessionTimeoutSeconds);
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void setIdleTimeoutSeconds(int n) {
        int n2 = this.idleTimeoutSeconds;
        this.idleTimeoutSeconds = n;
        this.isSet_idleTimeoutSeconds = n != -1;
        this.checkChange("idleTimeoutSeconds", n2, this.idleTimeoutSeconds);
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ToXML.indent(n)).append("<stateful-session-cache");
        stringBuffer.append(">\n");
        if (this.isSet_maxBeansInCache || 1000 != this.getMaxBeansInCache()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<max-beans-in-cache>").append(this.getMaxBeansInCache()).append("</max-beans-in-cache>\n");
        }
        if (this.isSet_idleTimeoutSeconds || 600 != this.getIdleTimeoutSeconds()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<idle-timeout-seconds>").append(this.getIdleTimeoutSeconds()).append("</idle-timeout-seconds>\n");
        }
        if (this.isSet_sessionTimeoutSeconds || 600 != this.getSessionTimeoutSeconds()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<session-timeout-seconds>").append(this.getSessionTimeoutSeconds()).append("</session-timeout-seconds>\n");
        }
        if ((this.isSet_cacheType || !"NRU".equals(this.getCacheType())) && null != this.getCacheType()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<cache-type>").append(this.getCacheType()).append("</cache-type>\n");
        }
        stringBuffer.append(ToXML.indent(n)).append("</stateful-session-cache>\n");
        return stringBuffer.toString();
    }
}

