/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.descriptors.weblogic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.ejb11.MethodMBean;
import weblogic.management.descriptors.weblogic.TransactionIsolationMBean;
import weblogic.management.tools.ToXML;

public class TransactionIsolationMBeanImpl
extends XMLElementMBeanDelegate
implements TransactionIsolationMBean {
    static final long serialVersionUID = 1L;
    private boolean isSet_methods = false;
    private List methods;
    private boolean isSet_isolationLevel = false;
    private String isolationLevel;

    public MethodMBean[] getMethods() {
        if (this.methods == null) {
            return new MethodMBean[0];
        }
        MethodMBean[] methodMBeanArray = new MethodMBean[this.methods.size()];
        methodMBeanArray = this.methods.toArray(methodMBeanArray);
        return methodMBeanArray;
    }

    public void setMethods(MethodMBean[] methodMBeanArray) {
        MethodMBean[] methodMBeanArray2 = null;
        if (this.changeSupport != null) {
            methodMBeanArray2 = this.getMethods();
        }
        this.isSet_methods = true;
        if (this.methods == null) {
            this.methods = Collections.synchronizedList(new ArrayList());
        } else {
            this.methods.clear();
        }
        if (null != methodMBeanArray) {
            for (int i = 0; i < methodMBeanArray.length; ++i) {
                this.methods.add(methodMBeanArray[i]);
            }
        }
        if (this.changeSupport != null) {
            this.checkChange("Methods", methodMBeanArray2, this.getMethods());
        }
    }

    public void addMethod(MethodMBean methodMBean) {
        this.isSet_methods = true;
        if (this.methods == null) {
            this.methods = Collections.synchronizedList(new ArrayList());
        }
        this.methods.add(methodMBean);
    }

    public void removeMethod(MethodMBean methodMBean) {
        if (this.methods == null) {
            return;
        }
        this.methods.remove(methodMBean);
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(String string) {
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        String string2 = this.isolationLevel;
        this.isolationLevel = string;
        this.isSet_isolationLevel = string != null;
        this.checkChange("isolationLevel", string2, this.isolationLevel);
    }

    public String toXML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ToXML.indent(n)).append("<transaction-isolation");
        stringBuffer.append(">\n");
        if (null != this.getIsolationLevel()) {
            stringBuffer.append(ToXML.indent(n + 2)).append("<isolation-level>").append(this.getIsolationLevel()).append("</isolation-level>\n");
        }
        if (null != this.getMethods()) {
            for (int i = 0; i < this.getMethods().length; ++i) {
                stringBuffer.append(this.getMethods()[i].toXML(n + 2));
            }
        }
        stringBuffer.append(ToXML.indent(n)).append("</transaction-isolation>\n");
        return stringBuffer.toString();
    }
}

