/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.diagnostics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.management.DomainDir;

public class ConfigurationImageSource
implements ImageSource {
    private static final String CONFIG = DomainDir.getRootDir() + File.separatorChar + "config.xml";
    private static final String RUNNING_MANAGED_SERVER = DomainDir.getRootDir() + File.separatorChar + "running-managed-servers.xml";
    private volatile boolean imageCreationTimeOut = false;
    private volatile boolean imageCreationInProgress = false;

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        this.imageCreationInProgress = true;
        PrintWriter printWriter = new PrintWriter(outputStream);
        this.writeToStream(printWriter);
        this.imageCreationInProgress = false;
    }

    public void timeoutImageCreation() {
        if (this.imageCreationInProgress) {
            this.imageCreationTimeOut = true;
        }
    }

    private void writeToStream(PrintWriter printWriter) throws ImageSourceCreationException {
        this.writeToStream(printWriter, CONFIG);
        this.writeToStream(printWriter, RUNNING_MANAGED_SERVER);
    }

    private void writeToStream(PrintWriter printWriter, String string) throws ImageSourceCreationException {
        printWriter.println("Contents of the file " + string + " Follows :-");
        if (!new File(string).exists()) {
            printWriter.println("File " + string + " Not found on the disk");
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            do {
                printWriter.println(bufferedReader.readLine());
            } while (bufferedReader.readLine() != null);
            bufferedReader.close();
            printWriter.flush();
            if (this.imageCreationTimeOut) {
                this.imageCreationTimeOut = false;
                this.imageCreationInProgress = false;
                throw new ImageSourceCreationException("Timeout called.Complete image could not be created");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.imageCreationInProgress = false;
            throw new AssertionError((Object)("File does not exist" + string));
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException("Image creation failed" + iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                this.imageCreationInProgress = false;
                throw new ImageSourceCreationException("Image creation failed" + iOException);
            }
        }
    }
}

