/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.extension.internal;

import java.io.File;
import weblogic.application.Module;
import weblogic.application.internal.SingleModuleDeployment;
import weblogic.deploy.container.DeploymentContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.CustomResourceMBean;
import weblogic.management.extension.internal.CustomResourceModule;

public class CustomResourceDeployment
extends SingleModuleDeployment {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    String resourceName;

    public CustomResourceDeployment(CustomResourceMBean customResourceMBean, File file) throws DeploymentException {
        super(customResourceMBean, CustomResourceDeployment.createModule(customResourceMBean), file);
        this.resourceName = customResourceMBean.getName();
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Created custom resource for file " + file);
        }
    }

    private static Module createModule(CustomResourceMBean customResourceMBean) {
        return new CustomResourceModule(customResourceMBean.getName(), customResourceMBean.getResource(), customResourceMBean.getResourceClass());
    }

    public void prepareUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        super.prepareUpdate(deploymentContext);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Prepare update for resource " + this.resourceName);
        }
    }

    public void activateUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        super.activateUpdate(deploymentContext);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Activate update for resource " + this.resourceName);
        }
    }

    public void rollbackUpdate(DeploymentContext deploymentContext) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Rollback update for resource " + this.resourceName);
        }
    }
}

