/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.extension.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.extension.Resource;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.utils.classloaders.GenericClassLoader;

public class CustomResourceModule
implements Module,
UpdateListener {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    String id;
    DescriptorBean descriptor;
    String resourceClass;
    Resource resource;

    public CustomResourceModule(String string, DescriptorBean descriptorBean, String string2) {
        this.id = string;
        this.descriptor = descriptorBean;
        this.resourceClass = string2;
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Added custom resource with id " + string + " resource class " + string2 + " descriptor bean " + descriptorBean);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return "Custom";
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[0];
    }

    public DescriptorBean[] getDescriptors() {
        return new DescriptorBean[]{this.descriptor};
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.initializeResource((ClassLoader)genericClassLoader);
        registration.addUpdateListener(this);
        return genericClassLoader;
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.initializeResource((ClassLoader)genericClassLoader);
    }

    public void prepare() throws ModuleException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Custom Resource prepare() about to call resource prepare() " + this.resource);
        }
        this.resource.prepare();
        this.descriptor.addBeanUpdateListener(new BeanUpdateListener(){

            public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
                CustomResourceModule.this.resource.prepareUpdate(beanUpdateEvent);
            }

            public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
                CustomResourceModule.this.resource.activateUpdate(beanUpdateEvent);
            }

            public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
                CustomResourceModule.this.resource.rollbackUpdate(beanUpdateEvent);
            }
        });
    }

    public void activate() throws ModuleException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Custom Resource activate() about to call resource activate() " + this.resource);
        }
        this.resource.activate();
    }

    public void start() throws ModuleException {
    }

    public void deactivate() throws ModuleException {
        this.resource.deactivate();
    }

    public void unprepare() throws ModuleException {
        this.resource.unprepare();
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
    }

    public void remove() throws ModuleException {
        this.resource.remove();
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
    }

    public void forceProductionToAdmin() throws ModuleException {
    }

    void initializeResource(ClassLoader classLoader) throws ModuleException {
        try {
            Class<?> clazz = classLoader.loadClass(this.resourceClass);
            Constructor<?> constructor = clazz.getConstructor(null);
            this.resource = (Resource)constructor.newInstance(null);
            this.resource.initialize(this.descriptor);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ModuleException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ModuleException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ModuleException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ModuleException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new ModuleException(instantiationException);
        }
    }

    public boolean acceptURI(String string) {
        return true;
    }

    public void prepareUpdate(String string) throws ModuleException {
    }

    public void activateUpdate(String string) throws ModuleException {
    }

    public void rollbackUpdate(String string) {
    }
}

