/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import javax.security.auth.Subject;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ContextHandler;
import weblogic.security.spi.AuditConfigurationEvent;
import weblogic.security.spi.AuditSeverity;

public class AuditConfigurationBaseEventImpl
implements AuditConfigurationEvent {
    private static final String EVENT_TYPE_ATTR = "Event Type";
    private static final String SUBJECT_ATTR = "Subject";
    private static final String OBJECT_ATTR = "Object";
    private AuditSeverity severity;
    private String eventType;
    private AuthenticatedSubject subject;
    private String objectName;
    private Exception exception;
    private ContextHandler context;

    public AuditConfigurationBaseEventImpl(AuditSeverity auditSeverity, String string, AuthenticatedSubject authenticatedSubject, String string2) {
        this.severity = auditSeverity;
        this.eventType = string;
        this.subject = authenticatedSubject;
        this.objectName = string2;
    }

    public void setFailureException(Exception exception) {
        this.exception = exception;
    }

    public Exception getFailureException() {
        return this.exception;
    }

    public AuditSeverity getSeverity() {
        return this.severity;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Subject getSubject() {
        return this.subject.getSubject();
    }

    public void setContext(ContextHandler contextHandler) {
        this.context = contextHandler;
    }

    public ContextHandler getContext() {
        return this.context;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        this.writeAttributes(stringBuffer);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    protected void writeAttributes(StringBuffer stringBuffer) {
        stringBuffer.append("<");
        stringBuffer.append(EVENT_TYPE_ATTR);
        stringBuffer.append(" = ");
        stringBuffer.append(this.eventType);
        stringBuffer.append("><");
        stringBuffer.append(SUBJECT_ATTR);
        stringBuffer.append(" = ");
        stringBuffer.append(SubjectUtils.displaySubject((AuthenticatedSubject)this.subject));
        stringBuffer.append("><");
        stringBuffer.append(OBJECT_ATTR);
        stringBuffer.append(" = ");
        stringBuffer.append(this.objectName);
        stringBuffer.append(">");
    }
}

