/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import weblogic.management.ManagementLogger;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.internal.BaseNotificationListener;
import weblogic.management.internal.MBeanProxy;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.utils.Debug;

public class BaseNotificationListenerImpl
implements BaseNotificationListener {
    private static boolean debug = false;
    private MBeanServer server = null;
    private MBeanProxy proxy = null;
    private NotificationListener listener = null;

    BaseNotificationListenerImpl(MBeanProxy mBeanProxy, NotificationListener notificationListener) {
        this.proxy = mBeanProxy;
        this.listener = notificationListener;
        try {
            this.server = this.proxy.getMBeanHome().getMBeanServer();
            Debug.assertion((this.proxy.getObjectName() != null ? 1 : 0) != 0);
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            throw new ConfigurationError(remoteRuntimeException);
        }
    }

    public ObjectName getObjectName() {
        return this.proxy.getObjectName();
    }

    public NotificationListener getListener() {
        return this.listener;
    }

    public void addFilterAndHandback(NotificationFilter notificationFilter, Object object) {
        try {
            this.server.addNotificationListener((ObjectName)this.proxy.getObjectName(), this, notificationFilter, object);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementLogger.logAddFilterFailed((Throwable)instanceNotFoundException);
        }
    }

    public void remove() {
        try {
            this.server.removeNotificationListener((ObjectName)this.proxy.getObjectName(), this);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementLogger.logRemoveNotificationFailed((Throwable)instanceNotFoundException);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            ManagementLogger.logRemoveNotificationFailed((Throwable)listenerNotFoundException);
        }
        this.listener = null;
    }

    public void handleNotification(Notification notification, Object object) {
        this.proxy.sendNotification(this.listener, notification, object);
    }

    public void unregister() {
        try {
            this.server.removeNotificationListener((ObjectName)this.proxy.getObjectName(), this);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            ManagementLogger.logUnregisterNotificationFailed((Throwable)listenerNotFoundException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ManagementLogger.logUnregisterNotificationFailed((Throwable)instanceNotFoundException);
        }
    }

    public String toString() {
        return "RNL [" + this.proxy + "]";
    }
}

