/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.util.Enumeration;
import java.util.Vector;
import weblogic.security.acl.ClosableEnumeration;

public final class BatchedEnumeration {
    private static boolean debug = false;
    private Enumeration enumeration;
    private int batchSize;
    private ElementHandler handler;
    private boolean done = false;

    public BatchedEnumeration(Enumeration enumeration, int n, ElementHandler elementHandler) {
        this.enumeration = enumeration;
        this.batchSize = n;
        this.handler = elementHandler;
        if (debug) {
            this.trace("constructor");
        }
    }

    public Object[] getNextBatch() {
        if (debug) {
            this.trace("getNextBatch");
        }
        if (this.done) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.batchSize || this.batchSize <= 0; ++i) {
            if (this.enumeration == null || !this.enumeration.hasMoreElements()) {
                this.closeEnumeration();
                break;
            }
            vector.add(this.handler.handle(this.enumeration.nextElement()));
        }
        if (vector.size() <= 0) {
            return null;
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasMoreElements() {
        if (debug) {
            this.trace("hasMoreElements");
        }
        if (this.done) {
            return false;
        }
        return this.enumeration.hasMoreElements();
    }

    public void close() {
        if (debug) {
            this.trace("close");
        }
        this.closeEnumeration();
    }

    protected void finalize() {
        if (debug) {
            this.trace("finalize");
        }
        this.close();
    }

    private void trace(String string) {
        System.out.println("BatchedEnumeration done=" + this.done + ", batchSize=" + this.batchSize + " " + string);
    }

    private void closeEnumeration() {
        if (debug) {
            this.trace("closeEnumeration");
        }
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.enumeration instanceof ClosableEnumeration) {
            ((ClosableEnumeration)this.enumeration).close();
        }
    }

    static interface ElementHandler {
        public Object handle(Object var1);
    }
}

