/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.management.internal.ProductionModeHelper;
import weblogic.protocol.AdminServerIdentity;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.server.channels.ChannelService;
import weblogic.utils.Debug;

public class BootStrapStruct
implements Externalizable {
    private static final long serialVersionUID = -737557156369970506L;
    private String adminServerName = null;
    private ServerIdentity adminIdentity;

    public BootStrapStruct(String string) {
        this.adminServerName = string;
    }

    public BootStrapStruct() {
    }

    public ServerIdentity getAdminIdentity() {
        return this.adminIdentity;
    }

    public String getAdminServerName() {
        return this.adminServerName;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.adminServerName);
        Debug.assertion((boolean)LocalServerIdentity.getIdentity().getServerName().equals(this.adminServerName));
        objectOutput.writeObject(LocalServerIdentity.getIdentity());
        ChannelService.exportServerChannels(LocalServerIdentity.getIdentity(), objectOutput);
        ProductionModeHelper.exportProductionMode(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.adminServerName = objectInput.readUTF();
        this.adminIdentity = (ServerIdentity)objectInput.readObject();
        AdminServerIdentity.setBootstrapIdentity(this.adminIdentity);
        ChannelService.importNonLocalServerChannels(this.adminIdentity, objectInput);
        ProductionModeHelper.importProductionMode(objectInput);
    }
}

