/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.WebLogicObjectName;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.internal.AuditCreateConfigurationEventImpl;
import weblogic.management.internal.AuditDeleteConfigurationEventImpl;
import weblogic.management.internal.AuditInvokeConfigurationEventImpl;
import weblogic.management.internal.AuditSetAttributeConfigurationEventImpl;
import weblogic.management.internal.ConfigAuditorLogger;
import weblogic.management.internal.SecurityHelper;
import weblogic.management.provider.ManagementService;
import weblogic.security.Security;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.Auditor;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.AuditEvent;
import weblogic.security.spi.AuditSeverity;
import weblogic.utils.StringUtils;

public class ConfigurationAuditor
implements PropertyChangeListener {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");
    private static ConfigurationAuditor instance;
    private static boolean instantiated;
    private static boolean initialized;
    private Auditor auditor = null;
    private static AuthenticatedSubject KERNEL_ID;
    private boolean oldChangeLoggingAttr = Boolean.getBoolean("weblogic.AdministrationMBeanAuditingEnabled");
    private boolean newChangeLoggingAttr = false;
    private boolean changeLoggingEnabled = false;
    private boolean changeAuditingEnabled = false;
    private WebLogicObjectName domainName;
    private static final String OLD_AUDIT_ENABLED_ATTRIBUTE = "AdministrationMBeanAuditingEnabled";
    private static final String NEW_AUDIT_ENABLED_ATTRIBUTE = "ConfigurationAuditType";
    private static String domain;
    private static final String ARRAY_DELIMITOR_FOR_PARAMS_STRING = "; ";
    private static final String PARAMS_TOKENIZER_STRING = ";";

    private ConfigurationAuditor() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(NEW_AUDIT_ENABLED_ATTRIBUTE)) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Property change for ConfigurationAuditType");
            }
            String string = (String)propertyChangeEvent.getNewValue();
            boolean bl = this.changeAuditingEnabled;
            this.setConfiguredAuditing(string);
            if (bl && !this.changeAuditingEnabled) {
                this.auditModify(this.domainName.toString(), propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), string, null);
            }
            this.logStatus(true);
        } else if (propertyChangeEvent.getPropertyName().equals(OLD_AUDIT_ENABLED_ATTRIBUTE)) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Property change for AdministrationMBeanAuditingEnabled");
            }
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.oldChangeLoggingAttr = bl;
            this.setLoggingEnabled(this.newChangeLoggingAttr || this.oldChangeLoggingAttr);
            this.logStatus(true);
        }
    }

    void setLoggingEnabled(boolean bl) {
        this.changeLoggingEnabled = bl;
    }

    void intialize(DomainMBean domainMBean) {
        if (initialized) {
            throw new AssertionError((Object)"The auditor can only be initialized once");
        }
        if (!ManagementService.getRuntimeAccess(KERNEL_ID).isAdminServer()) {
            return;
        }
        initialized = true;
        this.domainName = domainMBean.getObjectName();
        this.oldChangeLoggingAttr = this.oldChangeLoggingAttr || domainMBean.isAdministrationMBeanAuditingEnabled();
        this.setConfiguredAuditing(domainMBean.getConfigurationAuditType());
        this.logStatus(false);
        String string = "weblogicDEFAULT";
        this.auditor = (Auditor)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUDIT);
        domainMBean.addPropertyChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ConfigurationAuditor getInstance() {
        if (instantiated) return instance;
        Class<ConfigurationAuditor> clazz = ConfigurationAuditor.class;
        synchronized (ConfigurationAuditor.class) {
            if (!instantiated) {
                instance = new ConfigurationAuditor();
            }
            instantiated = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void create(ObjectName objectName, Exception exception) {
        if (!this.isAuditable(objectName)) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Config auditor create - object name " + objectName);
        }
        if (this.changeLoggingEnabled) {
            if (exception == null) {
                ConfigAuditorLogger.logInfoAuditCreateSuccess((String)this.getSubjectUser(), (String)objectName.toString());
            } else {
                ConfigAuditorLogger.logInfoAuditCreateFailure((String)this.getSubjectUser(), (String)objectName.toString(), (Exception)exception);
            }
        }
        if (this.changeAuditingEnabled) {
            this.auditCreate(objectName.toString(), exception);
        }
    }

    public void remove(ObjectName objectName, Exception exception) {
        if (!this.isAuditable(objectName)) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Config auditor remove - object name " + objectName);
        }
        if (this.changeLoggingEnabled) {
            if (exception == null) {
                ConfigAuditorLogger.logInfoAuditRemoveSuccess((String)this.getSubjectUser(), (String)objectName.toString());
            } else {
                ConfigAuditorLogger.logInfoAuditRemoveFailure((String)this.getSubjectUser(), (String)objectName.toString(), (Exception)exception);
            }
        }
        if (this.changeAuditingEnabled) {
            this.auditDelete(objectName.toString(), exception);
        }
    }

    public void modify(ObjectName objectName, Object object, Attribute attribute, PropertyDescriptor propertyDescriptor, Exception exception) {
        if (!this.isAuditable(objectName)) {
            return;
        }
        this.auditJMXAttribute(objectName, object, attribute, propertyDescriptor, exception);
    }

    public void modify(ObjectName objectName, AttributeList attributeList, AttributeList attributeList2, PropertyDescriptor[] propertyDescriptorArray, Exception exception) {
        if (!this.isAuditable(objectName)) {
            return;
        }
        Iterator iterator = attributeList2.iterator();
        Iterator iterator2 = attributeList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            Attribute attribute2 = (Attribute)iterator2.next();
            this.auditJMXAttribute(objectName, attribute2, attribute, propertyDescriptorArray[n], exception);
            ++n;
        }
    }

    private void auditJMXAttribute(ObjectName objectName, Object object, Attribute attribute, PropertyDescriptor propertyDescriptor, Exception exception) {
        String string = null;
        String string2 = null;
        String string3 = attribute.getName();
        boolean bl = this.isProtectedAttribute(objectName, string3, propertyDescriptor);
        if (bl) {
            string = "****";
            string2 = "****";
        } else {
            string = this.convertParamsToHumanReadableString(attribute);
            string2 = this.convertParamsToHumanReadableString(object);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Config auditor modify - object name " + objectName + " old " + string2 + " new " + string);
        }
        if (this.changeLoggingEnabled) {
            if (exception == null) {
                ConfigAuditorLogger.logInfoAuditModifySuccess((String)this.getSubjectUser(), (String)objectName.toString(), (String)string3, (String)string2, (String)string);
            } else {
                ConfigAuditorLogger.logInfoAuditModifyFailure((String)this.getSubjectUser(), (String)objectName.toString(), (String)string3, (String)string2, (String)string, (Exception)exception);
            }
        }
        if (this.changeAuditingEnabled) {
            this.auditModify(objectName.toString(), string3, string2, string, exception);
        }
    }

    public void invoke(ObjectName objectName, MethodDescriptor methodDescriptor, String string, Object[] objectArray, Exception exception) {
        if (!this.isAuditable(objectName)) {
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Config auditor invoke - object name " + objectName + " action " + string);
        }
        if (this.isFilteredMethod(string)) {
            return;
        }
        if (string.startsWith("createMBean") || string.startsWith("registerMBean")) {
            this.create(objectName, exception);
            return;
        }
        if (string.startsWith("create") && objectArray != null && objectArray.length == 1) {
            try {
                this.create(this.getObjectNameFromAction(string, objectArray[0]), exception);
                return;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
        }
        if (string.startsWith("unregisterMBean")) {
            this.remove(objectName, exception);
            return;
        }
        if (string.startsWith("destroy") && objectArray != null && objectArray.length == 1 && objectArray[0] instanceof ObjectName) {
            this.remove((ObjectName)objectArray[0], exception);
            return;
        }
        String string2 = null;
        if (methodDescriptor != null) {
            string2 = (String)methodDescriptor.getValue("wls:auditProtectedArgs");
        }
        String string3 = null;
        if (this.changeLoggingEnabled || this.changeAuditingEnabled) {
            string3 = this.convertParamsToHumanReadableString(objectArray);
            if (string2 != null) {
                string3 = this.replaceClearTextPasswords(string3, string2);
            }
            if (this.changeLoggingEnabled) {
                if (exception == null) {
                    ConfigAuditorLogger.logInfoAuditInvokeSuccess((String)this.getSubjectUser(), (String)objectName.toString(), (String)string, (String)string3);
                } else {
                    ConfigAuditorLogger.logInfoAuditInvokeFailure((String)this.getSubjectUser(), (String)objectName.toString(), (String)string, (String)string3, (Exception)exception);
                }
            }
            if (this.changeAuditingEnabled) {
                this.auditInvoke(objectName.toString(), string, string3, exception);
            }
        }
    }

    private boolean isProtectedAttribute(ObjectName objectName, String string, PropertyDescriptor propertyDescriptor) {
        return SecurityHelper.isProtectedAttribute(objectName, string, propertyDescriptor);
    }

    private String convertParamsToHumanReadableString(Object object) {
        Object[] objectArray;
        Serializable serializable;
        if (object == null) {
            return "";
        }
        if (object instanceof Attribute) {
            serializable = (Attribute)object;
            objectArray = ((Attribute)serializable).getName();
            object = ((Attribute)serializable).getValue();
            if (object == null) {
                return "";
            }
        }
        if (object.getClass().isArray()) {
            serializable = new StringBuffer();
            objectArray = (Object[])object;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != null) {
                    ((StringBuffer)serializable).append(objectArray[i].toString());
                }
                if (i >= n - 1) continue;
                ((StringBuffer)serializable).append(ARRAY_DELIMITOR_FOR_PARAMS_STRING);
            }
            return ((StringBuffer)serializable).toString();
        }
        return object.toString();
    }

    private String replaceClearTextPasswords(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = StringUtils.split((String)string2, (char)',');
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i].trim());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                ConfigAuditorLogger.logInvalidNumberReplacingClearText((String)stringArray[i].trim(), (Throwable)numberFormatException);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, PARAMS_TOKENIZER_STRING);
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                string3 = " ****";
                break;
            }
            stringBuffer.append(string3);
            if (stringTokenizer.hasMoreElements()) {
                stringBuffer.append(PARAMS_TOKENIZER_STRING);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isAuditable(ObjectName objectName) {
        return this.private_isAuditable(objectName);
    }

    private boolean private_isAuditable(ObjectName objectName) {
        if (!initialized) {
            return false;
        }
        if (!this.changeLoggingEnabled && !this.changeAuditingEnabled) {
            return false;
        }
        if (objectName.getKeyProperty("Type") == null) {
            return true;
        }
        return objectName.getKeyProperty("Location") == null;
    }

    private boolean isFilteredMethod(String string) {
        if (string.startsWith("lookup")) {
            return true;
        }
        if (string.startsWith("find")) {
            return true;
        }
        if (string.startsWith("getMBean")) {
            return true;
        }
        if (string.startsWith("getXml")) {
            return true;
        }
        if (string.equals("preDeregister")) {
            return true;
        }
        if (string.equals("userExists")) {
            return true;
        }
        if (string.equals("groupExists")) {
            return true;
        }
        if (string.equals("advance")) {
            return true;
        }
        if (string.equals("haveCurrent")) {
            return true;
        }
        if (string.equals("close")) {
            return true;
        }
        if (string.equals("saveDomain")) {
            return true;
        }
        return string.endsWith("DescriptorValue");
    }

    private void logStatus(boolean bl) {
        if (this.changeLoggingEnabled || this.changeAuditingEnabled) {
            ConfigAuditorLogger.logInfoConfigurationAuditingEnabled((String)this.getSubjectUser());
        } else if (bl) {
            ConfigAuditorLogger.logInfoConfigurationAuditingDisabled((String)this.getSubjectUser());
        }
    }

    private String getSubjectUser() {
        String string = SubjectUtils.getUsername((Subject)Security.getCurrentSubject());
        if (string == null) {
            string = new String("<UNKNOWN>");
        }
        return string;
    }

    private void auditCreate(String string, Exception exception) {
        if (this.auditor != null) {
            AuditCreateConfigurationEventImpl auditCreateConfigurationEventImpl;
            if (exception == null) {
                auditCreateConfigurationEventImpl = new AuditCreateConfigurationEventImpl(AuditSeverity.SUCCESS, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), string);
            } else {
                auditCreateConfigurationEventImpl = new AuditCreateConfigurationEventImpl(AuditSeverity.FAILURE, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), string);
                auditCreateConfigurationEventImpl.setFailureException(exception);
            }
            this.auditor.writeEvent((AuditEvent)auditCreateConfigurationEventImpl);
        }
    }

    private void auditDelete(String string, Exception exception) {
        if (this.auditor != null) {
            AuditDeleteConfigurationEventImpl auditDeleteConfigurationEventImpl;
            if (exception == null) {
                auditDeleteConfigurationEventImpl = new AuditDeleteConfigurationEventImpl(AuditSeverity.SUCCESS, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), string);
            } else {
                auditDeleteConfigurationEventImpl = new AuditDeleteConfigurationEventImpl(AuditSeverity.FAILURE, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), string);
                auditDeleteConfigurationEventImpl.setFailureException(exception);
            }
            this.auditor.writeEvent((AuditEvent)auditDeleteConfigurationEventImpl);
        }
    }

    private void auditInvoke(String string, String string2, String string3, Exception exception) {
        if (this.auditor != null) {
            AuditInvokeConfigurationEventImpl auditInvokeConfigurationEventImpl;
            if (exception == null) {
                auditInvokeConfigurationEventImpl = new AuditInvokeConfigurationEventImpl(AuditSeverity.SUCCESS, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), string, string2, string3);
            } else {
                auditInvokeConfigurationEventImpl = new AuditInvokeConfigurationEventImpl(AuditSeverity.FAILURE, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), string, string2, string3);
                auditInvokeConfigurationEventImpl.setFailureException(exception);
            }
            this.auditor.writeEvent((AuditEvent)auditInvokeConfigurationEventImpl);
        }
    }

    private void auditModify(String string, String string2, Object object, Object object2, Exception exception) {
        if (this.auditor != null) {
            AuditSetAttributeConfigurationEventImpl auditSetAttributeConfigurationEventImpl;
            if (exception == null) {
                auditSetAttributeConfigurationEventImpl = new AuditSetAttributeConfigurationEventImpl(AuditSeverity.SUCCESS, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), string, string2, object, object2);
            } else {
                auditSetAttributeConfigurationEventImpl = new AuditSetAttributeConfigurationEventImpl(AuditSeverity.FAILURE, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), string, string2, object, object2);
                auditSetAttributeConfigurationEventImpl.setFailureException(exception);
            }
            this.auditor.writeEvent((AuditEvent)auditSetAttributeConfigurationEventImpl);
        }
    }

    private void setConfiguredAuditing(String string) {
        if (string.equalsIgnoreCase("audit")) {
            this.changeAuditingEnabled = true;
            this.newChangeLoggingAttr = false;
        } else if (string.equalsIgnoreCase("logaudit")) {
            this.changeAuditingEnabled = true;
            this.newChangeLoggingAttr = true;
        } else if (string.equalsIgnoreCase("log")) {
            this.changeAuditingEnabled = false;
            this.newChangeLoggingAttr = true;
        } else {
            this.changeAuditingEnabled = false;
            this.newChangeLoggingAttr = false;
        }
        this.setLoggingEnabled(this.newChangeLoggingAttr || this.oldChangeLoggingAttr);
    }

    private ObjectName getObjectNameFromAction(String string, Object object) throws MalformedObjectNameException {
        String string2 = domain + ":Name=" + object.toString() + ",Type=" + string.substring(6);
        return new ObjectName(string2);
    }

    static {
        instantiated = false;
        initialized = false;
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        domain = ManagementService.getRuntimeAccess(KERNEL_ID).getDomainName();
    }
}

