/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementLogger;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ForeignJMSServerMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCDataSourceMBean;
import weblogic.management.configuration.JDBCMultiPoolMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JDBCTxDataSourceMBean;
import weblogic.management.configuration.JMSConnectionFactoryMBean;
import weblogic.management.configuration.JMSDistributedQueueMBean;
import weblogic.management.configuration.JMSDistributedTopicMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.MailSessionMBean;
import weblogic.management.configuration.MessagingBridgeMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.SNMPAgentDeploymentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.StartupClassMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WTCServerMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.internal.ResourceDependentDeploymentHandler;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class DeploymentHandlerHome {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");
    private static final int DEPLOYMENT_PREPARE = 0;
    private static final int DEPLOYMENT_UNPREPARE = 1;
    private static final int DEPLOYMENT_ACTIVATE = 2;
    private static final int DEPLOYMENT_DEACTIVATE = 3;
    private Set deploymentHandlers = new HashSet();
    private Set resourceDependentDeploymentHandlers = new HashSet();
    private Set regularTargets = new HashSet();
    private List exceptionList = new ArrayList();
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final BeanUpdateListener deploymentListener = this.createDeploymentUpdateListener();
    public static Comparator deploymentComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < DEPLOYMENT_ORDER.length; ++n2) {
                n = DEPLOYMENT_ORDER[n2].isAssignableFrom(object.getClass());
                boolean bl = DEPLOYMENT_ORDER[n2].isAssignableFrom(object2.getClass());
                if (n != 0 && bl) break;
                if (n != 0) {
                    n3 = -1;
                    break;
                }
                if (!bl) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) {
                n2 = ((DeploymentMBean)object).getDeploymentOrder();
                if (n2 < (n = ((DeploymentMBean)object2).getDeploymentOrder())) {
                    n3 = -1;
                }
                if (n < n2) {
                    n3 = 1;
                }
                return ((DeploymentMBean)object).getName().compareTo(((DeploymentMBean)object2).getName());
            }
            return n3;
        }
    };
    public static Comparator deploymentComparatorReverse = new Comparator(){

        public int compare(Object object, Object object2) {
            return deploymentComparator.compare(object2, object);
        }
    };
    private static final Class[] DEPLOYMENT_ORDER = new Class[]{StartupClassMBean.class, JDBCConnectionPoolMBean.class, JDBCSystemResourceMBean.class, PersistentStoreMBean.class, JDBCMultiPoolMBean.class, JDBCDataSourceMBean.class, JDBCTxDataSourceMBean.class, SAFAgentMBean.class, JMSConnectionFactoryMBean.class, JMSDistributedQueueMBean.class, JMSDistributedTopicMBean.class, JMSServerMBean.class, ForeignJMSServerMBean.class, MessagingBridgeMBean.class, MailSessionMBean.class, SNMPAgentDeploymentMBean.class};
    private static final Class[] RESOURCE_DEPENDENT_DEPLOYMENTS = new Class[]{WTCServerMBean.class};

    public static DeploymentHandlerHome getInstance() {
        return Initializer.SINGLETON;
    }

    private BeanUpdateListener createDomainUpdateListener() {
        return new BeanUpdateListener(){

            public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
                DeploymentHandlerHome.this.recalcTargetsIfNeeded(beanUpdateEvent);
                DeploymentMBean[] deploymentMBeanArray = this.getDeploymentUpdates(beanUpdateEvent, 3);
                for (int i = deploymentMBeanArray.length - 1; i >= 0; --i) {
                    DeploymentMBean deploymentMBean = deploymentMBeanArray[i];
                    DeploymentHandlerHome.debug("Add listener to " + deploymentMBean.getName());
                    deploymentMBean.addBeanUpdateListener(DeploymentHandlerHome.this.deploymentListener);
                    if (!DeploymentHandlerHome.this.isTargetedToThisServer(deploymentMBean)) continue;
                    DeploymentHandlerHome.debug("domain listener de-activate " + deploymentMBean.getName());
                    DeploymentHandlerHome.this.invokeHandlers(deploymentMBean, 3, null);
                }
                DeploymentMBean[] deploymentMBeanArray2 = this.getDeploymentUpdates(beanUpdateEvent, 2);
                for (int i = 0; i < deploymentMBeanArray2.length; ++i) {
                    DeploymentMBean deploymentMBean = deploymentMBeanArray2[i];
                    DeploymentHandlerHome.debug("Add listener to " + deploymentMBean.getName());
                    deploymentMBean.addBeanUpdateListener(DeploymentHandlerHome.this.deploymentListener);
                    if (!DeploymentHandlerHome.this.isTargetedToThisServer(deploymentMBean)) continue;
                    DeploymentHandlerHome.debug("domain listener prepare " + deploymentMBean.getName());
                    DeploymentHandlerHome.this.invokeHandlers(deploymentMBean, 0, null);
                }
            }

            public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
                Object object;
                BeanUpdateFailedException beanUpdateFailedException = null;
                DeploymentMBean[] deploymentMBeanArray = this.getDeploymentUpdates(beanUpdateEvent, 3);
                for (int i = deploymentMBeanArray.length - 1; i >= 0; --i) {
                    DeploymentMBean deploymentMBean = deploymentMBeanArray[i];
                    deploymentMBean.addBeanUpdateListener(DeploymentHandlerHome.this.deploymentListener);
                    if (!DeploymentHandlerHome.this.isTargetedToThisServer(deploymentMBean)) continue;
                    DeploymentHandlerHome.debug("domain listener un-prepare " + deploymentMBean.getName());
                    DeploymentHandlerHome.this.invokeHandlers(deploymentMBean, 1, null);
                    if (DeploymentHandlerHome.this.exceptionList.isEmpty()) continue;
                    if (beanUpdateFailedException == null) {
                        beanUpdateFailedException = new BeanUpdateFailedException();
                    }
                    object = DeploymentHandlerHome.this.exceptionList.iterator();
                    while (object.hasNext()) {
                        beanUpdateFailedException.addException((Exception)object.next());
                    }
                }
                DeploymentMBean[] deploymentMBeanArray2 = this.getDeploymentUpdates(beanUpdateEvent, 2);
                for (int i = 0; i < deploymentMBeanArray2.length; ++i) {
                    object = deploymentMBeanArray2[i];
                    object.addBeanUpdateListener(DeploymentHandlerHome.this.deploymentListener);
                    if (!DeploymentHandlerHome.this.isTargetedToThisServer((DeploymentMBean)object)) continue;
                    DeploymentHandlerHome.debug("domain listener activate " + object.getName());
                    DeploymentHandlerHome.this.invokeHandlers((DeploymentMBean)object, 2, null);
                    if (DeploymentHandlerHome.this.exceptionList.isEmpty()) continue;
                    if (beanUpdateFailedException == null) {
                        beanUpdateFailedException = new BeanUpdateFailedException();
                    }
                    Iterator iterator = DeploymentHandlerHome.this.exceptionList.iterator();
                    while (iterator.hasNext()) {
                        beanUpdateFailedException.addException((Exception)iterator.next());
                    }
                }
                if (beanUpdateFailedException != null) {
                    throw beanUpdateFailedException;
                }
            }

            public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            }

            private boolean isIgnored(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
                String string = propertyUpdate.getPropertyName();
                if (string.equals("Targets")) {
                    return true;
                }
                return string.equals("Deployments");
            }

            private DeploymentMBean[] getDeploymentUpdates(BeanUpdateEvent beanUpdateEvent, int n) {
                TreeSet<Object> treeSet = new TreeSet<Object>(deploymentComparator);
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                for (int i = 0; i < propertyUpdateArray.length; ++i) {
                    Object object;
                    BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                    if (this.isIgnored(propertyUpdate) || !((object = DeploymentHandlerHome.this.getChangedObject(propertyUpdate)) instanceof DeploymentMBean) || n != propertyUpdate.getUpdateType()) continue;
                    treeSet.add(object);
                }
                DeploymentMBean[] deploymentMBeanArray = treeSet.toArray(new DeploymentMBean[treeSet.size()]);
                return deploymentMBeanArray;
            }
        };
    }

    private BeanUpdateListener createDeploymentUpdateListener() {
        return new BeanUpdateListener(){

            public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
                if (!(descriptorBean instanceof DeploymentMBean)) {
                    return;
                }
                DeploymentMBean deploymentMBean = (DeploymentMBean)descriptorBean;
                TargetMBean[] targetMBeanArray = this.getTargetUpdates(beanUpdateEvent, 3);
                for (int i = 0; i < targetMBeanArray.length; ++i) {
                    TargetMBean targetMBean = targetMBeanArray[i];
                    if (!DeploymentHandlerHome.this.regularTargets.contains(targetMBean.getName())) continue;
                    DeploymentHandlerHome.debug("deploy listener de-activate " + deploymentMBean.getName());
                    DeploymentHandlerHome.this.invokeHandlers(deploymentMBean, 3, null);
                }
                TargetMBean[] targetMBeanArray2 = this.getTargetUpdates(beanUpdateEvent, 2);
                for (int i = 0; i < targetMBeanArray2.length; ++i) {
                    TargetMBean targetMBean = targetMBeanArray2[i];
                    if (!DeploymentHandlerHome.this.regularTargets.contains(targetMBean.getName())) continue;
                    DeploymentHandlerHome.debug("deploy listener prepare " + deploymentMBean.getName());
                    DeploymentHandlerHome.this.invokeHandlers(deploymentMBean, 0, null);
                }
            }

            public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
                Object object;
                BeanUpdateFailedException beanUpdateFailedException = null;
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                DescriptorBean descriptorBean = beanUpdateEvent.getSourceBean();
                if (!(descriptorBean instanceof DeploymentMBean)) {
                    return;
                }
                DeploymentMBean deploymentMBean = (DeploymentMBean)descriptorBean;
                TargetMBean[] targetMBeanArray = this.getTargetUpdates(beanUpdateEvent, 3);
                for (int i = 0; i < targetMBeanArray.length; ++i) {
                    TargetMBean targetMBean = targetMBeanArray[i];
                    if (!DeploymentHandlerHome.this.regularTargets.contains(targetMBean.getName())) continue;
                    DeploymentHandlerHome.debug("deploy listener un-prepare " + deploymentMBean.getName());
                    DeploymentHandlerHome.this.invokeHandlers(deploymentMBean, 1, null);
                    if (DeploymentHandlerHome.this.exceptionList.isEmpty()) continue;
                    if (beanUpdateFailedException == null) {
                        beanUpdateFailedException = new BeanUpdateFailedException();
                    }
                    object = DeploymentHandlerHome.this.exceptionList.iterator();
                    while (object.hasNext()) {
                        beanUpdateFailedException.addException((Exception)object.next());
                    }
                }
                TargetMBean[] targetMBeanArray2 = this.getTargetUpdates(beanUpdateEvent, 2);
                for (int i = 0; i < targetMBeanArray2.length; ++i) {
                    object = targetMBeanArray2[i];
                    if (!DeploymentHandlerHome.this.regularTargets.contains(object.getName())) continue;
                    DeploymentHandlerHome.debug("deploy listener activate " + deploymentMBean.getName());
                    DeploymentHandlerHome.this.invokeHandlers(deploymentMBean, 2, null);
                    if (DeploymentHandlerHome.this.exceptionList.isEmpty()) continue;
                    if (beanUpdateFailedException == null) {
                        beanUpdateFailedException = new BeanUpdateFailedException();
                    }
                    Iterator iterator = DeploymentHandlerHome.this.exceptionList.iterator();
                    while (iterator.hasNext()) {
                        beanUpdateFailedException.addException((Exception)iterator.next());
                    }
                }
                if (beanUpdateFailedException != null) {
                    throw beanUpdateFailedException;
                }
            }

            public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            }

            private TargetMBean[] getTargetUpdates(BeanUpdateEvent beanUpdateEvent, int n) {
                HashSet<Object> hashSet = new HashSet<Object>();
                BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                for (int i = 0; i < propertyUpdateArray.length; ++i) {
                    BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
                    String string = propertyUpdate.getPropertyName();
                    Object object = DeploymentHandlerHome.this.getChangedObject(propertyUpdate);
                    if (!"Targets".equals(string) || n != propertyUpdate.getUpdateType()) continue;
                    DeploymentHandlerHome.debug("ADD " + ((TargetMBean)object).getName());
                    hashSet.add(object);
                }
                DeploymentHandlerHome.debug("Updated target set: " + hashSet);
                TargetMBean[] targetMBeanArray = hashSet.toArray(new TargetMBean[hashSet.size()]);
                return targetMBeanArray;
            }
        };
    }

    public synchronized Set prepareInitialDeployments() throws DeploymentException {
        DeploymentHandlerHome.debug("Prepare initial deployments");
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        DomainMBean domainMBean = runtimeAccess.getDomain();
        this.recalculateTargets(domainMBean);
        TreeSet<DeploymentMBean> treeSet = new TreeSet<DeploymentMBean>(deploymentComparator);
        DeploymentMBean[] deploymentMBeanArray = domainMBean.getDeployments();
        for (int i = 0; i < deploymentMBeanArray.length; ++i) {
            DeploymentMBean deploymentMBean = deploymentMBeanArray[i];
            if (DeploymentHandlerHome.isResourceDependent(deploymentMBean)) continue;
            if (this.isTargetedToThisServer(deploymentMBean)) {
                treeSet.add(deploymentMBean);
            }
            deploymentMBean.addBeanUpdateListener(this.deploymentListener);
        }
        for (DeploymentMBean deploymentMBean : treeSet) {
            this.invokeHandlers(deploymentMBean, 0, null);
        }
        return treeSet;
    }

    public synchronized Set prepareResourceDependentInitialDeployments() throws DeploymentException {
        DeploymentHandlerHome.debug("Prepare resource dependent initial deployments");
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        DomainMBean domainMBean = runtimeAccess.getDomain();
        this.recalculateTargets(domainMBean);
        TreeSet<DeploymentMBean> treeSet = new TreeSet<DeploymentMBean>(deploymentComparator);
        DeploymentMBean[] deploymentMBeanArray = domainMBean.getDeployments();
        for (int i = 0; i < deploymentMBeanArray.length; ++i) {
            DeploymentMBean deploymentMBean = deploymentMBeanArray[i];
            if (!DeploymentHandlerHome.isResourceDependent(deploymentMBean)) continue;
            if (this.isTargetedToThisServer(deploymentMBean)) {
                treeSet.add(deploymentMBean);
            }
            deploymentMBean.addBeanUpdateListener(this.deploymentListener);
        }
        for (DeploymentMBean deploymentMBean : treeSet) {
            this.invokeHandlers(deploymentMBean, 0, null);
        }
        return treeSet;
    }

    public synchronized void activateInitialDeployments(Set set) throws DeploymentException {
        DeploymentHandlerHome.debug("Activate initial deployments");
        this.activateInitialDeployments(set, false);
    }

    public synchronized void activateResourceDependentInitialDeployments(Set set) throws DeploymentException {
        DeploymentHandlerHome.debug("Activate resource dependent initial deployments");
        this.activateInitialDeployments(set, true);
    }

    private synchronized void activateInitialDeployments(Set set, boolean bl) throws DeploymentException {
        if (set != null && set.size() > 0) {
            for (DeploymentMBean deploymentMBean : set) {
                DeploymentHandlerHome.debug("activateInitialDeployments " + deploymentMBean.getName());
                this.invokeHandlers(deploymentMBean, 2, null);
            }
        }
        if (!bl) {
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            domainMBean.addBeanUpdateListener(this.createDomainUpdateListener());
        }
    }

    public synchronized Set deactivateCurrentDeployments() throws UndeploymentException {
        return this.deactivateCurrentDeployments(false);
    }

    public synchronized Set deactivateResourceDependentCurrentDeployments() throws UndeploymentException {
        return this.deactivateCurrentDeployments(true);
    }

    private synchronized Set deactivateCurrentDeployments(boolean bl) throws UndeploymentException {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        DomainMBean domainMBean = runtimeAccess.getDomain();
        this.recalculateTargets(domainMBean);
        TreeSet<DeploymentMBean> treeSet = new TreeSet<DeploymentMBean>(deploymentComparatorReverse);
        DeploymentMBean[] deploymentMBeanArray = domainMBean.getDeployments();
        for (int i = 0; i < deploymentMBeanArray.length; ++i) {
            DeploymentMBean deploymentMBean = deploymentMBeanArray[i];
            if (DeploymentHandlerHome.isResourceDependent(deploymentMBean) != bl || !this.isTargetedToThisServer(deploymentMBean)) continue;
            treeSet.add(deploymentMBean);
        }
        for (DeploymentMBean deploymentMBean : treeSet) {
            DeploymentHandlerHome.debug("deactivateCurrentDeployments " + deploymentMBean.getName());
            this.invokeHandlers(deploymentMBean, 3, null);
        }
        return treeSet;
    }

    public synchronized void unprepareCurrentDeployments(Set set) throws UndeploymentException {
        this.unprepareCurrentDeployments(set, false);
    }

    public synchronized void unprepareResourceDependentCurrentDeployments(Set set) throws UndeploymentException {
        this.unprepareCurrentDeployments(set, true);
    }

    private synchronized void unprepareCurrentDeployments(Set set, boolean bl) throws UndeploymentException {
        if (set != null) {
            for (DeploymentMBean deploymentMBean : set) {
                DeploymentHandlerHome.debug("prepareInitialDeployments " + deploymentMBean.getName());
                this.invokeHandlers(deploymentMBean, 1, null);
            }
        }
    }

    private void invokeHandlers(DeploymentMBean deploymentMBean, int n, DeploymentHandlerContext deploymentHandlerContext) {
        Iterator iterator;
        this.exceptionList.clear();
        if (!DeploymentHandlerHome.isResourceDependent(deploymentMBean)) {
            DeploymentHandlerHome.debug("Invoking resource independent handlers on " + deploymentMBean.getName());
            iterator = this.deploymentHandlers.iterator();
        } else {
            DeploymentHandlerHome.debug("Invoking Resource dependent handlers on " + deploymentMBean.getName());
            iterator = this.resourceDependentDeploymentHandlers.iterator();
        }
        while (iterator.hasNext()) {
            DeploymentHandler deploymentHandler = (DeploymentHandler)iterator.next();
            try {
                switch (n) {
                    case 0: {
                        DeploymentHandlerHome.debug("  Call prepare on " + deploymentHandler + " with " + deploymentMBean.getName());
                        deploymentHandler.prepareDeployment(deploymentMBean, deploymentHandlerContext);
                        break;
                    }
                    case 2: {
                        DeploymentHandlerHome.debug("  Call activate on " + deploymentHandler + " with " + deploymentMBean.getName());
                        deploymentHandler.activateDeployment(deploymentMBean, deploymentHandlerContext);
                        break;
                    }
                    case 3: {
                        DeploymentHandlerHome.debug("  Call deactivate on " + deploymentHandler + " with " + deploymentMBean.getName());
                        deploymentHandler.deactivateDeployment(deploymentMBean, deploymentHandlerContext);
                        break;
                    }
                    case 1: {
                        DeploymentHandlerHome.debug("  Call unprepare on " + deploymentHandler + " with " + deploymentMBean.getName());
                        deploymentHandler.unprepareDeployment(deploymentMBean, deploymentHandlerContext);
                    }
                }
            }
            catch (DeploymentException deploymentException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Exception in DeploymentHandlerHome: ", (Throwable)((Object)deploymentException));
                }
                ManagementLogger.logDeploymentFailed((String)deploymentMBean.getName(), (Throwable)((Object)deploymentException));
                this.exceptionList.add(deploymentException);
            }
            catch (UndeploymentException undeploymentException) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Exception in DeploymentHandlerHome: ", (Throwable)((Object)undeploymentException));
                }
                ManagementLogger.logUndeploymentFailed((String)deploymentMBean.getName(), (Throwable)((Object)undeploymentException));
                this.exceptionList.add(undeploymentException);
            }
        }
    }

    private boolean isTargetedToThisServer(DeploymentMBean deploymentMBean) {
        TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (!this.regularTargets.contains(targetMBeanArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    private Object getChangedObject(BeanUpdateEvent.PropertyUpdate propertyUpdate) {
        int n = propertyUpdate.getUpdateType();
        if (n == 2) {
            return propertyUpdate.getAddedObject();
        }
        return propertyUpdate.getRemovedObject();
    }

    private void recalcTargetsIfNeeded(BeanUpdateEvent beanUpdateEvent) {
        boolean bl = false;
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        for (int i = 0; i < propertyUpdateArray.length; ++i) {
            BeanUpdateEvent.PropertyUpdate propertyUpdate = propertyUpdateArray[i];
            Object object = this.getChangedObject(propertyUpdate);
            if (object instanceof DeploymentMBean && object instanceof TargetMBean) {
                bl = true;
            }
            if (!bl) continue;
            this.recalculateTargets((DomainMBean)beanUpdateEvent.getProposedBean());
        }
    }

    private void recalculateTargets(DomainMBean domainMBean) {
        String string = ManagementService.getRuntimeAccess(kernelId).getServerName();
        ServerMBean serverMBean = domainMBean.lookupServer(string);
        this.regularTargets.clear();
        this.regularTargets.add(string);
        String string2 = null;
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean != null) {
            string2 = clusterMBean.getName();
            this.regularTargets.add(string2);
            MigratableTargetMBean[] migratableTargetMBeanArray = clusterMBean.getMigratableTargets();
            block0: for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
                MigratableTargetMBean migratableTargetMBean = migratableTargetMBeanArray[i];
                ServerMBean[] serverMBeanArray = migratableTargetMBean.getAllCandidateServers();
                for (int j = 0; j < serverMBeanArray.length; ++j) {
                    if (!string.equals(serverMBeanArray[j].getName())) continue;
                    this.regularTargets.add(migratableTargetMBean.getName());
                    continue block0;
                }
            }
        }
    }

    private static void debug(String string) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug(string);
        }
    }

    private static boolean isResourceDependent(ConfigurationMBean configurationMBean) {
        for (int i = 0; i < RESOURCE_DEPENDENT_DEPLOYMENTS.length; ++i) {
            if (!RESOURCE_DEPENDENT_DEPLOYMENTS[i].isAssignableFrom(configurationMBean.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean addDeploymentHandler(DeploymentHandler deploymentHandler) {
        if (deploymentHandler == null) {
            throw new NullPointerException("null handler");
        }
        if (deploymentHandler instanceof ResourceDependentDeploymentHandler) {
            DeploymentHandlerHome.debug("Add resource dependent deployment handler: " + deploymentHandler);
            return DeploymentHandlerHome.getInstance().resourceDependentDeploymentHandlers.add(deploymentHandler);
        }
        DeploymentHandlerHome.debug("Add resource independent deployment handler: " + deploymentHandler);
        return DeploymentHandlerHome.getInstance().deploymentHandlers.add(deploymentHandler);
    }

    public static boolean removeDeploymentHandler(DeploymentHandler deploymentHandler) {
        if (deploymentHandler == null) {
            return false;
        }
        if (deploymentHandler instanceof ResourceDependentDeploymentHandler) {
            DeploymentHandlerHome.debug("Remove resource dependent deployment handler: " + deploymentHandler);
            return DeploymentHandlerHome.getInstance().resourceDependentDeploymentHandlers.remove(deploymentHandler);
        }
        DeploymentHandlerHome.debug("Remove resource independent deployment handler: " + deploymentHandler);
        return DeploymentHandlerHome.getInstance().deploymentHandlers.remove(deploymentHandler);
    }

    private static class Initializer {
        static final DeploymentHandlerHome SINGLETON = new DeploymentHandlerHome();

        private Initializer() {
        }
    }
}

