/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.util.Properties;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.bootstrap.BootStrapConstants;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.internal.ConfigLogger;
import weblogic.management.internal.InteractiveConfigurationException;
import weblogic.management.internal.ManagementTextTextFormatter;
import weblogic.management.internal.ServerLocks;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.PDevHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class DomainDirectoryService
extends AbstractServerService
implements BootStrapConstants {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    private static final boolean nodeManagerBoot = Boolean.getBoolean("weblogic.system.NodeManagerBoot");
    private static final String startmode = System.getProperty("weblogic.management.startmode");
    private static FileLock serverLock;
    private static ManagementTextTextFormatter mgmtTextFormatter;
    private boolean resumeInvokedFirstTime = true;
    private static final AuthenticatedSubject kernelId;

    public void start() throws ServiceFailureException {
        try {
            this.ensureDomainExists();
            ServerLocks.getServerLock();
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException(managementException.getMessage(), (Throwable)managementException);
        }
        catch (Exception exception) {
            throw new ServiceFailureException(exception.getMessage());
        }
    }

    public void stop() throws ServiceFailureException {
        ServerLocks.releaseServerLock();
    }

    public void halt() throws ServiceFailureException {
        this.stop();
    }

    private void ensureDomainExists() throws ManagementException {
        if (DomainDirectoryService.isCreateNeeded()) {
            boolean bl;
            String string = BootStrap.getDomainName();
            String string2 = BootStrap.getServerName();
            if (string == null) {
                string = "mydomain";
            }
            if (string2 == null) {
                string2 = "myserver";
            }
            File file = new File(DomainDir.getConfigDir());
            File file2 = new File(file, "config.xml");
            String string3 = file2.getAbsolutePath();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("configFile: " + file2);
                debugLogger.debug("domainName: " + string);
                debugLogger.debug("serverName: " + string2);
                debugLogger.debug("PropertyService: " + (Object)((Object)ManagementService.getPropertyService(kernelId)));
            }
            if (nodeManagerBoot || "WinSvc".equalsIgnoreCase(startmode)) {
                String string4 = mgmtTextFormatter.failedToLocateConfigFile(string3);
                throw new ConfigurationException(string4);
            }
            boolean bl2 = bl = DomainDirectoryService.willGenerateConfigBasedOnProps() || DomainDirectoryService.willGenerateConfigInteractively(file2);
            if (!bl) {
                String string5 = mgmtTextFormatter.failedToLocateConfigFile(string3);
                String string6 = mgmtTextFormatter.noConfigFileWillNotGenerate(string5, "weblogic.management.GenerateDefaultConfig");
                throw new InteractiveConfigurationException(string6);
            }
            this.logNoConfig(string3);
            this.generateDomain(string, string2);
        }
    }

    private void generateDomain(String string, String string2) throws ManagementException {
        try {
            Object object;
            Class<?> clazz = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                object = PDevHelper.getPDevClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                clazz = Class.forName("com.oracle.cie.domain.DomainInfoHelper", true, (ClassLoader)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = mgmtTextFormatter.unAvailableConfigWizardCompoment();
                throw new ManagementException(string3);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            ManagementService.getPropertyService(kernelId).initializeSecurityProperties(true);
            object = System.getProperty("weblogic.ListenAddress");
            String string4 = System.getProperty("weblogic.ListenPort");
            String string5 = ManagementService.getPropertyService(kernelId).getTimestamp1();
            String string6 = ManagementService.getPropertyService(kernelId).getTimestamp2();
            Properties properties = new Properties();
            properties.put("DomainName", string);
            properties.put("ServerName", string2);
            if (object != null) {
                properties.put("ListenAddress", object);
            }
            if (string4 != null) {
                properties.put("ListenPort", string4);
            }
            properties.put("domain.OverwriteDomain", "true");
            String string7 = DomainDir.getRootDir();
            string7 = string7 == null ? new File(".").getAbsolutePath() : new File(string7).getAbsolutePath();
            ManagementLogger.logGeneratingDomainDirectory((String)string7);
            long l = System.currentTimeMillis();
            Class[] classArray = new Class[]{String.class, String.class, String.class, Properties.class};
            Method method = clazz.getMethod("createDefaultDomain", classArray);
            Object[] objectArray = new Object[]{string7, string5, string6, properties};
            method.invoke(clazz.newInstance(), objectArray);
            long l2 = System.currentTimeMillis();
            ManagementLogger.logDomainDirectoryGenerationComplete((long)(l2 - l));
        }
        catch (Exception exception) {
            throw new ManagementException("Failure during domain creation", (Throwable)exception);
        }
    }

    private void logNoConfig(String string) {
        String string2 = mgmtTextFormatter.failedToLocateConfigFile(string);
        ManagementLogger.logFailedToFindConfig((String)string2);
    }

    private static boolean willGenerateConfigInteractively(File file) {
        String string;
        if (DomainDirectoryService.willGenerateConfigBasedOnProps()) {
            return true;
        }
        String string2 = mgmtTextFormatter.getAffirmitaveGenerateConfigText();
        String string3 = mgmtTextFormatter.getNegativeGenerateConfigText();
        int n = 1;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        System.out.println("\n" + mgmtTextFormatter.failedToLocateConfigFile(string));
        while (n < 4) {
            String string4 = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("\n" + mgmtTextFormatter.getGenerateDefaultConfigInteractively(string2, string3) + ": ");
                string4 = bufferedReader.readLine();
                if (string4 != null && string4.equalsIgnoreCase(string2)) {
                    return true;
                }
                if (string4 != null && string4.equalsIgnoreCase(string3)) {
                    return false;
                }
                System.out.println("\n" + mgmtTextFormatter.getPleaseConfirmDeny(string2, string3));
                ++n;
            }
            catch (Exception exception) {
                ++n;
                debugLogger.debug("Unexpected Exception: " + exception, (Throwable)exception);
            }
        }
        return false;
    }

    private static boolean willGenerateConfigBasedOnProps() {
        if (System.getProperty("gdc") != null) {
            return true;
        }
        return System.getProperty("weblogic.management.GenerateDefaultConfig") != null;
    }

    public static boolean isCreateNeeded() throws ManagementException {
        return DomainDirectoryService.isCreateNeeded(new File(DomainDir.getRootDir()));
    }

    public static boolean isCreateNeeded(File file) throws ManagementException {
        if (!ManagementService.getPropertyService(kernelId).isAdminServer()) {
            return false;
        }
        File file2 = new File(file, "config");
        File file3 = new File(file, BootStrap.getConfigFileName());
        File file4 = new File(file2, "config.xml");
        File file5 = DomainDirectoryService.findParentConfig(file);
        if (file3.exists() || file4.exists()) {
            return false;
        }
        if (file5 != null && file5.exists()) {
            ConfigLogger.logConfigXMLFoundInParentDir((String)file5.getAbsolutePath());
        }
        return true;
    }

    private static File findParentConfig(File file) {
        File file2 = null;
        String string = file.getParent();
        if (string != null) {
            file2 = new File(string, "config.xml");
        }
        return file2;
    }

    static {
        mgmtTextFormatter = ManagementTextTextFormatter.getInstance();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

