/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.File;
import java.io.IOException;
import weblogic.management.DomainDir;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;

public final class EncryptedData {
    public static void initialize() {
        ClearOrEncryptedService clearOrEncryptedService = SINGLETON.encryptor;
    }

    public static String decrypt(String string) {
        return SINGLETON.encryptor.decrypt(string);
    }

    static String encrypt(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Can't encrypt null or empty string");
        }
        return SINGLETON.encryptor.encrypt(string);
    }

    private static ClearOrEncryptedService createEncryptionService() {
        try {
            File file = new File(DomainDir.getRootDir());
            EncryptionService encryptionService = SerializedSystemIni.getEncryptionService(file.getCanonicalPath());
            return new ClearOrEncryptedService(encryptionService);
        }
        catch (IOException iOException) {
            AssertionError assertionError = new AssertionError((Object)"Failed to find SerializedSystemIni.dat");
            ((Throwable)((Object)assertionError)).initCause(iOException);
            throw assertionError;
        }
    }

    static /* synthetic */ ClearOrEncryptedService access$000() {
        return EncryptedData.createEncryptionService();
    }

    private static class SINGLETON {
        static final ClearOrEncryptedService encryptor = EncryptedData.access$000();

        private SINGLETON() {
        }
    }
}

