/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfo;
import weblogic.common.internal.PeerInfo;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.AttributeAddNotification;
import weblogic.management.AttributeRemoveNotification;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.RemoteMBeanServer;
import weblogic.management.WebLogicMBean;
import weblogic.management.WebLogicObjectName;
import weblogic.management.commo.StandardInterface;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.info.ExtendedInfo;
import weblogic.management.internal.AttributeChangeNotification;
import weblogic.management.internal.BaseNotificationListener;
import weblogic.management.internal.OnewayNotificationListenerImpl;
import weblogic.management.internal.RelayNotificationListenerImpl;
import weblogic.management.internal.WebLogicAttribute;
import weblogic.utils.AssertionError;

public class MBeanProxy
implements InvocationHandler,
Serializable,
NotificationBroadcaster {
    private static final long serialVersionUID = -3989625551485752570L;
    protected MBeanHome mbeanHome;
    protected WebLogicObjectName objectName;
    protected transient MBeanInfo info;
    protected transient Map listeners;
    private final boolean cachingDisabled = true;
    private boolean unregistered = false;
    private DynamicMBean delegate;
    private transient RemoteMBeanServer mbeanServer;
    private static final String[] EMPTY_SIGNATURE = new String[0];
    private static final int INITIAL_CAPACITY_FOR_MBEAN_TYPES = 89;
    private static Map mbeanInfos = new HashMap(89);
    private static Map configMBeanInfos = new HashMap(89);
    private static Map adminMBeanInfos = new HashMap(89);
    private static final String ADMIN_CONFIG_PKG_NAME = "weblogic.management.configuration";

    public MBeanProxy(DynamicMBean dynamicMBean) {
        this.delegate = dynamicMBean;
    }

    public MBeanProxy(ObjectName objectName, MBeanHome mBeanHome) {
        this.mbeanHome = mBeanHome;
        this.objectName = (WebLogicObjectName)objectName;
        try {
            this.info = this.getMBeanServer().getMBeanInfo((ObjectName)this.objectName);
        }
        catch (Exception exception) {
            throw new ConfigurationError(exception);
        }
    }

    public final MBeanHome getMBeanHome() {
        return this.mbeanHome;
    }

    public final boolean isUnregistered() {
        return this.unregistered;
    }

    public WebLogicObjectName getObjectName() {
        return this.objectName;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            String string = method.getName();
            if (method.getDeclaringClass() == Object.class || method.getDeclaringClass() == NotificationBroadcaster.class) {
                return method.invoke((Object)this, objectArray);
            }
            if (string.equals("isRegistered") && (null == objectArray || objectArray.length == 0) && method.getReturnType() == Boolean.TYPE) {
                return this.isUnregistered() ? Boolean.FALSE : Boolean.TRUE;
            }
            if ((string.startsWith("get") || string.startsWith("is")) && (objectArray == null || objectArray.length == 0)) {
                return this.getAttribute(string);
            }
            if (string.equals("setAttributes") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.setAttributes(objectArray[0]);
            }
            if (string.equals("setAttribute") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.setOneAttribute(objectArray[0]);
            }
            if (string.equals("getAttributes") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.getAttributes(objectArray[0]);
            }
            if (string.equals("getAttribute") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.getOneAttribute(objectArray[0]);
            }
            if (string.startsWith("set") && objectArray != null && objectArray.length == 1) {
                return this.setAttribute(string, objectArray[0]);
            }
            if (string.equals("invoke") && method.getDeclaringClass() == DynamicMBean.class) {
                return this.dynamicInvoke(objectArray);
            }
            return this.invoke(string, objectArray);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException.getTargetException();
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (ConfigurationError configurationError) {
            throw configurationError;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public final void registerConfigMBean(String string, MBeanServer mBeanServer) {
        if (!WebLogicObjectName.isAdmin((ObjectName)this.objectName)) {
            throw new AssertionError("registerConfigMBean should only be called on AdminMBean, and this is: " + this.objectName);
        }
        try {
            this.invokeForCachingStub("registerConfigMBean", new Object[]{string, mBeanServer});
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public final void unRegisterConfigMBean(String string) {
        if (!WebLogicObjectName.isAdmin((ObjectName)this.objectName)) {
            throw new AssertionError("unRegisterConfigMBean should only be called on AdminMBean, and this is: " + this.objectName);
        }
        try {
            this.invokeForCachingStub("unRegisterConfigMBean", new Object[]{string});
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public final void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        BaseNotificationListener baseNotificationListener;
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        if ((baseNotificationListener = (BaseNotificationListener)this.listeners.get(notificationListener)) == null && null != (baseNotificationListener = this.objectName instanceof WebLogicObjectName && "LogBroadcasterRuntime".equals(this.objectName.getType()) ? new OnewayNotificationListenerImpl(this, notificationListener) : new RelayNotificationListenerImpl(this, notificationListener))) {
            this.listeners.put(notificationListener, baseNotificationListener);
        }
        baseNotificationListener.addFilterAndHandback(notificationFilter, object);
    }

    public final void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.listeners == null) {
            throw new ListenerNotFoundException("listener: " + notificationListener);
        }
        BaseNotificationListener baseNotificationListener = (BaseNotificationListener)this.listeners.get(notificationListener);
        if (baseNotificationListener == null) {
            throw new ListenerNotFoundException("listener: " + notificationListener);
        }
        baseNotificationListener.remove();
        this.listeners.remove(notificationListener);
    }

    public final void sendNotification(NotificationListener notificationListener, Notification notification, Object object) {
        if (this.isUnregistered()) {
            return;
        }
        Notification notification2 = null;
        try {
            notification2 = this.wrapNotification(notification);
        }
        catch (ManagementException managementException) {
            ManagementLogger.logExceptionInMBeanProxy((Throwable)managementException);
            return;
        }
        notificationListener.handleNotification(notification2, object);
    }

    public final Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Proxy) {
            return object.equals(this);
        }
        return object instanceof MBeanProxy && this.equalsMBeanProxy((MBeanProxy)object);
    }

    public int hashCode() {
        int n = this.objectName.hashCode();
        if (this.mbeanHome != null) {
            n ^= this.mbeanHome.hashCode();
        }
        return n;
    }

    public String toString() {
        return "Proxy for " + this.objectName;
    }

    protected final Object invokeForCachingStub(String string, Object[] objectArray) throws Throwable {
        try {
            if (string.equals("isRegistered")) {
                return this.isUnregistered() ? Boolean.FALSE : Boolean.TRUE;
            }
            if (string.equals("getObjectName")) {
                return this.objectName;
            }
            if (string.equals("getName")) {
                return this.objectName.getName();
            }
            if (string.equals("getType")) {
                return this.objectName.getType();
            }
            if (string.equals("getMBeanInfo")) {
                return this.info;
            }
            if (string.equals("isCachingDisabled")) {
                return Boolean.TRUE;
            }
            if ((string.startsWith("get") || string.startsWith("is")) && (objectArray == null || objectArray.length == 0)) {
                return this.getAttribute(string);
            }
            if (string.equals("addNotificationListener")) {
                System.out.println("addNotificationListener in invokeForCachingStub");
                this.addNotificationListener((NotificationListener)objectArray[0], (NotificationFilter)objectArray[1], objectArray[2]);
                return null;
            }
            if (string.equals("removeNotificationListener")) {
                this.removeNotificationListener((NotificationListener)objectArray[0]);
                return null;
            }
            if (string.equals("getNotificationInfo")) {
                return this.getNotificationInfo();
            }
            if (string.equals("setAttributes")) {
                return this.setAttributes(objectArray[0]);
            }
            if (string.equals("setAttribute")) {
                return this.setOneAttribute(objectArray[0]);
            }
            if (string.equals("getAttributes")) {
                return this.getAttributes(objectArray[0]);
            }
            if (string.equals("getAttribute")) {
                return this.getOneAttribute(objectArray[0]);
            }
            if (string.startsWith("set") && objectArray != null && objectArray.length == 1) {
                return this.setAttribute(string, objectArray[0]);
            }
            if (string.equals("invoke")) {
                return this.dynamicInvoke(objectArray);
            }
            return this.invoke(string, objectArray);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException.getTargetException();
        }
        catch (RuntimeMBeanException runtimeMBeanException) {
            throw runtimeMBeanException.getTargetException();
        }
        catch (ConfigurationError configurationError) {
            throw configurationError;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    protected void readObjectForCachingStubs(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.objectName = (WebLogicObjectName)objectInputStream.readObject();
        this.mbeanHome = (MBeanHome)objectInputStream.readObject();
    }

    protected void writeObjectForCachingStubs(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.objectName);
        objectOutputStream.writeObject(this.mbeanHome);
    }

    void unregister() {
        if (this.isUnregistered()) {
            return;
        }
        this.unregistered = true;
        if (this.listeners != null) {
            Iterator iterator = new HashSet(this.listeners.keySet()).iterator();
            while (iterator.hasNext()) {
                try {
                    this.removeNotificationListener((NotificationListener)iterator.next());
                }
                catch (ListenerNotFoundException listenerNotFoundException) {}
            }
        }
        this.info = null;
        this.mbeanHome = null;
        this.info = null;
    }

    private RemoteMBeanServer getMBeanServer() {
        return this.mbeanServer != null ? this.mbeanServer : (this.mbeanServer = this.mbeanHome.getMBeanServer());
    }

    private Object getAttribute(String string) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException, MBeanException {
        String string2 = null;
        string2 = string.charAt(0) == 'g' ? string.substring(3) : string.substring(2);
        if (this.delegate != null) {
            try {
                return this.wrap(string2, this.delegate.getAttribute(string2));
            }
            catch (ManagementException managementException) {
                throw new MBeanException((Exception)((Object)managementException));
            }
        }
        if (this.mbeanHome == null) {
            throw new InstanceNotFoundException(this.objectName.toString());
        }
        RemoteMBeanServer remoteMBeanServer = this.getMBeanServer();
        Object object = remoteMBeanServer.getAttribute((ObjectName)this.objectName, string2);
        if ((this.unregistered || object == null) && this.mbeanHome.getMBean((ObjectName)this.objectName) == null) {
            throw new InstanceNotFoundException("MBean with " + this.objectName + " has been deleted or unregistered from the server");
        }
        try {
            object = this.wrap(string2, object);
        }
        catch (ManagementException managementException) {
            throw new MBeanException((Exception)((Object)managementException));
        }
        return object;
    }

    private Object getOneAttribute(Object object) throws AttributeNotFoundException, InstanceNotFoundException, ReflectionException, MBeanException {
        if (this.delegate != null) {
            return this.delegate.getAttribute((String)object);
        }
        RemoteMBeanServer remoteMBeanServer = this.getMBeanServer();
        Object object2 = remoteMBeanServer.getAttribute((ObjectName)this.objectName, (String)object);
        return object2;
    }

    private Object getAttributes(Object object) throws InstanceNotFoundException, ReflectionException {
        if (this.delegate != null) {
            return this.delegate.getAttributes((String[])object);
        }
        RemoteMBeanServer remoteMBeanServer = this.getMBeanServer();
        AttributeList attributeList = remoteMBeanServer.getAttributes((ObjectName)this.objectName, (String[])object);
        return attributeList;
    }

    private MBeanAttributeInfo getAttributeInfo(String string) throws AttributeNotFoundException {
        if (this.info != null) {
            MBeanAttributeInfo[] mBeanAttributeInfoArray = this.info.getAttributes();
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                if (!mBeanAttributeInfoArray[i].getName().equals(string)) continue;
                return mBeanAttributeInfoArray[i];
            }
        }
        throw new AttributeNotFoundException(string);
    }

    private MBeanOperationInfo getOperationInfo(String string, Object[] objectArray) throws OperationsException, ClassNotFoundException {
        MBeanOperationInfo[] mBeanOperationInfoArray = this.info.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            if (!mBeanOperationInfoArray[i].getName().equals(string) || !MBeanProxy.isAssignableFrom(objectArray, mBeanOperationInfoArray[i].getSignature())) continue;
            return mBeanOperationInfoArray[i];
        }
        throw new OperationsException("no such operation: " + string);
    }

    private final Object setAttribute(String string, Object object) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        String string2 = string.substring(3);
        if (this.delegate != null) {
            WebLogicAttribute webLogicAttribute = new WebLogicAttribute(string2, object);
            this.delegate.setAttribute(webLogicAttribute);
        } else {
            Object object2 = this.unwrap(object);
            WebLogicAttribute webLogicAttribute = new WebLogicAttribute(string2, object2);
            RemoteMBeanServer remoteMBeanServer = this.getMBeanServer();
            try {
                remoteMBeanServer.setAttribute((ObjectName)this.objectName, webLogicAttribute);
                if (webLogicAttribute.getName().equals("Parent")) {
                    this.setParent((WebLogicMBean)object);
                }
            }
            catch (RuntimeErrorException runtimeErrorException) {
                ManagementLogger.logMBeanProxySetAttributeError((ObjectName)this.objectName, (String)string, (Object)object, (Object)object2, (Throwable)runtimeErrorException.getTargetError());
                throw runtimeErrorException;
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                RuntimeException runtimeException = runtimeOperationsException.getTargetException();
                ManagementLogger.logExceptionInMBeanProxy((Throwable)runtimeException);
            }
        }
        return null;
    }

    private final Object setOneAttribute(Object object) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.delegate != null) {
            this.delegate.setAttribute((Attribute)object);
        } else {
            Attribute attribute = (Attribute)object;
            RemoteMBeanServer remoteMBeanServer = this.getMBeanServer();
            remoteMBeanServer.setAttribute((ObjectName)this.objectName, this.unwrap(attribute));
            if (attribute.getName().equals("Parent")) {
                if (this.unwrap(attribute) instanceof WebLogicMBean) {
                    this.setParent((WebLogicMBean)this.unwrap(attribute.getValue()));
                } else {
                    try {
                        this.objectName = new WebLogicObjectName(this.objectName, (WebLogicObjectName)attribute.getValue());
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        throw new ConfigurationError(malformedObjectNameException);
                    }
                }
            }
        }
        return null;
    }

    private final Object setAttributes(Object object) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        WebLogicMBean webLogicMBean = null;
        AttributeList attributeList = null;
        if (this.delegate != null) {
            attributeList = this.delegate.setAttributes((AttributeList)object);
        } else {
            RemoteMBeanServer remoteMBeanServer = this.getMBeanServer();
            attributeList = remoteMBeanServer.setAttributes((ObjectName)this.objectName, this.unwrap((AttributeList)object));
        }
        if (webLogicMBean != null) {
            this.setParent(webLogicMBean);
        }
        return attributeList;
    }

    private final void setParent(WebLogicMBean webLogicMBean) {
        try {
            this.objectName = new WebLogicObjectName(this.objectName, webLogicMBean.getObjectName());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new ConfigurationError(malformedObjectNameException);
        }
    }

    private final boolean equalsMBeanProxy(MBeanProxy mBeanProxy) {
        return this.objectName.equals((Object)mBeanProxy.objectName) && (this.mbeanHome == null ? mBeanProxy.mbeanHome == null : this.mbeanHome.equals(mBeanProxy.mbeanHome));
    }

    private Object invoke(String string, Object[] objectArray) throws InstanceNotFoundException, MBeanException, ReflectionException, ClassNotFoundException, OperationsException {
        RemoteMBeanServer remoteMBeanServer = this.getMBeanServer();
        MBeanOperationInfo mBeanOperationInfo = this.getOperationInfo(string, objectArray);
        Class clazz = MBeanProxy.findClass(mBeanOperationInfo.getReturnType());
        Object[] objectArray2 = this.unwrap(objectArray);
        try {
            Object object;
            if (this.delegate != null) {
                String[] stringArray = MBeanProxy.getSignature(objectArray);
                object = this.delegate.invoke(string, objectArray2, stringArray);
            } else {
                MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo.getSignature();
                String[] stringArray = new String[mBeanParameterInfoArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = mBeanParameterInfoArray[i].getType();
                }
                object = remoteMBeanServer.invoke((ObjectName)this.objectName, string, objectArray2, stringArray);
            }
            return this.wrap(clazz, object);
        }
        catch (RuntimeErrorException runtimeErrorException) {
            throw runtimeErrorException.getTargetError();
        }
    }

    private Object dynamicInvoke(Object[] objectArray) throws InstanceNotFoundException, MBeanException, ReflectionException, ClassNotFoundException, OperationsException {
        RemoteMBeanServer remoteMBeanServer = this.getMBeanServer();
        MBeanOperationInfo mBeanOperationInfo = this.getOperationInfo((String)objectArray[0], this.wrap((String[])objectArray[2], (Object[])objectArray[1]));
        Class clazz = MBeanProxy.findClass(mBeanOperationInfo.getReturnType());
        if (this.delegate != null) {
            return this.wrap(clazz, this.delegate.invoke((String)objectArray[0], this.unwrap((Object[])objectArray[1]), (String[])objectArray[2]));
        }
        try {
            return this.wrap(clazz, remoteMBeanServer.invoke((ObjectName)this.objectName, (String)objectArray[0], this.unwrap((Object[])objectArray[1]), (String[])objectArray[2]));
        }
        catch (RuntimeErrorException runtimeErrorException) {
            throw runtimeErrorException.getTargetError();
        }
    }

    private AttributeList unwrap(AttributeList attributeList) {
        if (attributeList == null) {
            return null;
        }
        AttributeList attributeList2 = new AttributeList();
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = this.unwrap((Attribute)iterator.next());
            if (null == attribute) continue;
            attributeList2.add(attribute);
        }
        return attributeList2;
    }

    private Attribute unwrap(Attribute attribute) {
        if (null == attribute) {
            return null;
        }
        String string = attribute.getName();
        Object object = this.unwrap(attribute.getValue());
        if (null == string) {
            return null;
        }
        return new WebLogicAttribute(string, object);
    }

    private Object[] unwrap(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.unwrap(objectArray[i]);
        }
        return objectArray2;
    }

    private Object unwrap(Object object) {
        if (object instanceof WebLogicMBean) {
            return ((WebLogicMBean)object).getObjectName();
        }
        if (object instanceof WebLogicMBean[]) {
            WebLogicMBean[] webLogicMBeanArray = (WebLogicMBean[])object;
            WebLogicObjectName[] webLogicObjectNameArray = new WebLogicObjectName[webLogicMBeanArray.length];
            for (int i = 0; i < webLogicObjectNameArray.length; ++i) {
                webLogicObjectNameArray[i] = webLogicMBeanArray[i].getObjectName();
            }
            return webLogicObjectNameArray;
        }
        if (object instanceof StandardInterface) {
            return ((StandardInterface)object).wls_getObjectName();
        }
        if (object instanceof StandardInterface[]) {
            StandardInterface[] standardInterfaceArray = (StandardInterface[])object;
            ObjectName[] objectNameArray = new ObjectName[standardInterfaceArray.length];
            for (int i = 0; i < objectNameArray.length; ++i) {
                objectNameArray[i] = standardInterfaceArray[i].wls_getObjectName();
            }
            return objectNameArray;
        }
        return object;
    }

    private Object[] wrap(String[] stringArray, Object[] objectArray) {
        if (objectArray == WebLogicAttribute.NULL_VALUE || objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                Class clazz = MBeanProxy.findClass(stringArray[i]);
                objectArray2[i] = this.wrap(clazz, objectArray[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                objectArray2[i] = objectArray[i];
            }
        }
        return objectArray2;
    }

    private Object wrap(Class clazz, Object object) {
        block10: {
            if (object == null || object == WebLogicAttribute.NULL_VALUE) {
                return null;
            }
            if (clazz == Void.class) {
                return null;
            }
            if (ObjectName.class.isAssignableFrom(clazz)) {
                return object;
            }
            try {
                if (object instanceof ObjectName) {
                    ObjectName objectName = (ObjectName)object;
                    if (objectName instanceof WebLogicObjectName) {
                        WebLogicMBean webLogicMBean = this.mbeanHome.getMBean((ObjectName)object);
                        return webLogicMBean;
                    }
                    break block10;
                }
                if (object instanceof ObjectName[]) {
                    Class<?> clazz2 = clazz.getComponentType();
                    Object[] objectArray = (Object[])object;
                    int n = objectArray.length;
                    Object[] objectArray2 = (Object[])Array.newInstance(clazz2, n);
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object2;
                        objectArray2[i] = object2 = this.wrap(clazz2, objectArray[i]);
                    }
                    return objectArray2;
                }
                return object;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                return null;
            }
            catch (Throwable throwable) {
                ManagementLogger.logExceptionInMBeanProxy((Throwable)throwable);
            }
        }
        return object;
    }

    private Object wrap(String string, Object object) throws ManagementException {
        if (object == WebLogicAttribute.NULL_VALUE) {
            return null;
        }
        try {
            if (string.equals("ObjectName")) {
                return object;
            }
            MBeanAttributeInfo mBeanAttributeInfo = this.getAttributeInfo(string);
            Class clazz = MBeanProxy.findClass(mBeanAttributeInfo.getType());
            return this.wrap(clazz, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ManagementException("error wrapping " + string + ", value=" + object, (Throwable)classNotFoundException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new ManagementException("error wrapping " + string + ", value=" + object, (Throwable)attributeNotFoundException);
        }
    }

    private Notification wrapNotification(Notification notification) throws ManagementException {
        String string = null;
        Notification notification2 = notification;
        String string2 = null;
        if (notification instanceof AttributeAddNotification) {
            AttributeAddNotification attributeAddNotification = (AttributeAddNotification)notification;
            string2 = attributeAddNotification.getAttributeName();
            string = attributeAddNotification.getAttributeType();
            Object object = attributeAddNotification.getAddedValue();
            notification2 = new AttributeAddNotification((ObjectName)this.objectName, string2, string, this.wrap(string2, object));
        } else if (notification instanceof AttributeRemoveNotification) {
            AttributeRemoveNotification attributeRemoveNotification = (AttributeRemoveNotification)notification;
            string2 = attributeRemoveNotification.getAttributeName();
            string = attributeRemoveNotification.getAttributeType();
            Object object = attributeRemoveNotification.getRemovedValue();
            notification2 = new AttributeRemoveNotification((ObjectName)this.objectName, string2, string, this.wrap(string2, object));
        } else if (notification instanceof AttributeChangeNotification) {
            AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)notification;
            string2 = attributeChangeNotification.getAttributeName();
            string = attributeChangeNotification.getAttributeType();
            if (string2.equals("ObjectName")) {
                return notification;
            }
            Object object = attributeChangeNotification.getOldValue();
            Object object2 = attributeChangeNotification.getNewValue();
            notification2 = new AttributeChangeNotification((ObjectName)this.objectName, string2, string, this.wrap(string2, object), this.wrap(string2, object2));
        } else {
            notification2 = notification;
        }
        return notification2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(((ModelMBeanInfo)((Object)this.info)).getMBeanDescriptor().getFieldValue("interfaceclassname"));
            objectOutputStream.writeBoolean(this.objectName.isAdmin() || this.objectName.isConfig());
        }
        catch (MBeanException mBeanException) {
            throw new IOException(mBeanException.toString());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.info = MBeanProxy.findExtendedInfo(objectInputStream);
    }

    public Descriptor getDescriptor() {
        return null;
    }

    public DescriptorBean getParentBean() {
        return null;
    }

    public boolean isSet(String string) {
        return false;
    }

    public void unSet(String string) {
    }

    public void addBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
    }

    public void removeBeanUpdateListener(BeanUpdateListener beanUpdateListener) {
    }

    public boolean isEditable() {
        return false;
    }

    public Object clone() {
        return null;
    }

    private static boolean isAssignableFrom(Object[] objectArray, MBeanParameterInfo[] mBeanParameterInfoArray) throws ClassNotFoundException {
        int n;
        if (objectArray == null) {
            return mBeanParameterInfoArray.length == 0;
        }
        if (objectArray.length != mBeanParameterInfoArray.length) {
            return false;
        }
        Class[] classArray = new Class[objectArray.length];
        Class[] classArray2 = new Class[mBeanParameterInfoArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            classArray[n] = objectArray[n] == null ? null : objectArray[n].getClass();
        }
        for (n = 0; n < objectArray.length; ++n) {
            String string = mBeanParameterInfoArray[n].getType();
            classArray2[n] = string == null ? Void.class : MBeanProxy.wrapClass(MBeanProxy.findClass(string));
        }
        for (n = 0; n < classArray.length; ++n) {
            if (classArray[n] == null || classArray2[n].isAssignableFrom(classArray[n])) continue;
            return false;
        }
        return true;
    }

    private static String[] getSignature(Object[] objectArray) {
        String[] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (objectArray[i] != null) {
                    if (WebLogicMBean.class.isAssignableFrom(objectArray[i].getClass())) {
                        stringArray[i] = "javax.management.ObjectName";
                        continue;
                    }
                    stringArray[i] = objectArray[i].getClass().getName();
                    continue;
                }
                stringArray[i] = "void";
            }
        } else {
            objectArray = EMPTY_SIGNATURE;
        }
        return stringArray;
    }

    private static ExtendedInfo findExtendedInfo(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        boolean bl = objectInput.readBoolean();
        if (string == null) {
            return null;
        }
        try {
            if (bl && MBeanProxy.isAdminOrConfigMBeanClass(string)) {
                return MBeanProxy.getAdminOrConfigMBeanInfo(MBeanProxy.mbeanType(string));
            }
            return MBeanProxy.getMBeanInfo(MBeanProxy.findClass(string));
        }
        catch (ConfigurationException configurationException) {
            Throwable throwable = configurationException.getNestedException();
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable.toString());
        }
    }

    private static Class findClass(String string) throws ClassNotFoundException {
        if (string.equals(Long.class.getName())) {
            return Long.TYPE;
        }
        if (string.equals(Double.class.getName())) {
            return Double.TYPE;
        }
        if (string.equals(Float.class.getName())) {
            return Float.TYPE;
        }
        if (string.equals(Integer.class.getName())) {
            return Integer.TYPE;
        }
        if (string.equals(Character.class.getName())) {
            return Character.TYPE;
        }
        if (string.equals(Short.class.getName())) {
            return Short.TYPE;
        }
        if (string.equals(Byte.class.getName())) {
            return Byte.TYPE;
        }
        if (string.equals(Boolean.class.getName())) {
            return Boolean.TYPE;
        }
        if (string.equals(Void.class.getName())) {
            return Void.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("void")) {
            return Void.TYPE;
        }
        if (string.endsWith("[]")) {
            Class clazz = MBeanProxy.findClass(string.substring(0, string.length() - 2));
            return Array.newInstance(clazz, 0).getClass();
        }
        return Class.forName(string);
    }

    private static Class wrapClass(Class clazz) {
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    private static ExtendedInfo getAdminOrConfigMBeanInfo(String string) {
        try {
            ExtendedInfo extendedInfo = null;
            boolean bl = string.endsWith("Config");
            if (bl) {
                string = MBeanProxy.getAdminType(string);
                extendedInfo = (ExtendedInfo)configMBeanInfos.get(string);
            } else {
                extendedInfo = (ExtendedInfo)adminMBeanInfos.get(string);
            }
            if (extendedInfo != null) {
                return extendedInfo;
            }
            Class clazz = MBeanProxy.findClass("weblogic.management.configuration." + string + "MBean");
            extendedInfo = MBeanProxy.getMBeanInfo(clazz);
            if (bl) {
                configMBeanInfos.put(string, extendedInfo);
            } else {
                adminMBeanInfos.put(string, extendedInfo);
            }
            return extendedInfo;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError(classNotFoundException);
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigurationError(configurationException);
        }
    }

    private static ExtendedInfo getMBeanInfo(Class clazz) throws ConfigurationException {
        ExtendedInfo extendedInfo = (ExtendedInfo)mbeanInfos.get(clazz);
        if (extendedInfo == null) {
            StringBuffer stringBuffer = new StringBuffer(clazz.getName());
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != '.') continue;
                stringBuffer.setCharAt(i, '/');
            }
            stringBuffer.append(".mbi");
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = null;
            inputStream = classLoader != null ? classLoader.getResourceAsStream(stringBuffer.toString()) : ClassLoader.getSystemResourceAsStream(stringBuffer.toString());
            if (inputStream == null) {
                return null;
            }
            try {
                inputStream = new BufferedInputStream(inputStream);
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                extendedInfo = (ExtendedInfo)objectInputStream.readObject();
                objectInputStream.close();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException((Throwable)classNotFoundException);
            }
            catch (IOException iOException) {
                throw new ConfigurationException((Throwable)iOException);
            }
            if (extendedInfo == null) {
                throw new ConfigurationException("no info found for " + clazz);
            }
            mbeanInfos.put(clazz, extendedInfo);
        }
        return extendedInfo;
    }

    private static String mbeanType(String string) {
        String string2 = MBeanProxy.trimPackage(string);
        if (string2.endsWith("MBean")) {
            string2 = string2.substring(0, string2.length() - 5);
        }
        return string2;
    }

    private static String trimPackage(String string) {
        int n = string.lastIndexOf(46);
        int n2 = string.length();
        if (n != -1) {
            string = string.substring(n + 1, n2);
        }
        return string;
    }

    private static boolean isAdminOrConfigMBeanClass(String string) {
        try {
            Class.forName(string);
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
                return string.equals(ADMIN_CONFIG_PKG_NAME);
            }
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static String getAdminType(String string) {
        if (string.endsWith("Config")) {
            string = string.substring(0, string.length() - "Config".length());
        }
        return string;
    }
}

