/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.util.Properties;
import java.util.StringTokenizer;
import weblogic.Home;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.internal.Utils;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class OCMService
extends AbstractServerService {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    private static boolean DEBUG = debugLogger.isDebugEnabled();
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String OCM_DIR = "utils" + File.separator + "ccr";
    private static final String FILE_NAME = "domainlocation.properties";
    private static final String DOMAIN_SEPARATOR = ",";
    private static final long LOCK_TIMEOUT_MILLIS = 30000L;

    public void start() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
        if (!domainMBean.isOCMEnabled()) {
            if (DEBUG) {
                OCMService.debug("OCM is disabled since domainMBean.isOCMEnabled()=" + domainMBean.isOCMEnabled());
            }
            return;
        }
        if (DEBUG) {
            OCMService.debug("started");
        }
        if (!ManagementService.getRuntimeAccess(KERNEL_ID).isAdminServer()) {
            if (DEBUG) {
                OCMService.debug("Production mode but not an admin server. quit");
            }
            return;
        }
        WorkManager workManager = WorkManagerFactory.getInstance().getDefault();
        if (DEBUG) {
            OCMService.debug("scheduling the OCMRunnable ...");
        }
        workManager.schedule((Runnable)new OCMRunnable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordDomainRoot(File file, String string, String string2) throws IOException {
        FileLock fileLock = null;
        Properties properties = new Properties();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rws");
            fileLock = OCMService.lock(file, randomAccessFile);
            if (fileLock == null) {
                if (DEBUG) {
                    OCMService.debug("unable to get lock on " + file.getAbsolutePath());
                }
                return;
            }
            if (DEBUG) {
                OCMService.debug(file + " is locked with " + fileLock);
            }
            OCMService.load(properties, randomAccessFile);
            if (DEBUG) {
                OCMService.debug("loaded properties [" + properties + "]");
            }
            if (DEBUG) {
                OCMService.debug("machineName=" + string + ", currentDomainRoot=" + string2);
            }
            if (string == null || string2 == null) {
                return;
            }
            String string3 = properties.getProperty(string);
            if (DEBUG) {
                OCMService.debug("domainRoots=" + string3);
            }
            if (OCMService.isPresent(string3, string2)) {
                return;
            }
            string3 = string3 == null ? string2 : string3 + DOMAIN_SEPARATOR + string2;
            properties.setProperty(string, string3);
            if (DEBUG) {
                OCMService.debug("storing updated domainRoots=" + string3);
            }
            OCMService.store(properties, randomAccessFile);
        }
        finally {
            block28: {
                try {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {
                    if (!DEBUG) break block28;
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static boolean isPresent(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        string2 = string2.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DOMAIN_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            if (string3 != null) {
                string3 = string3.trim();
            }
            if (DEBUG) {
                OCMService.debug("comparing root=" + string3 + " with " + string2 + " with result " + string2.equalsIgnoreCase(string3));
            }
            if (!string2.equalsIgnoreCase(string3)) continue;
            return true;
        }
        if (DEBUG) {
            OCMService.debug("found no match!");
        }
        return false;
    }

    private static FileLock lock(File file, RandomAccessFile randomAccessFile) throws IOException {
        FileChannel fileChannel = randomAccessFile.getChannel();
        if (DEBUG) {
            OCMService.debug("attempting to lock " + file);
        }
        return Utils.getFileLock(fileChannel, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void store(Properties properties, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        RandomAccessFileOutputStream randomAccessFileOutputStream = new RandomAccessFileOutputStream(randomAccessFile);
        try {
            properties.store(randomAccessFileOutputStream, "");
        }
        finally {
            if (randomAccessFileOutputStream != null) {
                try {
                    randomAccessFileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(Properties properties, RandomAccessFile randomAccessFile) throws IOException {
        RandomAccessFileInputStream randomAccessFileInputStream = new RandomAccessFileInputStream(randomAccessFile);
        try {
            properties.load(randomAccessFileInputStream);
        }
        finally {
            if (randomAccessFileInputStream != null) {
                try {
                    randomAccessFileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean create(File file) {
        try {
            if (file.createNewFile()) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.exists();
    }

    private static void debug(String string) {
        debugLogger.debug("[OCMService] " + string);
    }

    private static class RandomAccessFileOutputStream
    extends OutputStream {
        RandomAccessFile raf;

        RandomAccessFileOutputStream(RandomAccessFile randomAccessFile) {
            this.raf = randomAccessFile;
        }

        public void write(int n) throws IOException {
            this.raf.write(n);
        }
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        RandomAccessFile raf;

        RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
            this.raf = randomAccessFile;
        }

        public int read() throws IOException {
            return this.raf.read();
        }
    }

    private static class OCMRunnable
    implements Runnable {
        private OCMRunnable() {
        }

        public void run() {
            block9: {
                File file;
                if (DEBUG) {
                    OCMService.debug("OCMRunnable has started");
                }
                String string = Home.getMiddlewareHomePath();
                if (DEBUG) {
                    OCMService.debug("home=" + string);
                }
                if (string != null) {
                    string = string + File.separator + OCM_DIR;
                }
                if (!(file = new File(string)).exists()) {
                    if (DEBUG) {
                        OCMService.debug(file.getAbsolutePath() + " does not exist!");
                    }
                    return;
                }
                File file2 = new File(file, OCMService.FILE_NAME);
                if (!file2.exists() && !OCMService.create(file2)) {
                    if (DEBUG) {
                        OCMService.debug(file2.getAbsolutePath() + " failed to create !");
                    }
                    return;
                }
                try {
                    String string2 = InetAddress.getLocalHost().getHostName();
                    String string3 = DomainDir.getRootDir();
                    OCMService.recordDomainRoot(file2, string2, string3);
                }
                catch (IOException iOException) {
                    if (!DEBUG) break block9;
                    OCMService.debug("failed to record current domain root! abort!");
                    iOException.printStackTrace();
                }
            }
        }
    }
}

