/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.management.ManagementLogger;
import weblogic.management.bootstrap.BootStrap;
import weblogic.utils.ArrayUtils;

public class PendingDirectoryManager {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationEdit");
    private static final String sep = File.separator;
    private static String pendingDir;
    private static String configDir;
    private static PendingDirectoryManager dirManager;

    private PendingDirectoryManager() {
        String string = DomainDir.getRootDir();
        pendingDir = DomainDir.getPendingDir();
        configDir = DomainDir.getConfigDir();
    }

    public static PendingDirectoryManager getInstance() {
        return dirManager;
    }

    public InputStream getFileAsStream(String string) throws IOException {
        this.validateRelativePath(string);
        File file = this.getPendingFile(string);
        if (file != null) {
            return new FileInputStream(file);
        }
        return new FileInputStream(configDir + sep + string);
    }

    public boolean fileExists(String string) {
        this.validateRelativePath(string);
        File file = this.getPendingFile(string);
        return file != null;
    }

    public OutputStream getFileOutputStream(String string) throws IOException {
        this.validateRelativePath(string);
        String string2 = pendingDir + sep + string;
        File file = new File(string2);
        String string3 = file.getParent();
        if (string3 != null) {
            File file2 = new File(string3);
            file2.mkdirs();
        }
        return new FileOutputStream(string2);
    }

    public InputStream getConfigAsStream() throws IOException {
        return this.getFileAsStream(BootStrap.getDefaultConfigFileName());
    }

    public boolean configExists() {
        return this.fileExists(BootStrap.getDefaultConfigFileName());
    }

    public OutputStream getConfigOutputStream() throws IOException {
        return this.getFileOutputStream(BootStrap.getDefaultConfigFileName());
    }

    public InputStream getSecurityConfigAsStream(String string) throws IOException {
        this.validateFilename(string);
        return this.getFileAsStream("security" + sep + string);
    }

    public boolean securityConfigExists(String string) {
        this.validateFilename(string);
        return this.fileExists("security" + sep + string);
    }

    public OutputStream getSecurityConfigOutputStream(String string) throws IOException {
        this.validateFilename(string);
        return this.getFileOutputStream("security" + sep + string);
    }

    public InputStream getGlobalDescriptorAsStream(String string) throws IOException {
        this.validateFilename(string);
        return this.getFileAsStream(string);
    }

    public boolean globalDescriptorExists(String string) {
        this.validateFilename(string);
        return this.fileExists(string);
    }

    public OutputStream getGlobalDescriptorOutputStream(String string) throws IOException {
        this.validateFilename(string);
        return this.getFileOutputStream(string);
    }

    public InputStream getDeploymentPlanAsStream(String string, String string2) throws IOException {
        this.validateAppName(string);
        this.validateFilename(string2);
        return this.getFileAsStream("deployments" + sep + string + sep + string2);
    }

    public boolean deploymentPlanExists(String string, String string2) {
        this.validateAppName(string);
        this.validateFilename(string2);
        return this.fileExists("deployments" + sep + string + sep + string2);
    }

    public OutputStream getDeploymentPlanOutputStream(String string, String string2) throws IOException {
        this.validateAppName(string);
        this.validateFilename(string2);
        return this.getFileOutputStream("deployments" + sep + string + sep + string2);
    }

    public File getFile(String string) {
        this.validateRelativePath(string);
        File file = this.getPendingFile(string);
        return file;
    }

    public boolean deleteAll() {
        boolean bl = true;
        File file = new File(pendingDir);
        if (!this.remove(file, true)) {
            bl = false;
        }
        return bl;
    }

    public boolean deleteFile(String string) {
        this.validateRelativePath(string);
        File file = this.getPendingFile(string);
        if (file == null) {
            return false;
        }
        return file.delete();
    }

    public boolean deleteConfig() {
        return this.deleteFile(BootStrap.getDefaultConfigFileName());
    }

    public boolean deleteSecurityConfig(String string) {
        this.validateFilename(string);
        return this.deleteFile("security" + sep + string);
    }

    public boolean deleteGlobalDescriptor(String string) {
        this.validateFilename(string);
        return this.deleteFile(string);
    }

    public boolean deleteDeploymentPlan(String string, String string2) {
        this.validateAppName(string);
        this.validateFilename(string2);
        return this.deleteFile("deployments" + sep + string + sep + string2);
    }

    public File[] getAllFiles() {
        File file = new File(pendingDir);
        return this.find(file);
    }

    public File getConfigFile() {
        return this.getPendingFile(BootStrap.getDefaultConfigFileName());
    }

    public File[] getConfigFiles() {
        File file = new File(pendingDir);
        return this.find(file, false);
    }

    public File[] getSecurityConfigFiles() {
        File file = new File(pendingDir + sep + "security");
        return this.find(file);
    }

    public File[] getDeploymentFiles() {
        File file = new File(pendingDir + sep + "deployments");
        return this.find(file);
    }

    public String removePendingDirectoryFromPath(String string) {
        String string2 = pendingDir + sep;
        if (string.startsWith(string2) || new File(string).getPath().startsWith(new File(string2).getPath())) {
            return DomainDir.getConfigDir() + sep + string.substring(string2.length(), string.length());
        }
        return string;
    }

    private void validateRelativePath(String string) {
        if (string == null) {
            throw new AssertionError((Object)"filename should not be null");
        }
    }

    private void validateFilename(String string) {
        if (string == null) {
            throw new AssertionError((Object)"filename should not be null");
        }
    }

    private void validateAppName(String string) {
        if (string == null) {
            throw new AssertionError((Object)"application name should not be null");
        }
    }

    private File getPendingFile(String string) {
        String string2 = pendingDir + sep + string;
        File file = new File(string2);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private boolean remove(File file, boolean bl) {
        boolean bl2 = true;
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory() && bl && !this.remove(file2, bl)) {
                bl2 = false;
            }
            if (!file2.delete()) {
                if (!file2.isDirectory()) {
                    bl2 = false;
                    ManagementLogger.logPendingDeleteFileFailed((String)file2.getAbsolutePath());
                }
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("Failed to delete file " + file2);
                continue;
            }
            if (!debugLogger.isDebugEnabled()) continue;
            debugLogger.debug("Deleted file " + file2);
        }
        return bl2;
    }

    private File[] find(File file) {
        return this.find(file, true);
    }

    private File[] find(File file, boolean bl) {
        if (!file.exists()) {
            return new File[0];
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory.");
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                if (!bl) continue;
                ArrayUtils.addAll(arrayList, (Object[])this.find(file2));
                continue;
            }
            arrayList.add(file2);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    static {
        dirManager = new PendingDirectoryManager();
    }
}

