/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.rmi.RemoteException;
import java.rmi.server.Unreferenced;
import weblogic.management.configuration.RemoteEnumeration;
import weblogic.management.internal.BatchedEnumeration;

public class RemoteEnumerationImpl
implements RemoteEnumeration,
Unreferenced {
    private static boolean debug = false;
    private BatchedEnumeration batchedEnumeration;
    private boolean done = false;

    public RemoteEnumerationImpl(BatchedEnumeration batchedEnumeration) throws RemoteException {
        this.batchedEnumeration = batchedEnumeration;
        if (debug) {
            this.trace("constructor");
        }
    }

    public Object[] getNextBatch() {
        if (debug) {
            this.trace("getNextBatch");
        }
        if (this.done) {
            return null;
        }
        Object[] objectArray = this.batchedEnumeration.getNextBatch();
        if (objectArray == null) {
            this.close();
        }
        return objectArray;
    }

    public void close() {
        if (debug) {
            this.trace("close");
        }
        if (this.done) {
            return;
        }
        this.done = true;
        this.batchedEnumeration.close();
    }

    public void unreferenced() {
        if (debug) {
            this.trace("unreferenced");
        }
        this.close();
    }

    public void finalize() {
        if (debug) {
            this.trace("finalize");
        }
    }

    private void trace(String string) {
        System.out.println("RemoteEnumerationImpl done=" + this.done + " " + string);
    }
}

