/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import weblogic.management.PrincipalInfo;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ListResults;
import weblogic.management.configuration.RealmMBean;
import weblogic.management.configuration.RemoteEnumeration;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.internal.BatchedEnumeration;
import weblogic.management.internal.RemoteEnumerationImpl;
import weblogic.management.internal.RemoteRealmException;
import weblogic.management.internal.RemoteRealmManager;
import weblogic.management.provider.ManagementService;
import weblogic.rmi.server.UnicastRemoteObject;
import weblogic.security.acl.CredentialChanger;
import weblogic.security.acl.ManageableRealm;
import weblogic.security.acl.Realm;
import weblogic.security.acl.User;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.enumerations.IteratorEnumerator;

public class RemoteRealmManagerImpl
implements RemoteRealmManager {
    private static boolean debug = false;
    private int batchSize = 200;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public RemoteRealmManagerImpl() {
        RealmMBean realmMBean;
        SecurityMBean securityMBean;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (domainMBean != null && (securityMBean = domainMBean.getSecurity()) != null && (realmMBean = securityMBean.getRealm()) != null) {
            this.batchSize = realmMBean.getResultsBatchSize();
        }
        if (debug) {
            this.trace("constructor");
        }
    }

    public ListResults getMembers(String string) throws RemoteException, RemoteRealmException {
        if (debug) {
            this.trace("getMembers(" + string + ")");
        }
        this.checkReadAccess();
        Group group = this.getGroup(string);
        return this.getListResults(group.members(), new BatchedEnumeration.ElementHandler(){

            public Object handle(Object object) {
                if (debug) {
                    RemoteRealmManagerImpl.this.trace("getMembers.handle(" + ((Principal)object).getName() + ")");
                }
                return RemoteRealmManagerImpl.this.getPrincipalInfo((Principal)object);
            }
        });
    }

    public String[] getPermissions(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("getPermissions(" + string + ")");
        }
        this.checkReadAccess();
        Acl acl = this.getAcl(string);
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration = acl.entries();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = (AclEntry)enumeration.nextElement();
            Enumeration enumeration2 = aclEntry.permissions();
            while (enumeration2.hasMoreElements()) {
                String string2 = this.getPermissionName((Permission)enumeration2.nextElement());
                hashSet.add(string2);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    public ListResults getGrantees(String string, String string2) throws RemoteException, RemoteRealmException {
        if (debug) {
            this.trace("getGrantees(" + string + "," + string2 + ")");
        }
        this.checkReadAccess();
        Acl acl = this.getAcl(string);
        HashSet<PrincipalInfo> hashSet = new HashSet<PrincipalInfo>();
        Enumeration enumeration = acl.entries();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = (AclEntry)enumeration.nextElement();
            Principal principal = aclEntry.getPrincipal();
            Enumeration enumeration2 = aclEntry.permissions();
            while (enumeration2.hasMoreElements()) {
                if (!this.getPermissionName((Permission)enumeration2.nextElement()).equals(string2)) continue;
                hashSet.add(this.getPrincipalInfo(principal));
            }
        }
        return this.getListResults((Enumeration)new IteratorEnumerator(hashSet.iterator()), new BatchedEnumeration.ElementHandler(){

            public Object handle(Object object) {
                return object;
            }
        });
    }

    public void createUser(String string, Object object) throws RemoteRealmException {
        if (debug) {
            this.trace("createUser(" + string + ")");
        }
        this.checkWriteAccess();
        this.getRealm().newUser(string, object, null);
    }

    public void createGroup(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("createGroup(" + string + ")");
        }
        this.checkWriteAccess();
        this.getRealm().newGroup(string);
    }

    public void createAcl(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("createAcl(" + string + ")");
        }
        this.checkWriteAccess();
        this.getRealm().newAcl(this.getAclOwner(), string);
    }

    public void removeUser(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("removeUser(" + string + ")");
        }
        this.checkWriteAccess();
        User user = this.getUser(string);
        this.getRealm().deleteUser(user);
    }

    public void removeGroup(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("removeGroup(" + string + ")");
        }
        this.checkWriteAccess();
        Group group = this.getGroup(string);
        this.getRealm().deleteGroup(group);
    }

    public void removeAcl(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("removeAcl(" + string + ")");
        }
        this.checkWriteAccess();
        Acl acl = this.getAcl(string);
        this.getRealm().deleteAcl(this.getAclOwner(), acl);
    }

    public boolean userExists(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("userExists(" + string + ")");
        }
        this.checkReadAccess();
        return this.getRealm().getUser(string) != null;
    }

    public boolean groupExists(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("groupExists(" + string + ")");
        }
        this.checkReadAccess();
        return this.getRealm().getGroup(string) != null;
    }

    public boolean aclExists(String string) throws RemoteRealmException {
        if (debug) {
            this.trace("aclExists(" + string + ")");
        }
        this.checkReadAccess();
        return this.getRealm().getAcl(string) != null;
    }

    public ListResults listUsers() throws RemoteException, RemoteRealmException {
        if (debug) {
            this.trace("listUsers");
        }
        if (!this.isAdmin()) {
            return null;
        }
        this.checkReadAccess();
        return this.getListResults(this.getRealm().getUsers(), new BatchedEnumeration.ElementHandler(){

            public Object handle(Object object) {
                if (debug) {
                    RemoteRealmManagerImpl.this.trace("listUsers.handle(" + ((User)object).getName() + ")");
                }
                if (object == null) {
                    return null;
                }
                return ((User)object).getName();
            }
        });
    }

    public ListResults listGroups() throws RemoteException, RemoteRealmException {
        if (debug) {
            this.trace("listGroups");
        }
        if (!this.isAdmin()) {
            return null;
        }
        this.checkReadAccess();
        return this.getListResults(this.getRealm().getGroups(), new BatchedEnumeration.ElementHandler(){

            public Object handle(Object object) {
                if (debug) {
                    RemoteRealmManagerImpl.this.trace("listGroup.handle(" + ((Group)object).getName() + ")");
                }
                return ((Group)object).getName();
            }
        });
    }

    public ListResults listAcls() throws RemoteException, RemoteRealmException {
        if (debug) {
            this.trace("listAcls");
        }
        if (!this.isAdmin()) {
            return null;
        }
        this.checkReadAccess();
        return this.getListResults(this.getRealm().getAcls(), new BatchedEnumeration.ElementHandler(){

            public Object handle(Object object) {
                if (debug) {
                    RemoteRealmManagerImpl.this.trace("listAcls.handle(" + ((Acl)object).getName() + ")");
                }
                return ((Acl)object).getName();
            }
        });
    }

    public boolean changeCredential(String string, Object object, Object object2) throws RemoteException, RemoteRealmException {
        if (debug) {
            this.trace("changeCredential(" + string + "," + object + "," + object2 + ")");
        }
        this.checkWriteAccess();
        User user = this.getUser(string);
        if (user instanceof CredentialChanger) {
            CredentialChanger credentialChanger = (CredentialChanger)user;
            credentialChanger.changeCredential(object, object2);
            return true;
        }
        return false;
    }

    public void addMember(String string, String string2) throws RemoteRealmException {
        if (debug) {
            this.trace("addMember(" + string + "," + string2 + ")");
        }
        this.checkWriteAccess();
        Group group = this.getGroup(string);
        Principal principal = this.getPrincipal(string2);
        if (!group.addMember(principal)) {
            throw new RemoteRealmException(string2 + " is already a member of the " + string + " group.");
        }
    }

    public void removeMember(String string, String string2) throws RemoteRealmException {
        if (debug) {
            this.trace("removeMember(" + string + "," + string2 + ")");
        }
        this.checkWriteAccess();
        Group group = this.getGroup(string);
        Principal principal = this.getPrincipal(string2);
        if (!group.removeMember(principal)) {
            throw new RemoteRealmException(string2 + " is not a member of the " + string + " group.");
        }
    }

    public void grantPermission(String string, String string2, String string3) throws RemoteRealmException {
        if (debug) {
            this.trace("grantPermission(" + string + "," + string2 + "," + string3 + ")");
        }
        this.checkWriteAccess();
        Acl acl = this.getAcl(string);
        Principal principal = this.getPrincipal(string2);
        Permission permission = this.getRealm().getPermission(string3);
        this.getRealm().setPermission(acl, principal, permission, true);
    }

    public void revokePermission(String string, String string2, String string3) throws RemoteRealmException {
        if (debug) {
            this.trace("revokePermission(" + string + "," + string2 + "," + string3 + ")");
        }
        this.checkWriteAccess();
        Acl acl = this.getAcl(string);
        Principal principal = this.getPrincipal(string2);
        Permission permission = this.getRealm().getPermission(string3);
        Enumeration enumeration = acl.entries();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = (AclEntry)enumeration.nextElement();
            if (!((Object)aclEntry.getPrincipal()).equals(principal)) continue;
            AclEntry aclEntry2 = (AclEntry)aclEntry.clone();
            try {
                if (aclEntry2.removePermission(permission) && acl.removeEntry(this.getAclOwner(), aclEntry) && acl.addEntry(this.getAclOwner(), aclEntry2)) {
                    return;
                }
                throw new RemoteRealmException("Couldn't revoke permission " + string3 + " for " + string2 + " to " + string);
            }
            catch (NotOwnerException notOwnerException) {
                throw new RemoteRealmException("Couldn't revoke permission " + string3 + " for " + string2 + " to " + string);
            }
        }
        throw new RemoteRealmException(string3 + " for " + string2 + " not on " + string);
    }

    private String getPermissionName(Permission permission) {
        return permission.toString();
    }

    private PrincipalInfo getPrincipalInfo(Principal principal) {
        if (principal instanceof Group) {
            return new PrincipalInfo(principal.getName(), true);
        }
        return new PrincipalInfo(principal.getName(), false);
    }

    private Principal getPrincipal(String string) throws RemoteRealmException {
        Group group = this.getRealm().getGroup(string);
        if (group != null) {
            return group;
        }
        group = this.getRealm().getUser(string);
        if (group != null) {
            return group;
        }
        throw new RemoteRealmException("Principal " + string + " doesn't exist.");
    }

    private User getUser(String string) throws RemoteRealmException {
        User user = this.getRealm().getUser(string);
        if (user == null) {
            throw new RemoteRealmException("User " + string + " doesn't exist.");
        }
        return user;
    }

    private Group getGroup(String string) throws RemoteRealmException {
        Group group = this.getRealm().getGroup(string);
        if (group == null) {
            throw new RemoteRealmException("Group " + string + " doesn't exist.");
        }
        return group;
    }

    private Acl getAcl(String string) throws RemoteRealmException {
        Acl acl = this.getRealm().getAcl(string);
        if (acl == null) {
            throw new RemoteRealmException("Acl " + string + " doesn't exist.");
        }
        return acl;
    }

    private ManageableRealm getRealm() {
        return (ManageableRealm)Realm.getRealm("weblogic");
    }

    private Principal getAclOwner() {
        String string = (String)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return ManagementService.getPropertyService(kernelId).getTimestamp2();
            }
        });
        return this.getRealm().getAclOwner(string);
    }

    private boolean isAdmin() {
        return ManagementService.getRuntimeAccess(kernelId).isAdminServer();
    }

    private ListResults getListResults(Enumeration enumeration, BatchedEnumeration.ElementHandler elementHandler) throws RemoteException {
        if (debug) {
            this.trace("getListResults");
        }
        boolean bl = false;
        BatchedEnumeration batchedEnumeration = new BatchedEnumeration(enumeration, this.batchSize, elementHandler);
        Object[] objectArray = batchedEnumeration.getNextBatch();
        RemoteEnumerationImpl remoteEnumerationImpl = objectArray != null && batchedEnumeration.hasMoreElements() ? new RemoteEnumerationImpl(batchedEnumeration) : null;
        RemoteEnumeration remoteEnumeration = remoteEnumerationImpl != null ? (RemoteEnumeration)UnicastRemoteObject.exportObject((Remote)remoteEnumerationImpl) : null;
        return new ListResults(objectArray, remoteEnumeration);
    }

    private void trace(String string) {
        System.out.println("RemoteRealmManagerImpl " + string);
    }

    private void checkReadAccess() throws RemoteRealmException {
    }

    private void checkWriteAccess() throws RemoteRealmException {
        if (!this.isAdmin()) {
            throw new RemoteRealmException("Realms cannot be managed by managed servers.");
        }
    }
}

