/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.management.ObjectName;
import weblogic.common.internal.VersionInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.management.ManagementLogger;
import weblogic.management.NoAccessRuntimeException;
import weblogic.management.WebLogicObjectName;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.beaninfo.BeanInfoAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AdminResource;
import weblogic.security.service.MBeanResource;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.RoleManager;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.utils.Debug;

public class SecurityHelper {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    private static final String ADMIN_ROLENAME = "Admin";
    private static final String DEPLOYER_ROLENAME = "Deployer";
    private static final String OPERATOR_ROLENAME = "Operator";
    private static final String MONITOR_ROLENAME = "Monitor";
    private static final boolean ENABLE_ACL_EXCEPTION = true;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static boolean disableACLOnMbeans;
    private static boolean debugACLs;
    private static PrintStream aclPrintStream;
    private static boolean isSecServiceInitialized;
    private static AdminResource adminMBeanResource;
    private static BeanInfoAccess beanInfoAccess;
    private static RoleManager roleManager;

    public static void checkForAdminRole() {
        SecurityHelper.checkForRole(ADMIN_ROLENAME);
    }

    public static void checkForDeployerRole() {
        SecurityHelper.checkForRole(DEPLOYER_ROLENAME);
    }

    public static void checkForOperatorRole() {
        SecurityHelper.checkForRole(OPERATOR_ROLENAME);
    }

    public static boolean isProtectedAttribute(ObjectName objectName, String string, PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor != null) {
            Boolean bl = (Boolean)propertyDescriptor.getValue("encrypted");
            if (bl != null && bl.booleanValue()) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("SecurityHelper - attribute " + string + " for object " + objectName + " is protected");
                }
                return true;
            }
            Boolean bl2 = (Boolean)propertyDescriptor.getValue("sensitive");
            if (bl2 != null && bl2.booleanValue()) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("SecurityHelper - attribute " + string + " for object " + objectName + " is protected");
                }
                return true;
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("SecurityHelper - attribute " + string + " for object " + objectName + " is NOT protected");
        }
        return false;
    }

    public static void isAccessAllowed(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2) throws NoAccessRuntimeException {
        SecurityHelper.isAccessAllowed(objectName, actionType, string, string2, null, null, null);
    }

    public static void isAccessAllowed(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, BeanDescriptor beanDescriptor) throws NoAccessRuntimeException {
        SecurityHelper.isAccessAllowed(objectName, actionType, string, string2, beanDescriptor, null, null);
    }

    public static void isAccessAllowed(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, BeanDescriptor beanDescriptor, PropertyDescriptor propertyDescriptor) throws NoAccessRuntimeException {
        SecurityHelper.isAccessAllowed(objectName, actionType, string, string2, beanDescriptor, null, propertyDescriptor);
    }

    public static void isAccessAllowed(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, BeanDescriptor beanDescriptor, MethodDescriptor methodDescriptor) throws NoAccessRuntimeException {
        SecurityHelper.isAccessAllowed(objectName, actionType, string, string2, beanDescriptor, methodDescriptor, null);
    }

    private static boolean isAllowed(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, PropertyDescriptor propertyDescriptor) {
        try {
            SecurityHelper.isAccessAllowed(objectName, actionType, string, string2, null, null, propertyDescriptor);
        }
        catch (NoAccessRuntimeException noAccessRuntimeException) {
            return false;
        }
        return true;
    }

    public static boolean isAllowedAnon(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, PropertyDescriptor propertyDescriptor) {
        return SecurityHelper.isAllowed(AuthenticatedSubject.ANON, objectName, actionType, string, string2, propertyDescriptor);
    }

    public static boolean isAllowed(AuthenticatedSubject authenticatedSubject, final ObjectName objectName, final MBeanResource.ActionType actionType, final String string, final String string2, final PropertyDescriptor propertyDescriptor) {
        Boolean bl = (Boolean)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return new Boolean(SecurityHelper.isAllowed(objectName, actionType, string, string2, propertyDescriptor));
            }
        });
        return bl;
    }

    private static void isAccessAllowed(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, BeanDescriptor beanDescriptor, MethodDescriptor methodDescriptor, PropertyDescriptor propertyDescriptor) throws NoAccessRuntimeException {
        Object object;
        Object object2;
        if (disableACLOnMbeans) {
            return;
        }
        if (actionType == MBeanResource.ActionType.FIND) {
            return;
        }
        if (objectName == null) {
            SecurityHelper.checkForAdminRole();
            return;
        }
        if (actionType == MBeanResource.ActionType.READ) {
            if (propertyDescriptor == null) {
                return;
            }
            object2 = (Boolean)propertyDescriptor.getValue("encrypted");
            object = (Boolean)propertyDescriptor.getValue("sensitive");
            if (!(object2 != null && ((Boolean)object2).booleanValue() || object != null && ((Boolean)object).booleanValue())) {
                return;
            }
        }
        if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)(object2 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID)))) {
            object = new IsAccessAllowedPrivilegeAction((AuthenticatedSubject)object2, objectName, actionType, string, beanDescriptor, methodDescriptor, propertyDescriptor);
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)object);
        }
    }

    public static void isAccessAllowedCommo(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, BeanDescriptor beanDescriptor) throws NoAccessRuntimeException {
        SecurityHelper.isAccessAllowedCommo(objectName, actionType, string, string2, beanDescriptor, null, null);
    }

    public static void isAccessAllowedCommo(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, BeanDescriptor beanDescriptor, PropertyDescriptor propertyDescriptor) throws NoAccessRuntimeException {
        SecurityHelper.isAccessAllowedCommo(objectName, actionType, string, string2, beanDescriptor, null, propertyDescriptor);
    }

    public static void isAccessAllowedCommo(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, BeanDescriptor beanDescriptor, MethodDescriptor methodDescriptor) throws NoAccessRuntimeException {
        SecurityHelper.isAccessAllowedCommo(objectName, actionType, string, string2, beanDescriptor, methodDescriptor, null);
    }

    private static void isAccessAllowedCommo(ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2, BeanDescriptor beanDescriptor, MethodDescriptor methodDescriptor, PropertyDescriptor propertyDescriptor) throws NoAccessRuntimeException {
        if (disableACLOnMbeans) {
            return;
        }
        if (actionType == MBeanResource.ActionType.FIND) {
            return;
        }
        if (actionType == MBeanResource.ActionType.WRITE) {
            SecurityHelper.checkForAdminRole();
            return;
        }
        if (actionType == MBeanResource.ActionType.UNREGISTER) {
            SecurityHelper.checkForAdminRole();
            return;
        }
        if (actionType == MBeanResource.ActionType.REGISTER) {
            return;
        }
        if (objectName == null) {
            throw new IllegalArgumentException("Object name for an MBean can not be null");
        }
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            return;
        }
        if (actionType == MBeanResource.ActionType.READ) {
            Boolean bl;
            if (propertyDescriptor == null) {
                return;
            }
            Boolean bl2 = (Boolean)propertyDescriptor.getValue("encrypted");
            if (bl2 != null && bl2.booleanValue()) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("SecurityHelper - read encrypted, check for admin, attr = " + string);
                }
                SecurityHelper.checkForAdminRole();
            }
            if ((bl = (Boolean)propertyDescriptor.getValue("sensitive")) != null && bl.booleanValue()) {
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("SecurityHelper - read encrypted, check for admin, attr = " + string);
                }
                SecurityHelper.checkForAdminRole();
            }
            return;
        }
        if (actionType == MBeanResource.ActionType.EXECUTE) {
            Boolean bl;
            String[] stringArray;
            if (beanDescriptor != null) {
                stringArray = (String[])beanDescriptor.getValue("rolesAllowed");
                if (SecurityHelper.checkForRoles(stringArray)) {
                    return;
                }
                bl = (Boolean)beanDescriptor.getValue("rolePermitAll");
                if (bl != null && bl.booleanValue()) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("SecurityHelper - rolePermitAll found for interface " + string);
                    }
                    return;
                }
            }
            if (methodDescriptor != null) {
                stringArray = (String[])methodDescriptor.getValue("rolesAllowed");
                if (SecurityHelper.checkForRoles(stringArray)) {
                    return;
                }
                bl = (Boolean)methodDescriptor.getValue("rolePermitAll");
                if (bl != null && bl.booleanValue()) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("SecurityHelper - rolePermitAll found for method " + string);
                    }
                    return;
                }
            }
            SecurityHelper.checkForAdminRole();
            return;
        }
        String string3 = "Access not allowed for subject: " + authenticatedSubject + ", on Resource" + objectName.toString() + " Action: " + actionType + ", Target: " + string;
        throw new NoAccessRuntimeException(string3);
    }

    public static void assertIfNotKernel(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject != KERNEL_ID) {
            throw new AssertionError((Object)("The internal method that you have invoked is not available unless you are running as Kernel!\nYou are running as: " + authenticatedSubject));
        }
    }

    public static void assertIfNotKernel() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            throw new AssertionError((Object)("The internal method that you have invoked is not available unless you are running as Kernel!\nYou are running as: " + authenticatedSubject));
        }
    }

    private static boolean isInRole(Map map, String string) {
        return map != null && map.get(string) != null;
    }

    private static boolean isInRole(Map map, String[] stringArray) {
        if (map == null || stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (map.get(stringArray[i]) == null) continue;
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("SecurityHelper - in role is true, role " + stringArray[i]);
            }
            return true;
        }
        return false;
    }

    private static RoleManager getRoleManager() {
        return roleManager != null ? roleManager : (roleManager = (RoleManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.ROLE));
    }

    private static void checkForRole(final String string) {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            return;
        }
        final AuthenticatedSubject authenticatedSubject2 = SecurityServiceManager.seal((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
        Boolean bl = (Boolean)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Map map = SecurityHelper.getRoleManager().getRoles(authenticatedSubject2, (Resource)adminMBeanResource, null);
                return map != null && (map.get(SecurityHelper.ADMIN_ROLENAME) != null || map.get(string) != null) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (bl.booleanValue()) {
            return;
        }
        Loggable loggable = ManagementLogger.logNoAccessForSubjectRoleLoggable((String)authenticatedSubject2.toString(), (String)string);
        throw new NoAccessRuntimeException(loggable.getMessage());
    }

    private static boolean checkForRoles(final String[] stringArray) {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        final AuthenticatedSubject authenticatedSubject2 = SecurityServiceManager.seal((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
        Boolean bl = (Boolean)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Map map = SecurityHelper.getRoleManager().getRoles(authenticatedSubject2, (Resource)adminMBeanResource, null);
                if (map == null || stringArray == null) {
                    return Boolean.FALSE;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (map.get(stringArray[i]) == null) continue;
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("SecurityHelper - role found " + stringArray[i]);
                    }
                    return Boolean.TRUE;
                }
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("SecurityHelper - role not found ");
                }
                return Boolean.FALSE;
            }
        });
        return bl;
    }

    private static synchronized void dumpAclDebug(AuthenticatedSubject authenticatedSubject, ObjectName objectName, MBeanResource.ActionType actionType, String string, String string2) {
        try {
            Object object;
            if (aclPrintStream == null) {
                object = ManagementService.getRuntimeAccess(KERNEL_ID).getServerName() + "_debug_acls.txt";
                Debug.say((String)("Opening ACL Log" + (String)object));
                File file = new File((String)object);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                aclPrintStream = new PrintStream(fileOutputStream);
            }
            aclPrintStream.println("START: INVALID MBEAN ACCESS");
            aclPrintStream.println("PRINCIPALS:" + authenticatedSubject.getPrincipals());
            aclPrintStream.println("RESOURCE:" + objectName + "|" + actionType + "|" + string + "|" + string2);
            object = new Exception();
            ((Throwable)object).printStackTrace(aclPrintStream);
            aclPrintStream.println("END:INVALID MBEAN ACCESS");
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.say((String)"**** UNABLE TO OPEN DEBUG FILE *****");
        }
    }

    private static BeanInfo getBeanInfo(String string) {
        String string2;
        String string3;
        BeanInfo beanInfo;
        if (beanInfoAccess == null) {
            beanInfoAccess = ManagementService.getBeanInfoAccess();
        }
        if ((beanInfo = beanInfoAccess.getBeanInfoForInterface(string, false, string3 = VersionInfo.theOne().getReleaseVersion())) == null && string.indexOf(".") == -1) {
            string2 = "weblogic.management.configuration." + string + "MBean";
            beanInfo = beanInfoAccess.getBeanInfoForInterface(string2, false, string3);
        }
        if (beanInfo == null && string.indexOf(".") == -1) {
            string2 = "weblogic.management.runtime." + string + "MBean";
            beanInfo = beanInfoAccess.getBeanInfoForInterface(string2, true, string3);
        }
        return beanInfo;
    }

    public static BeanDescriptor getBeanDescriptor(String string) {
        BeanInfo beanInfo = SecurityHelper.getBeanInfo(string);
        if (beanInfo != null) {
            return beanInfo.getBeanDescriptor();
        }
        return null;
    }

    public static PropertyDescriptor getPropertyDescriptor(String string, String string2) {
        BeanInfo beanInfo = SecurityHelper.getBeanInfo(string);
        if (beanInfo == null) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            String string3 = propertyDescriptor.getName();
            if (!string2.equals(string3)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public static MethodDescriptor getMethodDescriptor(String string, String string2) {
        BeanInfo beanInfo = SecurityHelper.getBeanInfo(string);
        if (beanInfo == null) {
            return null;
        }
        MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
        for (int i = 0; i < methodDescriptorArray.length; ++i) {
            MethodDescriptor methodDescriptor = methodDescriptorArray[i];
            String string3 = methodDescriptor.getName();
            if (!string2.equals(string3)) continue;
            return methodDescriptor;
        }
        return null;
    }

    static {
        aclPrintStream = null;
        adminMBeanResource = new AdminResource("Configuration", null, null);
        disableACLOnMbeans = Boolean.getBoolean("weblogic.disableMBeanAuthorization");
        debugACLs = Boolean.getBoolean("DEBUG_ACLS");
    }

    private static class IsAccessAllowedPrivilegeAction
    implements PrivilegedAction {
        private final AuthenticatedSubject subject;
        private final ObjectName name;
        private final MBeanResource.ActionType action;
        private final String target;
        private final String type;
        private final BeanDescriptor beanDescriptor;
        private final MethodDescriptor methodDescriptor;
        private final PropertyDescriptor propertyDescriptor;

        IsAccessAllowedPrivilegeAction(AuthenticatedSubject authenticatedSubject, ObjectName objectName, MBeanResource.ActionType actionType, String string, BeanDescriptor beanDescriptor, MethodDescriptor methodDescriptor, PropertyDescriptor propertyDescriptor) {
            this.subject = authenticatedSubject;
            this.name = objectName;
            this.action = actionType;
            this.target = string;
            this.type = this.name.getKeyProperty("Type");
            this.beanDescriptor = beanDescriptor;
            this.methodDescriptor = methodDescriptor;
            this.propertyDescriptor = propertyDescriptor;
        }

        public Object run() {
            Map map = SecurityHelper.getRoleManager().getRoles(this.subject, (Resource)adminMBeanResource, null);
            if (SecurityHelper.isInRole(map, SecurityHelper.ADMIN_ROLENAME)) {
                return Boolean.TRUE;
            }
            if (this.name instanceof WebLogicObjectName) {
                return this.wlsRun(map);
            }
            if (this.type == null) {
                return Boolean.TRUE;
            }
            return this.wlsRun(map);
        }

        private Object wlsRun(Map map) {
            String string = "Access not allowed for subject: " + this.subject + ", on Resource" + "Type: " + (this.type != null ? this.type : this.name.toString()) + " Action: " + this.action + ", Target: " + this.target;
            if (this.action == MBeanResource.ActionType.READ) {
                Boolean bl;
                String[] stringArray;
                PropertyDescriptor propertyDescriptor = this.propertyDescriptor;
                if (propertyDescriptor == null) {
                    propertyDescriptor = SecurityHelper.getPropertyDescriptor(this.type, this.target);
                }
                if (propertyDescriptor != null) {
                    stringArray = (String[])propertyDescriptor.getValue("encrypted");
                    bl = (Boolean)propertyDescriptor.getValue("sensitive");
                    if (!(stringArray != null && stringArray.booleanValue() || bl != null && bl.booleanValue())) {
                        if (debugLogger.isDebugEnabled()) {
                            debugLogger.debug("SecurityHelper - read non-encrypted attr, attr = " + this.target);
                        }
                        return Boolean.TRUE;
                    }
                } else {
                    throw new NoAccessRuntimeException(string);
                }
                stringArray = (String[])propertyDescriptor.getValue("rolesAllowedGet");
                if (SecurityHelper.isInRole(map, stringArray)) {
                    return Boolean.TRUE;
                }
                bl = (Boolean)propertyDescriptor.getValue("rolePermitAllGet");
                if (bl != null && bl.booleanValue()) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("SecurityHelper - rolePermitAll found for get " + this.target);
                    }
                    return Boolean.TRUE;
                }
                throw new NoAccessRuntimeException(string);
            }
            if (this.action == MBeanResource.ActionType.WRITE || this.action == MBeanResource.ActionType.EXECUTE || this.action == MBeanResource.ActionType.REGISTER || this.action == MBeanResource.ActionType.UNREGISTER) {
                String[] stringArray;
                Object object;
                BeanDescriptor beanDescriptor = this.beanDescriptor;
                if (beanDescriptor == null) {
                    beanDescriptor = SecurityHelper.getBeanDescriptor(this.type);
                }
                if (beanDescriptor != null) {
                    object = (String[])beanDescriptor.getValue("rolesAllowed");
                    if (SecurityHelper.isInRole(map, (String[])object)) {
                        return Boolean.TRUE;
                    }
                    stringArray = (String[])beanDescriptor.getValue("rolePermitAll");
                    if (stringArray != null && stringArray.booleanValue()) {
                        if (debugLogger.isDebugEnabled()) {
                            debugLogger.debug("SecurityHelper - rolePermitAll found for interface ");
                        }
                        return Boolean.TRUE;
                    }
                }
                if (this.action == MBeanResource.ActionType.WRITE) {
                    object = this.propertyDescriptor;
                    if (object == null) {
                        object = SecurityHelper.getPropertyDescriptor(this.type, this.target);
                    }
                    if (object != null) {
                        stringArray = (String[])((FeatureDescriptor)object).getValue("rolesAllowedSet");
                        if (SecurityHelper.isInRole(map, stringArray)) {
                            return Boolean.TRUE;
                        }
                        Boolean bl = (Boolean)((FeatureDescriptor)object).getValue("rolePermitAllSet");
                        if (bl != null && bl.booleanValue()) {
                            if (debugLogger.isDebugEnabled()) {
                                debugLogger.debug("SecurityHelper - rolePermitAllSet found for set " + this.target);
                            }
                            return Boolean.TRUE;
                        }
                    }
                    throw new NoAccessRuntimeException(string);
                }
                if (this.action == MBeanResource.ActionType.EXECUTE) {
                    object = this.methodDescriptor;
                    if (object == null) {
                        object = SecurityHelper.getMethodDescriptor(this.type, this.target);
                    }
                    if (object != null) {
                        stringArray = (String[])((FeatureDescriptor)object).getValue("rolesAllowed");
                        if (SecurityHelper.isInRole(map, stringArray)) {
                            return Boolean.TRUE;
                        }
                        Boolean bl = (Boolean)((FeatureDescriptor)object).getValue("rolePermitAll");
                        if (bl != null && bl.booleanValue()) {
                            if (debugLogger.isDebugEnabled()) {
                                debugLogger.debug("SecurityHelper - rolePermitAll found for invoke " + this.target);
                            }
                            return Boolean.TRUE;
                        }
                    }
                }
                if (debugACLs) {
                    SecurityHelper.dumpAclDebug(this.subject, this.name, this.action, this.target, "");
                }
                throw new NoAccessRuntimeException(string);
            }
            NoAccessRuntimeException noAccessRuntimeException = new NoAccessRuntimeException("Uknown ActionType: " + this.action + " found");
            throw noAccessRuntimeException;
        }
    }
}

