/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.internal.Utils;
import weblogic.utils.FileUtils;

public class ServerLocks {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");
    private static FileLock[] serverLocks;
    private static FileLock serverLock;
    private static File[] serverLockFiles;
    private static File serverLockFile;

    public static void main(String[] stringArray) throws Exception {
        ServerLocks.getAllServerLocks();
        ServerLocks.releaseAllServerLocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getServerLock() throws ManagementException {
        String[] stringArray;
        String string = BootStrap.getServerName();
        if (string == null && (stringArray = ServerLocks.getServers()).length == 1) {
            string = stringArray[0];
        }
        serverLockFile = string != null ? ServerLocks.getServerLockFile(string) : ServerLocks.getDefaultServerLockFile();
        try {
            serverLock = ServerLocks.getServerLock(serverLockFile);
        }
        finally {
            if (serverLock == null) {
                serverLockFile = null;
            } else {
                FileUtils.registerLockFile((File)serverLockFile);
            }
        }
    }

    public static synchronized void releaseServerLock() {
        block4: {
            if (serverLock != null) {
                try {
                    serverLock.release();
                    serverLock.channel().close();
                    serverLock = null;
                    serverLockFile.delete();
                    FileUtils.unregisterLockFile((File)serverLockFile);
                    serverLockFile = null;
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("released " + serverLock);
                    }
                }
                catch (IOException iOException) {
                    if (!debugLogger.isDebugEnabled()) break block4;
                    debugLogger.debug("Exception releasing server lock " + iOException, (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void getAllServerLocks() throws ManagementException {
        if (serverLocks != null) {
            return;
        }
        String[] stringArray = ServerLocks.getServers();
        serverLocks = new FileLock[stringArray.length + 1];
        serverLockFiles = new File[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            ServerLocks.serverLockFiles[i] = ServerLocks.getServerLockFile(stringArray[i]);
            try {
                ServerLocks.serverLocks[i] = ServerLocks.getServerLock(serverLockFiles[i]);
                continue;
            }
            finally {
                if (serverLocks[i] == null) {
                    ServerLocks.serverLockFiles[i] = null;
                } else {
                    FileUtils.registerLockFile((File)serverLockFiles[i]);
                }
            }
        }
        try {
            ServerLocks.serverLockFiles[stringArray.length] = ServerLocks.getDefaultServerLockFile();
            ServerLocks.serverLocks[stringArray.length] = ServerLocks.getServerLock(serverLockFiles[stringArray.length]);
        }
        finally {
            if (serverLocks[stringArray.length] == null) {
                ServerLocks.serverLockFiles[stringArray.length] = null;
            } else {
                FileUtils.registerLockFile((File)serverLockFiles[stringArray.length]);
            }
        }
    }

    public static synchronized void releaseAllServerLocks() {
        if (serverLocks == null) {
            return;
        }
        for (int i = 0; i < serverLocks.length; ++i) {
            if (serverLocks[i] == null) continue;
            try {
                serverLocks[i].release();
                serverLocks[i].channel().close();
                ServerLocks.serverLocks[i] = null;
                serverLockFiles[i].delete();
                FileUtils.unregisterLockFile((File)serverLockFiles[i]);
                ServerLocks.serverLockFiles[i] = null;
                continue;
            }
            catch (IOException iOException) {
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("Exception releasing all server locks " + iOException, (Throwable)iOException);
            }
        }
        serverLocks = null;
        serverLockFiles = null;
    }

    private static File getServerLockFile(String string) {
        Object object;
        String string2 = DomainDir.getTempDirForServer((String)string);
        File file = new File(string2);
        if (!file.isAbsolute()) {
            object = new File(DomainDir.getRootDir());
            new File((File)object, string2);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        object = string + ".lok";
        File file2 = new File(file, (String)object);
        return file2;
    }

    private static FileLock getServerLock(File file) throws ManagementException {
        FileLock fileLock = null;
        try {
            fileLock = Utils.getFileLock(file, 185000L);
        }
        catch (Exception exception) {
            throw new ManagementException("Unable to obtain File lock on " + file.getAbsolutePath() + " : " + exception);
        }
        if (fileLock == null) {
            String string = "Unable to obtain lock on " + file.getAbsolutePath() + ". Server may already be running";
            throw new ManagementException(string);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Got lock for " + file);
        }
        return fileLock;
    }

    private static File getDefaultServerLockFile() {
        File file = new File(DomainDir.getRootDir(), "default_server.lok");
        return file;
    }

    private static String[] getServers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = new File(DomainDir.getServersDir()).listFiles();
        if (fileArray == null) {
            return new String[0];
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            arrayList.add(fileArray[i].getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

