/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementLogger;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.utils.FileUtils;

public final class Utils {
    private static final String DEFAULT_SERVER = "myserver";
    private static File configLockFile = null;
    private static FileLock configFileLock = null;
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugConfigurationRuntime");

    public static String extractDomain(String string) {
        int n = string.indexOf(":");
        if (n < 1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if (string2.equals("null")) {
            return null;
        }
        return string2;
    }

    public static FileLock getConfigFileLock() {
        return Utils.getConfigFileLock(300000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileLock getConfigFileLock(int n) {
        if (configFileLock != null) {
            return configFileLock;
        }
        try {
            configLockFile = new File(BootStrap.getConfigLockFileName());
            FileOutputStream fileOutputStream = new FileOutputStream(configLockFile);
            configFileLock = null;
            try {
                configFileLock = Utils.getFileLock(fileOutputStream.getChannel(), (long)n);
            }
            finally {
                if (configFileLock == null) {
                    configLockFile = null;
                } else {
                    FileUtils.registerLockFile((File)configLockFile);
                }
            }
            return configFileLock;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static void releaseConfigFileLock() {
        block4: {
            if (configFileLock == null) {
                return;
            }
            try {
                configFileLock.release();
                configFileLock.channel().close();
                configFileLock = null;
                configLockFile.delete();
                FileUtils.unregisterLockFile((File)configLockFile);
                configLockFile = null;
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("released config lock " + configFileLock);
                }
            }
            catch (IOException iOException) {
                if (!debugLogger.isDebugEnabled()) break block4;
                debugLogger.debug("Exception releasing config lock " + iOException, (Throwable)iOException);
            }
        }
    }

    public static FileLock getFileLock(File file) {
        return Utils.getFileLock(file, 300000L);
    }

    public static FileLock getFileLock(File file, long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            return Utils.getFileLock(fileOutputStream.getChannel(), l);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static FileLock getFileLock(File file, boolean bl) throws IOException {
        if (bl) {
            return Utils.getFileLock(file);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return Utils.getFileLock(fileOutputStream.getChannel(), 0L);
    }

    public static String findServerName(DomainMBean domainMBean) {
        String string = System.getProperty("weblogic.Name");
        if ("".equals(string)) {
            string = null;
        }
        if (string == null) {
            ServerMBean[] serverMBeanArray = domainMBean.getServers();
            if (serverMBeanArray.length == 1) {
                string = serverMBeanArray[0].getName();
            } else {
                String string2 = domainMBean.getAdminServerName();
                if (string2 == null || string2.length() == 0) {
                    string2 = DEFAULT_SERVER;
                }
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    if (!serverMBeanArray[i].getName().equals(string2)) continue;
                    string = string2;
                }
            }
        }
        return string;
    }

    static FileLock getFileLock(FileChannel fileChannel, long l) {
        long l2;
        long l3 = l2 = System.currentTimeMillis();
        long l4 = l2 + l;
        FileLock fileLock = null;
        while (fileLock == null && l2 <= l4) {
            long l5;
            try {
                fileLock = fileChannel.tryLock();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fileLock != null || (l5 = l4 - l2) <= 0L) break;
            if (l2 - l3 >= 10000L) {
                l3 = l2;
                ManagementLogger.logRetryFileLock();
            }
            try {
                Thread.sleep(l5 > 500L ? 500L : l5);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 = System.currentTimeMillis();
        }
        return fileLock;
    }
}

