/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal.mbean;

import java.security.AccessController;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.management.Admin;
import weblogic.management.MBeanHome;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public abstract class AbstractDynamicMBean
extends AbstractDescriptorBean
implements ConfigurationMBeanCustomized,
DynamicMBean,
MBeanRegistration,
NotificationBroadcaster {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public AbstractDynamicMBean() {
    }

    public AbstractDynamicMBean(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        throw new UnsupportedOperationException("AbstractDynamicMBean.getNotificationInfo()");
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
    }

    public MBeanInfo getMBeanInfo() {
        throw new UnsupportedOperationException("AbstractDynamicMBean.getMBeanInfo()");
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.getValue(string);
    }

    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            attributeList.add(new Attribute(stringArray[i], this.getValue(stringArray[i])));
        }
        return attributeList;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("AbstractDynamicMBean.invoke()");
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        this.putValue(attribute.getName(), attribute.getValue());
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        throw new UnsupportedOperationException("AbstractDynamicMBean.setAttributes()");
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return null;
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void touch() throws ConfigurationException {
        throw new UnsupportedOperationException("AbstractDynamicMBean.()");
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        throw new UnsupportedOperationException("AbstractDynamicMBean.()");
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        throw new UnsupportedOperationException("AbstractDynamicMBean.()");
    }

    public ConfigurationMBean getMbean() {
        return (ConfigurationMBean)((Object)this);
    }

    public void putValue(String string, Object object) {
        throw new AssertionError((Object)("No such field " + string));
    }

    public void putValueNotify(String string, Object object) {
        this.putValue(string, object);
    }

    public Object getValue(String string) {
        throw new AssertionError((Object)("No such field " + string));
    }

    public boolean isConfig() {
        return true;
    }

    public boolean isAdmin() {
        return false;
    }

    public boolean isEdit() {
        Descriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return false;
        }
        DescriptorBean descriptorBean = descriptor.getRootBean();
        if (descriptorBean == null || !(descriptorBean instanceof DomainMBean)) {
            return false;
        }
        return descriptorBean.isEditable();
    }

    public boolean isRuntime() {
        Descriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return false;
        }
        DescriptorBean descriptorBean = descriptor.getRootBean();
        if (descriptorBean == null || !(descriptorBean instanceof DomainMBean)) {
            return false;
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        return domainMBean == descriptorBean;
    }

    public String getType() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        if ((n = (string = string.substring(n + 1)).lastIndexOf("MBeanImpl")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public MBeanHome getMBeanHome() {
        return Admin.getInstance().getMBeanHome();
    }

    public MBeanHome getAdminMBeanHome() {
        return Admin.getInstance().getAdminMBeanHome();
    }

    public void markAttributeModified(String string) {
    }

    public void sendNotification(Notification notification) {
    }

    protected static abstract class Helper
    extends AbstractDescriptorBeanHelper {
        protected Helper(AbstractDynamicMBean abstractDynamicMBean) {
            super((AbstractDescriptorBean)abstractDynamicMBean);
        }
    }
}

