/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.internal.mbean;

import weblogic.utils.codegen.AttributeBinder;
import weblogic.utils.codegen.AttributeBinderFactory;
import weblogic.utils.codegen.AttributeBinderFactoryHelper;

public class MBeanBinderFactoryHelper
implements AttributeBinderFactoryHelper {
    private static String PACKAGE_NAME = "weblogic.management.configuration.";
    private static String BEAN_SUFFIX = "MBean";
    private static String IMPL_SUFFIX = "Binder";

    private String elementToBinderName(String string) {
        if (string.indexOf(".") != -1) {
            return string + BEAN_SUFFIX + IMPL_SUFFIX;
        }
        return PACKAGE_NAME + string + BEAN_SUFFIX + IMPL_SUFFIX;
    }

    public AttributeBinderFactory getAttributeBinderFactory(String string) throws ClassNotFoundException {
        String string2 = this.elementToBinderName(string);
        if (string2 == "DummyMBeanBinderFactory") {
            return new DummyMBeanBinderFactory(string);
        }
        Class<?> clazz = null;
        clazz = this.getClassLoader().loadClass(string2);
        try {
            return (AttributeBinderFactory)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        if (classLoader2 == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader2;
    }

    private static class DummyMBeanBinderFactory
    implements AttributeBinderFactory,
    AttributeBinder {
        private String beanClass;

        private DummyMBeanBinderFactory(String string) {
            this.beanClass = string;
        }

        public AttributeBinder getAttributeBinder() {
            return this;
        }

        public AttributeBinder bindAttribute(String string, Object object) {
            return this;
        }
    }
}

