/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.internal;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.j2ee.internal.InternalAppDataCacheService;
import weblogic.management.j2ee.internal.MBeanServerConnectionProvider;
import weblogic.utils.Debug;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

class ApplicationInfo {
    public static final int J2EE_APP = 1;
    public static final int J2EE_WEB_MODULE = 2;
    public static final int J2EE_EJB_MODULE = 3;
    public static final int J2EE_CONNECTOR_MODULE = 4;
    public static final int J2EE_APP_CLIENT_MODULE = 5;
    private static final String APP_DD_URI = "META-INF/application.xml";
    private static final String WEB_DD_URI = "WEB-INF/web.xml";
    private static final String EJB_DD_URI = "META-INF/ejb-jar.xml";
    private static final String RAR_DD_URI = "META-INF/ra.xml";
    private static final String WLS_APP_DD_URI = "META-INF/weblogic-application.xml";
    private static final String WLS_WEB_DD_URI = "WEB-INF/weblogic.xml";
    private static final String WLS_EJB_DD_URI = "META-INF/weblogic-ejb-jar.xml";
    private static final String WLS_RAR_DD_URI = "META-INF/weblogic-ra.xml";
    private final ObjectName name;
    private final int type;
    private final MBeanServerConnection domainConnection;
    private final MBeanServerConnection editConnection;
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJ2EEManagement");
    private String appSource = null;
    private String split_build_dir = null;

    public ApplicationInfo(ObjectName objectName, int n) {
        this.name = objectName;
        this.type = n;
        this.domainConnection = MBeanServerConnectionProvider.getDomainMBeanServerConnection();
        this.editConnection = MBeanServerConnectionProvider.getEditMBeanServerConnection();
    }

    public String getDescriptor() {
        switch (this.type) {
            case 1: {
                return this.getApplicationDD();
            }
            case 2: {
                return this.getWebModuleDD();
            }
            case 3: {
                return this.getEJBModuleDD();
            }
            case 4: {
                return this.getConnectorModuleDD();
            }
        }
        throw new AssertionError((Object)"In valid request");
    }

    public String getWebLogicDescriptor() {
        switch (this.type) {
            case 1: {
                return this.getWebLogicApplicationDD();
            }
            case 2: {
                return this.getWebLogicWebModuleDD();
            }
            case 3: {
                return this.getWebLogicEJBModuleDD();
            }
            case 4: {
                return this.getWebLogicConnectorModuleDD();
            }
        }
        throw new AssertionError((Object)"In valid request");
    }

    public boolean isEar() {
        return this.isEar(this.getApplicationSource());
    }

    public boolean isParentEar() {
        ObjectName objectName = this.getParentObjectName();
        return this.isEar(this.getApplicationSource(objectName));
    }

    private String getApplicationLevelDD(String string) {
        String string2;
        InputStream inputStream = null;
        VirtualJarFile virtualJarFile = null;
        try {
            String string3 = this.getApplicationSource();
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)new File(string3));
            ZipEntry zipEntry = virtualJarFile.getEntry(string);
            if (zipEntry == null) {
                String string4 = null;
                return string4;
            }
            inputStream = virtualJarFile.getInputStream(zipEntry);
            string2 = this.makeDescriptor(inputStream);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)(" Unable to read Application Deployment Descriptor: " + string));
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (virtualJarFile != null) {
                    virtualJarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string2;
    }

    private String getApplicationDD() {
        return this.getApplicationLevelDD(APP_DD_URI);
    }

    private String getWebLogicApplicationDD() {
        return this.getApplicationLevelDD(WLS_APP_DD_URI);
    }

    private String getWebModuleDD() {
        try {
            ObjectName objectName = this.getParentObjectName();
            String string = this.getApplicationSource(objectName);
            String string2 = (String)this.domainConnection.getAttribute(this.name, "ModuleURI");
            return this.getModuleDescriptor(string, string2, WEB_DD_URI);
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)"Unable to get information about Web Module");
        }
    }

    private String getWebLogicWebModuleDD() {
        return this.getModuleDD(WLS_WEB_DD_URI);
    }

    private String getEJBModuleLevelDD(String string) {
        try {
            ObjectName objectName = this.getParentObjectName();
            String string2 = this.getApplicationSource(objectName);
            String string3 = (String)this.domainConnection.getAttribute(this.name, "ModuleId");
            String string4 = this.getModuleDescriptor(string2, string3, string);
            if (string4 == null) {
                string4 = this.getModuleDescriptor(this.appSource, string3, string);
            }
            if (string4 == null) {
                string4 = "";
            }
            return string4;
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)("Unabled get information about the Module: " + string));
        }
    }

    private String getEJBModuleDD() {
        return this.getEJBModuleLevelDD(EJB_DD_URI);
    }

    private String getWebLogicEJBModuleDD() {
        return this.getEJBModuleLevelDD(WLS_EJB_DD_URI);
    }

    private String getModuleDD(String string) {
        try {
            ObjectName objectName = this.getParentObjectName();
            String string2 = this.getApplicationSource(objectName);
            String string3 = (String)this.domainConnection.getAttribute(this.name, "ModuleId");
            return this.getModuleDescriptor(string2, string3, string);
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)("Unabled get information about the Module: " + string));
        }
    }

    private String getConnectorModuleDD() {
        return this.getModuleDD(RAR_DD_URI);
    }

    private String getWebLogicConnectorModuleDD() {
        return this.getModuleDD(WLS_RAR_DD_URI);
    }

    private String getApplicationSource(ObjectName objectName) {
        if (this.type == 3 && this.split_build_dir != null) {
            return this.split_build_dir;
        }
        if (this.appSource != null) {
            return this.appSource;
        }
        String string = null;
        try {
            string = (String)this.domainConnection.getAttribute(objectName, "ApplicationName");
            String string2 = objectName.getDomain() + ":Name=" + string + ",Type=AppDeployment";
            try {
                this.appSource = (String)this.editConnection.getAttribute(new ObjectName(string2), "SourcePath");
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                this.appSource = InternalAppDataCacheService.getSourceLocation(string);
            }
            this.appSource = this.getCorrectPathIfSplitDir(this.appSource);
            return this.appSource;
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)("Failed to get information about the application" + throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCorrectPathIfSplitDir(String string) {
        FileInputStream fileInputStream;
        block15: {
            String string3;
            fileInputStream = null;
            File file = new File(string, ".beabuild.txt");
            if (!file.exists()) {
                return string;
            }
            try {
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                String string2 = properties.getProperty("bea.srcdir");
                if (string2 == null) break block15;
                this.split_build_dir = string;
                string3 = string2;
            }
            catch (Throwable throwable) {
                try {
                    String string4 = string;
                    return string4;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    try {
                        if (fileInputStream != null) {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                if (fileInputStream == null) return string3;
                ((InputStream)fileInputStream).close();
                return string3;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string3;
        }
        try {
            if (fileInputStream == null) return string;
            ((InputStream)fileInputStream).close();
            return string;
        }
        catch (IOException iOException) {
            return string;
        }
    }

    private String getApplicationSource() {
        return this.getApplicationSource(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEar(String string) {
        if (string == null) {
            return false;
        }
        if (string.endsWith("ear")) {
            return true;
        }
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)new File(string));
            if (virtualJarFile.getEntry(APP_DD_URI) != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (virtualJarFile != null) {
                    virtualJarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private ObjectName getParentObjectName() {
        try {
            return (ObjectName)this.domainConnection.getAttribute(this.name, "Parent");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new Error("Failed to access information about parent ObjectName", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            throw new Error("Failed to access information about parent ObjectName", reflectionException);
        }
        catch (IOException iOException) {
            throw new Error("Failed to access information about parent ObjectName", iOException);
        }
        catch (MBeanException mBeanException) {
            throw new Error("Failed to access information about parent ObjectName", mBeanException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new Error("Failed to access information about parent ObjectName", attributeNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getModuleDescriptor(String string, String string2, String string3) {
        ZipEntry zipEntry;
        if (debug.isDebugEnabled()) {
            Debug.say((String)("Application source: " + string + "  With uri: " + string2 + "  and deployment descriptor location: " + string3));
        }
        ZipEntry zipEntry2 = null;
        InputStream inputStream = null;
        VirtualJarFile virtualJarFile = null;
        try {
            Object object;
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)new File(string));
            if (debug.isDebugEnabled()) {
                object = virtualJarFile.entries();
                while (object.hasNext()) {
                    zipEntry = (ZipEntry)object.next();
                }
            }
            if ((zipEntry2 = virtualJarFile.getEntry(string3)) != null) {
                inputStream = virtualJarFile.getInputStream(zipEntry2);
                object = this.makeDescriptor(inputStream);
                return object;
            }
            zipEntry2 = virtualJarFile.getEntry(string2);
            if (zipEntry2 == null) {
                object = null;
                return object;
            }
            object = string2 + "/" + string3;
            zipEntry = virtualJarFile.getEntry((String)object);
            if (zipEntry != null) {
                inputStream = virtualJarFile.getInputStream(zipEntry);
                String string4 = this.makeDescriptor(inputStream);
                return string4;
            }
            inputStream = virtualJarFile.getInputStream(zipEntry2);
            String string5 = this.makeDescriptor(inputStream, string3);
            return string5;
        }
        catch (IOException iOException) {
            zipEntry = null;
            return zipEntry;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (virtualJarFile != null) {
                    virtualJarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String makeDescriptor(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            String string2 = new String();
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string + System.getProperty("line.separator");
            }
            bufferedReader.close();
            String string3 = string2;
            return string3;
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)" Unable to read Application Deployment Descriptor");
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeDescriptor(InputStream inputStream, String string) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        ZipInputStream zipInputStream = null;
        String string2 = new String();
        try {
            zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equals(string)) {
                    int n;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n = zipInputStream.read(byArray)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byteArrayOutputStream.flush();
                    string2 = byteArrayOutputStream.toString();
                    break;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            String string3 = string2;
            return string3;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string2;
    }
}

