/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.internal;

import java.io.File;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import weblogic.Home;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class InternalAppDataCacheService
extends AbstractServerService {
    private static final Map appToSource = new HashMap(7);
    private static final String LIB = Home.getPath() + File.separator + "lib";
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void start() throws ServiceFailureException {
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return;
        }
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        AppDeploymentMBean[] appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(ManagementService.getRuntimeAccess(kernelId).getDomain());
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            AppDeploymentMBean appDeploymentMBean = appDeploymentMBeanArray[i];
            if (!appDeploymentMBean.isInternalApp()) continue;
            appToSource.put(appDeploymentMBean.getName(), appDeploymentMBean.getAbsoluteSourcePath());
        }
        appToSource.put("bea_wls_cluster_internal", LIB);
    }

    public void stop() throws ServiceFailureException {
    }

    public void halt() throws ServiceFailureException {
    }

    public static String getSourceLocation(String string) {
        return (String)appToSource.get(string);
    }

    public static boolean isInternalApp(String string) {
        return appToSource.containsKey(string);
    }
}

