/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.internal;

import java.security.AccessController;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import weblogic.management.j2ee.J2EEServerMBean;
import weblogic.management.j2ee.internal.J2EEManagedObjectMBeanImpl;
import weblogic.management.j2ee.internal.JMOTypesHelper;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class J2EEServerMBeanImpl
extends J2EEManagedObjectMBeanImpl
implements J2EEServerMBean {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String serverVersion = ManagementService.getRuntimeAccess(kernelId).getServer().getServerVersion();
    private static final String serverVendor = "Oracle";
    private static final String domain = ManagementService.getRuntimeAccess(kernelId).getDomainName();
    private static String serverName = null;

    public J2EEServerMBeanImpl(String string) {
        super(string);
    }

    public String getserverVersion() {
        return serverVersion;
    }

    public String getserverVendor() {
        return serverVendor;
    }

    public String[] getjavaVMs() {
        try {
            String string = domain + ":j2eeType=" + "JVM" + "," + "J2EEServer" + "=\"" + this.getServerName() + "\",*";
            ObjectName objectName = new ObjectName(string);
            return this.queryNames(objectName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)(" Malformed ObjectName" + malformedObjectNameException));
        }
    }

    public String[] getdeployedObjects() {
        QueryExp queryExp = new QueryExp(){

            public boolean apply(ObjectName objectName) {
                String string = objectName.getKeyProperty("j2eeType");
                if (string.equals("J2EEApplication")) {
                    return true;
                }
                if (string.equals("WebModule") || string.equals("ResourceAdapterModule") || string.equals("EJBModule")) {
                    return objectName.getKeyProperty("J2EEApplication").equals("null");
                }
                return false;
            }

            public void setMBeanServer(MBeanServer mBeanServer) {
            }
        };
        return this.queryNames(queryExp);
    }

    public String[] getresources() {
        QueryExp queryExp = new QueryExp(){

            public boolean apply(ObjectName objectName) {
                return JMOTypesHelper.resourceList.contains(objectName.getKeyProperty("j2eeType"));
            }

            public void setMBeanServer(MBeanServer mBeanServer) {
            }
        };
        return this.queryNames(queryExp);
    }

    private String getServerName() {
        if (serverName != null) {
            return serverName;
        }
        try {
            ObjectName objectName = new ObjectName(this.name);
            serverName = objectName.getKeyProperty("name");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)"Malformed ObjectName detected");
        }
        return serverName;
    }
}

