/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.internal;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementLogger;
import weblogic.management.j2ee.ListenerRegistry;
import weblogic.management.j2ee.internal.InvalidObjectNameException;
import weblogic.management.j2ee.internal.JMOValidator;
import weblogic.management.j2ee.internal.MBeanServerConnectionProvider;
import weblogic.management.j2ee.internal.MBeanServerFilter;
import weblogic.management.j2ee.internal.NotificationHandler;
import weblogic.management.j2ee.internal.Types;
import weblogic.management.jmx.modelmbean.WLSModelMBean;
import weblogic.management.jmx.modelmbean.WLSModelMBeanContext;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class JMOService
implements ListenerRegistry {
    private final Map wlsToJ2EEObjectNames = new HashMap(39);
    private String defaultDomain = ManagementService.getRuntimeAccess(kernelId).getDomainName();
    private MBeanServerConnection domainRuntimeMBeanServer;
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJ2EEManagement");
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final ObjectName RUNTIME_QUERY;
    private final MBeanServer server = MBeanServerFactory.createMBeanServer();

    private JMOService() {
        MBeanServerConnectionProvider.initialize();
        this.domainRuntimeMBeanServer = MBeanServerConnectionProvider.getDomainMBeanServerConnection();
        this.registerDomainRuntimeListener();
        this.initializePreexistingBeans();
    }

    public static JMOService getJMOService() {
        return SINGLETON.service;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public Object getAttribute(ObjectName objectName, String string) throws InvalidObjectNameException, InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        this.validate(objectName);
        return this.server.getAttribute(objectName, string);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        return this.server.queryNames(objectName, queryExp);
    }

    public boolean isRegistered(ObjectName objectName) {
        return this.server.isRegistered(objectName);
    }

    public Integer getMBeanCount() {
        return this.server.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        return this.server.getMBeanInfo(objectName);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        return this.server.getAttributes(objectName, stringArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException, MBeanException, InvalidObjectNameException {
        this.validate(objectName);
        this.server.setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        return this.server.setAttributes(objectName, attributeList);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, ReflectionException, MBeanException, InvalidObjectNameException {
        this.validate(objectName);
        return this.server.invoke(objectName, string, objectArray, stringArray);
    }

    public void addListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, RemoteException {
        this.server.addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void removeListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
        this.server.removeNotificationListener(objectName, notificationListener);
    }

    private void registerDomainRuntimeListener() {
        try {
            this.domainRuntimeMBeanServer.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), new MBeanServerListener(), (NotificationFilter)new MBeanServerFilter(), null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error("Malformed ObjectName", malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new Error("DomainRuntime MBeanServer not found", instanceNotFoundException);
        }
        catch (IOException iOException) {
            throw new Error("IOException while registering with DomainRuntime MBeanServer", iOException);
        }
    }

    private void initializePreexistingBeans() {
        try {
            Set<ObjectName> set = this.domainRuntimeMBeanServer.queryNames(RUNTIME_QUERY, null);
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    ObjectName objectName = iterator.next();
                    String string = objectName.getKeyProperty("Type");
                    if (string == null || !Types.isValidWLSType(string)) {
                        if (!debug.isDebugEnabled()) continue;
                        debug.debug("Skipping Bean: no type " + objectName);
                        continue;
                    }
                    NotificationHandler notificationHandler = new NotificationHandler(objectName, this.defaultDomain);
                    if (!notificationHandler.registerThisObject()) {
                        if (!debug.isDebugEnabled()) continue;
                        debug.debug("Skipping Bean !registerThisObject" + objectName);
                        continue;
                    }
                    this.registerMBean(notificationHandler);
                }
                catch (Throwable throwable) {
                    debug.debug("Unable to register a pre-existing mean" + throwable);
                    ManagementLogger.logCouldNotRegisterMBeanForJSR77((Throwable)throwable);
                }
            }
        }
        catch (IOException iOException) {
            debug.debug("Failure to connect to domain runtime service", (Throwable)iOException);
        }
    }

    MBeanServer getJMOMBeanServer() {
        return this.server;
    }

    private void validate(ObjectName objectName) throws InvalidObjectNameException {
        JMOValidator jMOValidator = new JMOValidator(objectName);
        jMOValidator.validate();
    }

    private void registerMBean(NotificationHandler notificationHandler) {
        Map map = notificationHandler.getJ2EEObjectNameToImplMap();
        Set set = map.keySet();
        for (ObjectName objectName : set) {
            try {
                Object v = map.get(objectName);
                WLSModelMBeanContext wLSModelMBeanContext = new WLSModelMBeanContext(this.server, null, null);
                WLSModelMBean wLSModelMBean = new WLSModelMBean(v, wLSModelMBeanContext);
                if (debug.isDebugEnabled()) {
                    debug.debug("Registering:    " + objectName.toString());
                }
                this.server.registerMBean(wLSModelMBean, objectName);
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new AssertionError((Object)("Not a Compliant MBean" + notCompliantMBeanException));
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                throw new AssertionError((Object)("MBean Registration failed" + mBeanRegistrationException));
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (!debug.isDebugEnabled()) continue;
                debug.debug("Attempt to register an MBean again" + instanceAlreadyExistsException.toString());
                continue;
            }
            catch (OperationsException operationsException) {
                throw new AssertionError((Object)("Failure in creating MBean Adaptor" + operationsException));
            }
            this.wlsToJ2EEObjectNames.put(notificationHandler.getWLSObjectName(), set.toArray(new ObjectName[set.size()]));
        }
    }

    private void unregisterMBean(ObjectName objectName) {
        if (!this.wlsToJ2EEObjectNames.containsKey(objectName)) {
            return;
        }
        ObjectName[] objectNameArray = (ObjectName[])this.wlsToJ2EEObjectNames.remove(objectName);
        for (int i = 0; i < objectNameArray.length; ++i) {
            if (debug.isDebugEnabled()) {
                debug.debug("Un-Registering:    " + objectNameArray[i]);
            }
            try {
                this.server.unregisterMBean(objectNameArray[i]);
                continue;
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                throw new AssertionError((Object)("MBean Registration failed" + mBeanRegistrationException));
            }
            catch (OperationsException operationsException) {
                throw new AssertionError((Object)("Failure in creating MBean Adaptor" + operationsException));
            }
        }
    }

    public String[] getQueriedNames(ObjectName objectName) {
        Set<ObjectName> set = this.server.queryNames(objectName, null);
        return JMOService.toStringArray(set);
    }

    public String[] getQueriedNames(QueryExp queryExp) {
        Set<ObjectName> set = this.server.queryNames(null, queryExp);
        return JMOService.toStringArray(set);
    }

    public static String[] toStringArray(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        ObjectName objectName2 = null;
        for (ObjectName objectName2 : set) {
            hashSet.add(objectName2.getCanonicalName());
        }
        return hashSet.toArray(new String[0]);
    }

    static {
        try {
            RUNTIME_QUERY = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new Error(malformedObjectNameException);
        }
    }

    class MBeanServerListener
    implements NotificationListener {
        MBeanServerListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            try {
                this._handleNotification(notification, object);
            }
            catch (Throwable throwable) {
                ManagementLogger.logCouldNotRegisterMBeanForJSR77((Throwable)throwable);
            }
        }

        private void _handleNotification(Notification notification, Object object) {
            MBeanServerNotification mBeanServerNotification = null;
            ObjectName objectName = null;
            if (notification instanceof MBeanServerNotification) {
                mBeanServerNotification = (MBeanServerNotification)notification;
                objectName = mBeanServerNotification.getMBeanName();
                boolean bl = mBeanServerNotification.getType().equals("JMX.mbean.registered");
                if (bl) {
                    NotificationHandler notificationHandler = new NotificationHandler(objectName, JMOService.this.defaultDomain);
                    if (!notificationHandler.registerThisObject()) {
                        if (debug.isDebugEnabled()) {
                            debug.debug("Not Registering:    " + mBeanServerNotification.getMBeanName().getCanonicalName());
                        }
                        return;
                    }
                    JMOService.this.registerMBean(notificationHandler);
                } else {
                    JMOService.this.unregisterMBean(objectName);
                }
            }
        }
    }

    private static class SINGLETON {
        static JMOService service = new JMOService();

        private SINGLETON() {
        }
    }
}

