/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.internal;

import java.security.AccessController;
import javax.management.ObjectName;
import weblogic.management.j2ee.internal.InvalidObjectNameException;
import weblogic.management.j2ee.internal.JMOTypesHelper;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

final class JMOValidator {
    public static final String NAME = "name";
    public static final String TYPE = "j2eeType";
    public static final String WLSNAME = "Name";
    public static final String WLSTYPE = "Type";
    public static final String WLSLOCATION = "Location";
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String server = ManagementService.getRuntimeAccess(kernelId).getServer().getName();
    private final ObjectName objectName;
    private final String name;
    private final String type;
    private final String domain;
    private final StringBuffer objectNameString;

    JMOValidator(ObjectName objectName) {
        this.objectName = objectName;
        this.name = this.objectName.getKeyProperty(NAME);
        this.type = this.objectName.getKeyProperty(TYPE);
        this.domain = this.objectName.getDomain();
        this.objectNameString = new StringBuffer();
        this.objectNameString.append(this.domain + ":" + WLSNAME + "=" + this.name + ",");
    }

    String getName(ObjectName objectName) {
        return objectName.getKeyProperty(NAME);
    }

    String getType(ObjectName objectName) {
        return objectName.getKeyProperty(TYPE);
    }

    void validate() throws InvalidObjectNameException {
        if (this.name == null || this.type == null) {
            throw new InvalidObjectNameException("Not a valid J2EE Managed Object");
        }
        if (this.domain == null || this.domain.indexOf(63) > 1 || this.domain.indexOf(42) > 1 || this.domain.indexOf(59) > 1 || this.domain.indexOf(44) > 1 || this.domain.indexOf(61) > 1) {
            throw new InvalidObjectNameException("Not a valid J2EE Managed Object");
        }
        JMOTypesHelper.validateParents(this.objectName);
    }

    ObjectName getJ2EEObjectName() {
        return this.objectName;
    }
}

