/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.ObjectName;
import weblogic.management.j2ee.JVMMBean;
import weblogic.management.j2ee.internal.J2EEManagedObjectMBeanImpl;
import weblogic.management.j2ee.internal.MBeanServerConnectionProvider;

public final class JVMMBeanImpl
extends J2EEManagedObjectMBeanImpl
implements JVMMBean {
    private final ObjectName server;
    private String host = null;
    private static final String LA_DEFAULT = "127.0.0.1";

    public JVMMBeanImpl(String string, ObjectName objectName) {
        super(string);
        this.server = objectName;
    }

    public String getnode() {
        if (this.host != null) {
            return this.host;
        }
        String string = this.getListenAddress();
        try {
            this.host = string.equals("localhost") || string.equals("127.0.0.0") ? InetAddress.getLocalHost().getHostName() : InetAddress.getByName(string).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new Error(unknownHostException);
        }
        return this.host;
    }

    private String getListenAddress() {
        String string = null;
        try {
            string = (String)MBeanServerConnectionProvider.geRuntimeMBeanServerConnection().getAttribute(this.getServerON(), "ListenAddress");
        }
        catch (Throwable throwable) {
            throw new Error(throwable);
        }
        return string != null ? string : LA_DEFAULT;
    }

    private ObjectName getServerON() {
        String string = this.server.getDomain() + ":Name=" + this.server.getKeyProperty("Name") + "," + "Type=Server";
        try {
            return new ObjectName(string);
        }
        catch (Throwable throwable) {
            throw new Error(throwable);
        }
    }

    public String getjavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getjavaVersion() {
        return System.getProperty("java.version");
    }
}

