/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.UnknownHostException;
import java.security.AccessController;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerURL;
import weblogic.protocol.URLManager;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class MBeanServerConnectionProvider {
    private static MBeanServerConnection domainMBeanServerConnection = null;
    private static MBeanServerConnection editMBeanServerConnection = null;
    private static MBeanServerConnection runtimeMBeanServerConnection = null;
    private static final String JNDI = "/jndi/";
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public MBeanServerConnectionProvider() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    public static void initialize() {
        domainMBeanServerConnection = MBeanServerConnectionProvider.createMBeanServerConnection("weblogic.management.mbeanservers.domainruntime");
        editMBeanServerConnection = MBeanServerConnectionProvider.createMBeanServerConnection("weblogic.management.mbeanservers.edit");
        runtimeMBeanServerConnection = MBeanServerConnectionProvider.createMBeanServerConnection("weblogic.management.mbeanservers.runtime");
    }

    public static MBeanServerConnection getDomainMBeanServerConnection() {
        return domainMBeanServerConnection;
    }

    public static MBeanServerConnection getEditMBeanServerConnection() {
        return editMBeanServerConnection;
    }

    public static MBeanServerConnection geRuntimeMBeanServerConnection() {
        return runtimeMBeanServerConnection;
    }

    private static MBeanServerConnection createMBeanServerConnection(String string) {
        JMXServiceURL jMXServiceURL;
        Object object;
        Object object2;
        try {
            object2 = ManagementService.getRuntimeAccess(kernelId).getAdminServerName();
            object = URLManager.findAdministrationURL((String)object2);
            ServerURL serverURL = new ServerURL((String)object);
            jMXServiceURL = new JMXServiceURL(serverURL.getProtocol(), serverURL.getHost(), serverURL.getPort(), JNDI + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("Atempting to connect to the domain mbean server", malformedURLException);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        try {
            object2 = new Hashtable();
            ((Hashtable)object2).put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
            object = JMXConnectorFactory.connect(jMXServiceURL, object2);
            object.addConnectionNotificationListener(MBeanServerConnectionProvider.createListener(), null, null);
            return object.getMBeanServerConnection();
        }
        catch (IOException iOException) {
            throw new Error("Error while connecting to MBeanServer ", iOException);
        }
    }

    private static NotificationListener createListener() {
        return new NotificationListener(){

            public void handleNotification(Notification notification, Object object) {
            }
        };
    }
}

