/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.internal;

import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.j2ee.internal.AppClientModuleMBeanImpl;
import weblogic.management.j2ee.internal.ApplicationInfo;
import weblogic.management.j2ee.internal.EJBModuleMBeanImpl;
import weblogic.management.j2ee.internal.EntityBeanMBeanImpl;
import weblogic.management.j2ee.internal.InternalAppDataCacheService;
import weblogic.management.j2ee.internal.J2EEApplicationMBeanImpl;
import weblogic.management.j2ee.internal.J2EEDomainMBeanImpl;
import weblogic.management.j2ee.internal.J2EEServerMBeanImpl;
import weblogic.management.j2ee.internal.JCAConnectionFactoryMBeanImpl;
import weblogic.management.j2ee.internal.JCAManagedConnectionFactoryMBeanImpl;
import weblogic.management.j2ee.internal.JCAResourceMBeanImpl;
import weblogic.management.j2ee.internal.JDBCDataSourceMBeanImpl;
import weblogic.management.j2ee.internal.JDBCDriverMBeanImpl;
import weblogic.management.j2ee.internal.JDBCResourceMBeanImpl;
import weblogic.management.j2ee.internal.JMOTypesHelper;
import weblogic.management.j2ee.internal.JMSResourceMBeanImpl;
import weblogic.management.j2ee.internal.JNDIResourceMBeanImpl;
import weblogic.management.j2ee.internal.JTAResourceMBeanImpl;
import weblogic.management.j2ee.internal.JVMMBeanImpl;
import weblogic.management.j2ee.internal.JavaMailResourceMBeanImpl;
import weblogic.management.j2ee.internal.MBeanServerConnectionProvider;
import weblogic.management.j2ee.internal.MessageDrivenBeanMBeanImpl;
import weblogic.management.j2ee.internal.RMI_IIOPResourceMBeanImpl;
import weblogic.management.j2ee.internal.ResourceAdapterMBeanImpl;
import weblogic.management.j2ee.internal.ResourceAdapterModuleMBeanImpl;
import weblogic.management.j2ee.internal.ServletMBeanImpl;
import weblogic.management.j2ee.internal.StatefulSessionBeanMBeanImpl;
import weblogic.management.j2ee.internal.StatelessSessionBeanMBeanImpl;
import weblogic.management.j2ee.internal.Types;
import weblogic.management.j2ee.internal.URLResourceMBeanImpl;
import weblogic.management.j2ee.internal.WebModuleMBeanImpl;

final class NotificationHandler {
    private static DebugLogger debug = DebugLogger.getDebugLogger((String)"DebugJ2EEManagement");
    private final Map j2eeobjectNameToImpl = new HashMap(3);
    private final String j2eeType;
    private final String wlsType;
    private final ObjectName wlsObjectName;
    private final String domain;
    private boolean registerThisObject = true;

    public NotificationHandler(ObjectName objectName, String string) {
        this.wlsObjectName = objectName;
        this.wlsType = this.wlsObjectName.getKeyProperty("Type");
        this.j2eeType = Types.getJ2EETypeForWLSType(this.wlsType);
        this.domain = string;
        this.processWLSObjectName();
    }

    private ObjectName getJ2EEObjectName() {
        String string = this.wlsObjectName.getKeyProperty("Name");
        StringBuffer stringBuffer = new StringBuffer(this.domain + ":" + "name" + "=" + string + ",");
        StringBuffer stringBuffer2 = new StringBuffer(this.domain + ":" + "Name" + "=" + string + ",");
        String[] stringArray = JMOTypesHelper.getParentsForType(this.j2eeType);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = Types.getWLSTypeForJ2EEType(string2);
                String string4 = this.wlsObjectName.getKeyProperty(string3);
                stringBuffer2.append(string3 + "=" + string4 + ",");
                stringBuffer.append(string2 + "=" + string4 + ",");
            }
        }
        stringBuffer.append("j2eeType=" + this.j2eeType);
        stringBuffer2.append("Type=" + this.wlsType);
        ObjectName objectName = this.getJ2EEObjectName(stringBuffer);
        return objectName;
    }

    private ObjectName getJ2EEObjectName(StringBuffer stringBuffer) {
        try {
            return new ObjectName(stringBuffer.toString());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new AssertionError((Object)("Malformed ObjectName" + malformedObjectNameException));
        }
    }

    private ObjectName getJ2EEObjectNameForModule(boolean bl) {
        String string = this.wlsObjectName.getKeyProperty("Name");
        StringBuffer stringBuffer = new StringBuffer(this.domain + ":" + "name" + "=" + string + ",");
        String string2 = bl ? this.wlsObjectName.getKeyProperty("ApplicationRuntime") : null;
        stringBuffer.append("J2EEApplication=" + string2 + ",");
        stringBuffer.append("J2EEServer=" + this.wlsObjectName.getKeyProperty("ServerRuntime") + ",");
        stringBuffer.append("j2eeType=" + this.j2eeType);
        return this.getJ2EEObjectName(stringBuffer);
    }

    private void processWLSObjectName() {
        if (debug.isDebugEnabled()) {
            debug.debug("processWLSObjectName: type = " + JMOTypesHelper.getTypeIndex(this.j2eeType));
        }
        switch (JMOTypesHelper.getTypeIndex(this.j2eeType)) {
            case 0: {
                this.processJ2EEDomainBeanObject();
                break;
            }
            case 1: {
                this.processJ2EEServerBeanObject();
                break;
            }
            case 2: {
                if (!this.validApp()) {
                    return;
                }
                this.processJ2EEApplicationBeanObject();
                break;
            }
            case 3: {
                this.processJ2EEAppClientModuleBeanObject();
                break;
            }
            case 4: {
                this.processJ2EEEJBModuleBeanObject();
                break;
            }
            case 5: {
                this.processJ2EEWebModuleBeanObject();
                break;
            }
            case 6: {
                this.processJ2EEResourceAdaptorModuleBeanObject();
                break;
            }
            case 7: {
                this.processJ2EEEntityBeanBeanObject();
                break;
            }
            case 10: {
                this.processJ2EEMessageDrivenBeanBeanObject();
            }
            case 9: {
                this.processJ2EEStatelessBeanBeanObject();
                break;
            }
            case 8: {
                this.processJ2EEStatefulBeanBeanObject();
                break;
            }
            case 11: {
                this.processJ2EEServletBeanObject();
                break;
            }
            case 13: {
                this.processJ2EEJCAConFactoryBeanObject();
                break;
            }
            case 15: {
                this.processJ2EEJDBCDataSourceBeanObject();
                break;
            }
            case 16: {
                this.registerThisObject = false;
                return;
            }
            case 14: {
                this.processJ2EEJDBCResourceBeanObject();
                break;
            }
            case 17: {
                this.processJ2EEJMSResourceBeanObject();
                break;
            }
            case 12: {
                this.processJ2EEJavaMailResourceBeanObject();
                break;
            }
            case 19: {
                this.processJ2EEURLResourceBeanObject();
                break;
            }
            case 18: {
                this.processJ2EEJTAResourceBeanObject();
                break;
            }
            case 20: {
                this.processJ2EEJVMObject();
                break;
            }
            default: {
                throw new AssertionError((Object)" Invalid type detected");
            }
        }
    }

    private void setValues(ObjectName objectName, Object object) {
        if (debug.isDebugEnabled()) {
            debug.debug("setValues: objectName = " + objectName + " value = " + object);
        }
        this.j2eeobjectNameToImpl.put(objectName, object);
    }

    private void processJ2EEDomainBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new J2EEDomainMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEServerBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new J2EEServerMBeanImpl(objectName.getCanonicalName()));
        ObjectName objectName2 = this.makeObjectNameForType("JNDIResource");
        this.setValues(objectName2, new JNDIResourceMBeanImpl(objectName2.getCanonicalName()));
        ObjectName objectName3 = this.makeObjectNameForType("RMI_IIOPResource");
        this.setValues(objectName3, new RMI_IIOPResourceMBeanImpl(objectName3.getCanonicalName()));
    }

    private void processJ2EEApplicationBeanObject() {
        ApplicationInfo applicationInfo = new ApplicationInfo(this.wlsObjectName, 1);
        if (!applicationInfo.isEar()) {
            this.registerThisObject = false;
            return;
        }
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new J2EEApplicationMBeanImpl(objectName.getCanonicalName(), this.getJ2EEServer(), applicationInfo));
    }

    private void processJ2EEAppClientModuleBeanObject() {
        ApplicationInfo applicationInfo = new ApplicationInfo(this.wlsObjectName, 5);
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new AppClientModuleMBeanImpl(objectName.getCanonicalName(), this.getJ2EEServer(), this.getJ2EEJVM(), applicationInfo));
    }

    private void processJ2EEEJBModuleBeanObject() {
        ApplicationInfo applicationInfo = new ApplicationInfo(this.wlsObjectName, 3);
        ObjectName objectName = this.getJ2EEObjectNameForModule(applicationInfo.isParentEar());
        this.setValues(objectName, new EJBModuleMBeanImpl(objectName.getCanonicalName(), this.getJ2EEServer(), this.getJ2EEJVM(), applicationInfo));
    }

    private void processJ2EEWebModuleBeanObject() {
        ApplicationInfo applicationInfo = new ApplicationInfo(this.wlsObjectName, 2);
        ObjectName objectName = this.getJ2EEObjectNameForModule(applicationInfo.isParentEar());
        this.setValues(objectName, new WebModuleMBeanImpl(objectName.getCanonicalName(), this.getJ2EEServer(), this.getJ2EEJVM(), applicationInfo));
    }

    private void processJ2EEResourceAdaptorModuleBeanObject() {
        ApplicationInfo applicationInfo = new ApplicationInfo(this.wlsObjectName, 4);
        ObjectName objectName = this.getJ2EEObjectNameForModule(applicationInfo.isParentEar());
        this.setValues(objectName, new ResourceAdapterModuleMBeanImpl(objectName.getCanonicalName(), this.getJ2EEServer(), this.getJ2EEJVM(), applicationInfo));
        ObjectName objectName2 = this.getResourceAdapterObjectName(objectName);
        ObjectName objectName3 = this.getJCAResourceObjectName(objectName);
        this.setValues(objectName2, new ResourceAdapterMBeanImpl(objectName2.getCanonicalName(), objectName3.getCanonicalName()));
        this.setValues(objectName3, new JCAResourceMBeanImpl(objectName3.getCanonicalName(), this.wlsObjectName));
    }

    private void processJ2EEEntityBeanBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new EntityBeanMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEMessageDrivenBeanBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new MessageDrivenBeanMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEStatelessBeanBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new StatelessSessionBeanMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEStatefulBeanBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new StatefulSessionBeanMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEServletBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new ServletMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEJCAConFactoryBeanObject() {
        String string = this.wlsObjectName.getKeyProperty("ConnectorComponentRuntime");
        ObjectName objectName = this.getJ2EEConnectionFactoryObjectName(string);
        ObjectName objectName2 = this.getJCAManagedConnectionFactoryObjectName(objectName);
        this.setValues(objectName, new JCAConnectionFactoryMBeanImpl(objectName.getCanonicalName(), objectName2.getCanonicalName()));
        this.setValues(objectName2, new JCAManagedConnectionFactoryMBeanImpl(objectName2.getCanonicalName()));
    }

    private void processJ2EEJDBCDataSourceBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        ObjectName objectName2 = this.getObjectNameWithServerAsParent("JDBCDriver");
        this.setValues(objectName, new JDBCDataSourceMBeanImpl(objectName.getCanonicalName(), objectName2.getCanonicalName()));
        this.setValues(objectName2, new JDBCDriverMBeanImpl(objectName2.getCanonicalName()));
    }

    private void processJ2EEJDBCDriverBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new JDBCDriverMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEJDBCResourceBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new JDBCResourceMBeanImpl(objectName.getCanonicalName(), this.wlsObjectName.getKeyProperty("ServerRuntime")));
    }

    private void processJ2EEJMSResourceBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new JMSResourceMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEJavaMailResourceBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new JavaMailResourceMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEJNDIResourceBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new JNDIResourceMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EERMI_IIOP_ResourceBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new RMI_IIOPResourceMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEURLResourceBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new URLResourceMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEJTAResourceBeanObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new JTAResourceMBeanImpl(objectName.getCanonicalName()));
    }

    private void processJ2EEJVMObject() {
        ObjectName objectName = this.getJ2EEObjectName();
        this.setValues(objectName, new JVMMBeanImpl(objectName.getCanonicalName(), this.wlsObjectName));
    }

    private String getJ2EEServer() {
        String string = this.wlsObjectName.getKeyProperty("ServerRuntime");
        return new StringBuffer(this.domain + ":" + "name" + "=" + string + "," + "j2eeType" + "=" + "J2EEServer").toString();
    }

    private String getJ2EEJVM() {
        String string = this.wlsObjectName.getKeyProperty("ServerRuntime");
        return new StringBuffer(this.domain + ":" + "name" + "=" + string + "," + "j2eeType" + "=" + "JVM" + "," + "J2EEServer" + "=" + string).toString();
    }

    private ObjectName getResourceAdapterObjectName(ObjectName objectName) {
        String string = objectName.getKeyProperty("name");
        StringBuffer stringBuffer = new StringBuffer(this.domain + ":" + "J2EEServer" + "=" + objectName.getKeyProperty("J2EEServer") + "," + "J2EEApplication" + "=" + objectName.getKeyProperty("J2EEApplication") + "," + "name=" + string + "," + "ResourceAdapterModule" + "=" + string + "," + "j2eeType" + "=" + "ResourceAdapter");
        return this.getJ2EEObjectName(stringBuffer);
    }

    private ObjectName getJCAResourceObjectName(ObjectName objectName) {
        String string = objectName.getKeyProperty("name");
        StringBuffer stringBuffer = new StringBuffer(this.domain + ":" + "J2EEServer" + "=" + objectName.getKeyProperty("J2EEServer") + "," + "ResourceAdapter" + "=" + string + "," + "name=" + string + "," + "j2eeType" + "=" + "JCAResource");
        return this.getJ2EEObjectName(stringBuffer);
    }

    private ObjectName getJCAManagedConnectionFactoryObjectName(ObjectName objectName) {
        StringBuffer stringBuffer = new StringBuffer(this.domain + ":" + "J2EEServer" + "=" + objectName.getKeyProperty("J2EEServer") + "," + "name=" + objectName.getKeyProperty("name") + "," + "j2eeType" + "=" + "JCAManagedConnectionFactory");
        return this.getJ2EEObjectName(stringBuffer);
    }

    private ObjectName getJ2EEConnectionFactoryObjectName(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.domain + ":" + "J2EEServer" + "=" + this.wlsObjectName.getKeyProperty("ServerRuntime") + "," + "JCAResource" + "=" + string + "," + "ResourceAdapterModule" + "=" + string + "," + "name=" + this.wlsObjectName.getKeyProperty("Name") + "," + "j2eeType" + "=" + "JCAConnectionFactory");
        return this.getJ2EEObjectName(stringBuffer);
    }

    private ObjectName getObjectNameWithServerAsParent(String string) {
        String string2 = this.wlsObjectName.getKeyProperty("Name");
        String string3 = this.wlsObjectName.getKeyProperty("ServerRuntime");
        StringBuffer stringBuffer = new StringBuffer(this.domain + ":" + "name=" + string2 + "," + "J2EEServer" + "=" + string3 + "," + "j2eeType" + "=" + string);
        return this.getJ2EEObjectName(stringBuffer);
    }

    private ObjectName makeObjectNameForType(String string) {
        String string2 = this.wlsObjectName.getKeyProperty("Name");
        StringBuffer stringBuffer = new StringBuffer(this.domain + ":" + "name=" + string2 + "," + "J2EEServer" + "=" + string2 + "," + "j2eeType" + "=" + string);
        return this.getJ2EEObjectName(stringBuffer);
    }

    boolean registerThisObject() {
        return this.registerThisObject;
    }

    Map getJ2EEObjectNameToImplMap() {
        return this.j2eeobjectNameToImpl;
    }

    ObjectName getWLSObjectName() {
        return this.wlsObjectName;
    }

    private boolean validApp() {
        boolean bl = false;
        try {
            ObjectInstance objectInstance = null;
            String string = (String)MBeanServerConnectionProvider.getDomainMBeanServerConnection().getAttribute(this.wlsObjectName, "ApplicationName");
            String string2 = this.wlsObjectName.getDomain() + ":Name=" + string + ",Type=AppDeployment";
            try {
                MBeanServerConnection mBeanServerConnection = MBeanServerConnectionProvider.getEditMBeanServerConnection();
                objectInstance = mBeanServerConnection.getObjectInstance(new ObjectName(string2));
                bl = true;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (InternalAppDataCacheService.isInternalApp(string)) {
                    return true;
                }
                MBeanServerConnection mBeanServerConnection = MBeanServerConnectionProvider.geRuntimeMBeanServerConnection();
                objectInstance = mBeanServerConnection.getObjectInstance(new ObjectName(string2));
                bl = true;
            }
        }
        catch (Throwable throwable) {
            if (debug.isDebugEnabled()) {
                debug.debug("validApp got exception ", throwable);
            }
            this.registerThisObject = false;
            return bl;
        }
        return bl;
    }
}

