/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.j2ee.statistics;

import java.io.Serializable;
import java.util.Hashtable;
import javax.management.j2ee.statistics.Statistic;
import weblogic.management.j2ee.statistics.StatException;
import weblogic.management.j2ee.statistics.TimeStat;

public abstract class StatisticImpl
implements Statistic,
Serializable {
    private String description;
    private String name;
    private String unit = "MILLISECOND";
    private long startTime;
    private long lastSampleTime;
    private static Hashtable attributeToTimeStatMap = new Hashtable();
    public static final String UNIT_HOUR = "HOUR";
    public static final String UNIT_MINUTE = "MINUTE";
    public static final String UNIT_SECOND = "SECOND";
    public static final String UNIT_MILLISECOND = "MILLISECOND";
    public static final String UNIT_MICROSECOND = "MICROSECOND";
    public static final String UNIT_NANOSECOND = "NANOSECOND";

    public StatisticImpl(String string, String string2, String string3) throws StatException {
        this.initialize(string, string2, string3);
    }

    public StatisticImpl(String string, String string2, String string3, String string4) throws StatException {
        this.setUnit(string3);
        this.initialize(string, string2, string4);
    }

    private void initialize(String string, String string2, String string3) throws StatException {
        TimeStat timeStat = null;
        this.description = string;
        this.name = string2;
        Object var5_5 = null;
        String string4 = string3 + "-" + string2;
        timeStat = (TimeStat)attributeToTimeStatMap.get(string4);
        long l = System.currentTimeMillis();
        if (timeStat == null) {
            timeStat = new TimeStat(l, l);
            attributeToTimeStatMap.put(string4, timeStat);
        } else {
            timeStat.setLastSampleTime(l);
        }
        this.lastSampleTime = timeStat.getLastSampleTime();
        this.startTime = timeStat.getStartTime();
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    private void setUnit(String string) throws StatException {
        if (!(string != null && string.length() != 0 && string.equals(UNIT_HOUR) && string.equals(UNIT_MINUTE) && string.equals(UNIT_SECOND) && string.equals(UNIT_MILLISECOND) && string.equals(UNIT_MICROSECOND) && string.equals(UNIT_NANOSECOND))) {
            throw new StatException(" An invalid unit has been specified. unit = <" + string + ">.");
        }
        this.unit = this.unit;
    }
}

