/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.logging;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.List;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.snmp.agent.SNMPTrapException;
import weblogic.diagnostics.snmp.agent.SNMPTrapSender;
import weblogic.diagnostics.snmp.agent.SNMPTrapUtil;
import weblogic.diagnostics.snmp.server.ALSBTrapUtil;
import weblogic.i18n.logging.LoggingTextFormatter;
import weblogic.jndi.Environment;
import weblogic.logging.JDKLoggerFactory;
import weblogic.logging.LogEntry;
import weblogic.logging.LogMgmtLogger;
import weblogic.logging.WLLevel;
import weblogic.logging.WLLogRecord;
import weblogic.management.configuration.LogMBean;
import weblogic.management.logging.DomainLogHandler;
import weblogic.management.logging.DomainLogHandlerException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DomainLogHandlerImpl
implements DomainLogHandler {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugDomainLogHandler");
    private static DomainLogHandler singleton = null;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
    private static LoggingTextFormatter loggingTextFmt = LoggingTextFormatter.getInstance();
    private static boolean loggedSNMPMessage = false;
    private Logger domainLogger;
    private LogMBean log = null;

    public static synchronized DomainLogHandler getInstance() throws DomainLogHandlerException {
        if (!runtimeAccess.isAdminServer()) {
            throw new DomainLogHandlerException(loggingTextFmt.getDomainLoggerDoesNotExistMsg());
        }
        if (singleton == null) {
            try {
                singleton = new DomainLogHandlerImpl();
            }
            catch (NamingException namingException) {
                throw new DomainLogHandlerException(loggingTextFmt.getDomainLoggerDoesNotExistMsg(), namingException);
            }
        }
        return singleton;
    }

    private DomainLogHandlerImpl() throws NamingException {
        Environment environment = new Environment();
        environment.setReplicateBindings(false);
        environment.setCreateIntermediateContexts(true);
        Context context = environment.getInitialContext();
        context.bind("weblogic.logging.DomainLogHandler", (Object)this);
        this.log = runtimeAccess.getDomain().getLog();
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Found Domain's LogConfig " + this.log.getObjectName());
        }
        this.initializeDomainLogger();
    }

    public Logger getDomainLogger() {
        return this.domainLogger;
    }

    private void initializeDomainLogger() {
        JDKLoggerFactory jDKLoggerFactory = JDKLoggerFactory.getJDKLoggerFactory(this.log);
        try {
            this.domainLogger = jDKLoggerFactory.createAndInitializeDomainLogger(this.log);
        }
        catch (IOException iOException) {
            LogMgmtLogger.logCannotOpenDomainLogfile((String)this.log.computeLogFilePath(), (Throwable)iOException);
            this.domainLogger = null;
        }
    }

    @Override
    public void publishLogEntries(LogEntry[] logEntryArray) {
        if (logEntryArray == null) {
            return;
        }
        WLLogRecord wLLogRecord = null;
        for (int i = 0; i < logEntryArray.length; ++i) {
            LogEntry logEntry = logEntryArray[i];
            wLLogRecord = new WLLogRecord(WLLevel.getLevel((int)logEntry.getSeverity()), logEntry.getLogMessage());
            wLLogRecord.setId(logEntry.getId());
            wLLogRecord.setLoggerName(logEntry.getSubsystem());
            wLLogRecord.setMillis(logEntry.getTimestamp());
            wLLogRecord.setParameters(new Object[0]);
            wLLogRecord.setThrowableWrapper(logEntry.getThrowableWrapper());
            wLLogRecord.setMachineName(logEntry.getMachineName());
            wLLogRecord.setServerName(logEntry.getServerName());
            wLLogRecord.setThreadName(logEntry.getThreadName());
            wLLogRecord.setUserId(logEntry.getUserId());
            wLLogRecord.setTransactionId(logEntry.getTransactionId());
            wLLogRecord.setDiagnosticContextId(logEntry.getDiagnosticContextId());
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Logging message to domain log " + wLLogRecord.getLogMessage());
            }
            this.domainLogger.log((LogRecord)((Object)wLLogRecord));
        }
    }

    @Override
    public void sendTrap(String string, List<Object[]> list) throws RemoteException {
        try {
            SNMPTrapSender sNMPTrapSender = SNMPTrapUtil.getInstance().getSNMPTrapSender();
            if (sNMPTrapSender != null) {
                sNMPTrapSender.sendTrap(string, list);
            }
        }
        catch (SNMPTrapException sNMPTrapException) {
            throw new RemoteException(sNMPTrapException.getMessage());
        }
    }

    @Override
    public void sendALAlertTrap(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) throws RemoteException {
        try {
            ALSBTrapUtil.sendALSBAlert(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12);
        }
        catch (Exception exception) {
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Error sending trap to admin server", (Throwable)exception);
            }
            throw new RemoteException(exception.getMessage());
        }
    }

    @Override
    public void ping() {
    }
}

