/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.logging;

import java.security.AccessController;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanException;
import javax.management.Notification;
import weblogic.logging.LogEntry;
import weblogic.management.ManagementException;
import weblogic.management.jmx.modelmbean.NotificationGenerator;
import weblogic.management.logging.WebLogicLogNotification;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.LogBroadcasterRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TxHelper;
import weblogic.utils.collections.CopyOnWriteArrayList;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class LogBroadcaster
extends RuntimeMBeanDelegate
implements LogBroadcasterRuntimeMBean {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
    static final String BASE_TYPE = "weblogic.log.";
    private static final long serialVersionUID = 7795992271907801150L;
    private static final boolean DEBUG = false;
    private long messagesLogged;
    private List generators = new CopyOnWriteArrayList();
    private WorkManager workManager = WorkManagerFactory.getInstance().findOrCreate("weblogic.logging.LogBroadcaster", 1, -1);

    public static LogBroadcaster getLogBroadcaster() throws ManagementException {
        return SingletonFactory.getSingleton();
    }

    private LogBroadcaster() throws ManagementException {
        super("TheLogBroadcaster");
    }

    void addNotificationGenerator(NotificationGenerator notificationGenerator) {
        this.generators.add(notificationGenerator);
    }

    public long getMessagesLogged() {
        return this.messagesLogged;
    }

    public void translateLogEntry(final LogEntry logEntry) {
        String string;
        if (logEntry.getSeverity() >= 128) {
            return;
        }
        if (!this.isTranslationNeeded()) {
            return;
        }
        String string2 = logEntry.getUserId();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = TxHelper.getTransactionId()) == null) {
            string = "";
        }
        final String string3 = BASE_TYPE + logEntry.getSubsystem() + "." + logEntry.getId();
        ++this.messagesLogged;
        final Iterator iterator = this.generators.iterator();
        this.workManager.schedule(new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    NotificationGenerator notificationGenerator = (NotificationGenerator)iterator.next();
                    if (!notificationGenerator.isSubscribed()) continue;
                    WebLogicLogNotification webLogicLogNotification = new WebLogicLogNotification(string3, LogBroadcaster.this.messagesLogged, notificationGenerator.getObjectName(), logEntry);
                    try {
                        notificationGenerator.sendNotification((Notification)webLogicLogNotification);
                        notificationGenerator.incrementSequenceNumber();
                    }
                    catch (MBeanException mBeanException) {}
                }
            }
        });
    }

    private boolean isTranslationNeeded() {
        boolean bl = false;
        for (NotificationGenerator notificationGenerator : this.generators) {
            if (!notificationGenerator.isSubscribed()) continue;
            bl = true;
        }
        return bl;
    }

    private static final class SingletonFactory {
        private static LogBroadcaster singleton = null;

        private SingletonFactory() {
        }

        private static LogBroadcaster getSingleton() throws ManagementException {
            if (singleton == null) {
                singleton = new LogBroadcaster();
            }
            return singleton;
        }
    }
}

