/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.logging;

import com.bea.logging.RotatingFileOutputStream;
import java.io.IOException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.LogFileMBean;
import weblogic.management.runtime.LogRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;

public final class LogRuntime
extends RuntimeMBeanDelegate
implements LogRuntimeMBean {
    private LogFileMBean logfileMBean;

    public LogRuntime(LogFileMBean logFileMBean, RuntimeMBean runtimeMBean) throws ManagementException {
        super(logFileMBean.getName(), runtimeMBean);
        this.logfileMBean = logFileMBean;
    }

    public void forceLogRotation() throws ManagementException {
        RotatingFileOutputStream rotatingFileOutputStream = (RotatingFileOutputStream)this.logfileMBean.getOutputStream();
        if (rotatingFileOutputStream != null) {
            try {
                rotatingFileOutputStream.forceRotation();
            }
            catch (IOException iOException) {
                throw new ManagementException(iOException.toString());
            }
        }
    }

    public void ensureLogOpened() throws ManagementException {
        RotatingFileOutputStream rotatingFileOutputStream = (RotatingFileOutputStream)this.logfileMBean.getOutputStream();
        if (rotatingFileOutputStream != null && !rotatingFileOutputStream.isStreamOpened()) {
            try {
                rotatingFileOutputStream.open();
            }
            catch (IOException iOException) {
                throw new ManagementException(iOException.toString());
            }
        }
    }

    public void close() throws ManagementException {
        RotatingFileOutputStream rotatingFileOutputStream = (RotatingFileOutputStream)this.logfileMBean.getOutputStream();
        if (rotatingFileOutputStream != null) {
            try {
                rotatingFileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new ManagementException(iOException.toString());
            }
        }
    }
}

