/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.StagingDirectory;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.ApplicationsDirPoller;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.management.security.RealmMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;

public class AppDeployment
extends ConfigurationMBeanCustomizer {
    private static final boolean debug = false;
    private static final String APP_DIR = "app";
    private static final String DEPLOYMENTS_DIR = "config/deployments";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private transient String appName = null;
    private transient String versionId = null;
    private transient StagingDirectory sd = null;
    private transient DeploymentPlanBean plan = null;
    private String installDir = null;
    private String planPath = null;
    private String planDir = null;
    private String sourcePath = null;
    private String configPath = null;
    private String stagingMode = null;

    public AppDeployment(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    private String getDeploymentsDir() {
        if (this.configPath == null) {
            this.configPath = this.resolveToBase(DEPLOYMENTS_DIR, null);
        }
        return this.configPath;
    }

    private String resolveToBase(String string, String string2) {
        File file;
        string = FileUtils.normalize((String)string);
        string2 = FileUtils.normalize((String)string2);
        String string3 = string;
        if (string != null && !FileUtils.isAbsolute((File)(file = new File(string)))) {
            string3 = string2 == null ? new File(DomainDir.getRootDir(), string).getAbsolutePath() : new File(string2, string).getAbsolutePath();
        }
        return string3;
    }

    public String getInstalldir() {
        return this.installDir;
    }

    public void setInstalldir(String string) {
        String string2 = string;
        if (AppDeployment.verifyIfPathIsInRootDir(string)) {
            string2 = AppDeployment.makePathRelativeToRootDir(string);
        }
        this.installDir = string2;
    }

    public String getPlanPath() {
        return this.planPath;
    }

    public void setPlanPath(String string) {
        String string2 = string;
        String string3 = this.getAbsolutePlanDir();
        if (string3 != null) {
            File file = new File(string3);
            if (AppDeployment.verifyIfPathIsIn(string, file)) {
                string2 = AppDeployment.makePathRelativeTo(string, file);
            }
        } else {
            File file = new File(DomainDir.getRootDir());
            if (AppDeployment.verifyIfPathIsIn(string, file)) {
                string2 = AppDeployment.makePathRelativeTo(string, file);
            }
        }
        this.planPath = string2;
    }

    public String getPlanDir() {
        return this.planDir;
    }

    public void setPlanDir(String string) {
        String string2 = string;
        String string3 = this.getAbsoluteInstallDir();
        if (string2 != null) {
            if (string3 != null && new File(string3).exists()) {
                File file = new File(string3);
                if (AppDeployment.verifyIfPathIsIn(string, file)) {
                    string2 = AppDeployment.makePathRelativeTo(string, file);
                }
            } else {
                File file = new File(DomainDir.getRootDir());
                if (AppDeployment.verifyIfPathIsIn(string, file)) {
                    string2 = AppDeployment.makePathRelativeTo(string, file);
                }
            }
        }
        this.planDir = string2;
        if (this.planPath != null && this.planDir != null && FileUtils.isAbsolute((File)new File(this.planPath))) {
            this.setPlanPath(this.planPath);
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String string) {
        String string2 = string;
        String string3 = this.getAbsoluteAppDir();
        if (string3 != null && new File(string3).exists()) {
            File file = new File(string3);
            if (AppDeployment.verifyIfPathIsIn(string, file)) {
                string2 = AppDeployment.makePathRelativeTo(string, file);
            }
        } else if (AppDeployment.verifyIfPathIsInRootDir(string)) {
            string2 = AppDeployment.makePathRelativeToRootDir(string);
        }
        this.sourcePath = string2;
    }

    public String getAbsoluteInstallDir() {
        return this.resolveToBase(this.installDir, null);
    }

    public String getAbsolutePlanPath() {
        return this.resolveToBase(this.planPath, this.getAbsolutePlanDir());
    }

    public String getAbsolutePlanDir() {
        return this.resolveToBase(this.planDir, this.getAbsoluteInstallDir());
    }

    private String getAbsoluteAppDir() {
        String string = this.getAbsoluteInstallDir();
        if (string != null) {
            return this.resolveToBase(APP_DIR, string);
        }
        return null;
    }

    public String getAbsoluteSourcePath() {
        return this.resolveToBase(this.sourcePath, this.getAbsoluteAppDir());
    }

    public String getApplicationIdentifier() {
        return this.getMbean().getName();
    }

    public String getApplicationName() {
        if (this.appName == null) {
            this.appName = ApplicationVersionUtils.getApplicationName(this.getApplicationIdentifier());
        }
        return this.appName;
    }

    public String getVersionIdentifier() {
        if (this.versionId == null) {
            this.versionId = ApplicationVersionUtils.getVersionId(this.getApplicationIdentifier());
        }
        return this.versionId;
    }

    public void setStagingMode(String string) throws ManagementException {
        if (this.stagingMode != null && !this.stagingMode.equals(string)) {
            Loggable loggable = DeployerRuntimeLogger.logRejectStagingChangeLoggable((String)this.getApplicationName());
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        this.stagingMode = string;
    }

    public String getStagingMode() {
        return this.stagingMode;
    }

    public boolean isAutoDeployedApp() {
        return ApplicationsDirPoller.isInAppsDir(new File(DomainDir.getAppPollerDir()), this.getAbsoluteSourcePath());
    }

    public ApplicationMBean getAppMBean() {
        DomainMBean domainMBean = (DomainMBean)this.getMbean().getParent();
        if (domainMBean == null) {
            return null;
        }
        String string = this.getMbean().getName();
        ApplicationMBean applicationMBean = domainMBean.lookupApplication(string);
        return applicationMBean;
    }

    public static String getInitialSecurityDDModel(AppDeploymentMBean appDeploymentMBean) {
        RealmMBean realmMBean;
        String string = "DDOnly";
        DomainMBean domainMBean = (DomainMBean)appDeploymentMBean.getParent();
        if (domainMBean != null && (realmMBean = domainMBean.getSecurityConfiguration().getDefaultRealm()) != null) {
            string = realmMBean.getSecurityDDModel();
        }
        return string;
    }

    private StagingDirectory getStagingDirectory() throws IOException {
        if (this.sd == null) {
            this.sd = new StagingDirectory(this.getAbsolutePlanPath(), new File(this.getAbsoluteSourcePath()).getName(), this.getRootStagingDir());
        }
        return this.sd;
    }

    public String getLocalInstallDir() {
        this.assertOnServer();
        String string = this.getAbsoluteInstallDir();
        if (this.isStagedOnThisServer()) {
            try {
                string = this.getStagingDirectory().getRoot();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public String getLocalPlanPath() {
        this.assertOnServer();
        String string = this.getAbsolutePlanPath();
        if (string != null && this.isStagedOnThisServer()) {
            try {
                string = this.getStagingDirectory().getPlan();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    public String getLocalPlanDir() throws IOException {
        this.assertOnServer();
        String string = this.getAbsolutePlanDir();
        if (string != null && this.isStagedOnThisServer()) {
            string = this.getStagingDirectory().getPlanDir();
        }
        return string;
    }

    public String getLocalSourcePath() {
        this.assertOnServer();
        String string = this.getAbsoluteSourcePath();
        if (string != null && this.isStagedOnThisServer()) {
            try {
                string = this.getStagingDirectory().getSource();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
        }
        return string;
    }

    private void assertOnServer() {
        if (ManagementService.getPropertyService(kernelId) == null) {
            throw new IllegalStateException();
        }
    }

    private boolean isStaged() {
        String string = this.getStagingMode(ManagementService.getPropertyService(kernelId).getServerName());
        return !"nostage".equals(string);
    }

    private static String makePathRelativeToRootDir(String string) {
        return AppDeployment.makePathRelativeTo(string, new File(DomainDir.getRootDir()));
    }

    private static String makePathRelativeTo(String string, File file) {
        if (!file.exists()) {
            return string;
        }
        if (string == null) {
            return string;
        }
        try {
            String string2 = file.getCanonicalPath();
            String string3 = new File(string).getCanonicalPath();
            if (!string3.startsWith(string2)) {
                return string;
            }
            if (string2.length() == string3.length()) {
                return ".";
            }
            String string4 = string3.substring(string2.length() + 1);
            File file2 = new File(file, string4);
            if (!file2.exists()) {
                return string;
            }
            return string4;
        }
        catch (IOException iOException) {
            return string;
        }
    }

    private static boolean verifyIfPathIsInRootDir(String string) {
        return AppDeployment.verifyIfPathIsIn(string, new File(DomainDir.getRootDir()));
    }

    private static boolean verifyIfPathIsIn(String string, File file) {
        if (!file.exists()) {
            return false;
        }
        if (string == null) {
            return false;
        }
        File file2 = new File(string);
        if (!FileUtils.isAbsolute((File)file2)) {
            return false;
        }
        try {
            File file3;
            File file4 = file.getCanonicalFile();
            File file5 = file2;
            while ((file3 = file5.getParentFile()) != null) {
                if ((file3 = file3.getCanonicalFile()).equals(file4)) {
                    return true;
                }
                file5 = file5.getParentFile();
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String getRootStagingDir() {
        this.assertOnServer();
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getStagingDirectoryName();
        File file = new File(string, this.getApplicationName());
        if (this.getVersionIdentifier() != null) {
            file = new File(file, this.getVersionIdentifier());
        }
        return file.getPath();
    }

    public String getStagingMode(String string) {
        this.assertOnServer();
        String string2 = this.getStagingMode();
        if (string2 == null || string2.length() == 0) {
            string2 = DeployHelper.getServerStagingMode(string);
        }
        return string2;
    }

    public DeploymentPlanBean getDeploymentPlanDescriptor() {
        if (this.plan != null) {
            return this.plan;
        }
        String string = this.getLocalPlanPath();
        if (string != null) {
            File file = new File(string);
            try {
                DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file);
                this.plan = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new IllegalArgumentException(xMLStreamException.getMessage(), xMLStreamException);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassCastException classCastException) {
                Loggable loggable = SlaveDeployerLogger.logUnknownPlanLoggable((String)string, (String)this.getName());
                throw new IllegalArgumentException(loggable.getMessage(), classCastException);
            }
        }
        return this.plan;
    }

    public void setDeploymentPlanDescriptor(DeploymentPlanBean deploymentPlanBean) {
        this.plan = deploymentPlanBean;
    }

    public byte[] getDeploymentPlan() {
        File file;
        String string = this.getLocalPlanPath();
        if (string != null && (file = new File(string)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                int n = fileInputStream.available();
                byte[] byArray = new byte[n];
                fileInputStream.read(byArray);
                fileInputStream.close();
                return byArray;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
        }
        return null;
    }

    public byte[] getDeploymentPlanExternalDescriptors() {
        DeploymentPlanBean deploymentPlanBean = this.getDeploymentPlanDescriptor();
        if (deploymentPlanBean == null) {
            return null;
        }
        try {
            ModuleOverrideBean[] moduleOverrideBeanArray;
            boolean bl = false;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            String string = deploymentPlanBean.getConfigRoot();
            for (ModuleOverrideBean moduleOverrideBean : moduleOverrideBeanArray = deploymentPlanBean.getModuleOverrides()) {
                ModuleDescriptorBean[] moduleDescriptorBeanArray;
                for (ModuleDescriptorBean moduleDescriptorBean : moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors()) {
                    String string2;
                    File file;
                    if (!moduleDescriptorBean.isExternal()) continue;
                    if (deploymentPlanBean.rootModule(moduleOverrideBean.getModuleName())) {
                        file = new File(string);
                        string2 = "";
                    } else {
                        file = new File(string, moduleOverrideBean.getModuleName());
                        string2 = moduleOverrideBean.getModuleName() + "/";
                    }
                    File file2 = new File(file, moduleDescriptorBean.getUri());
                    if (!file2.exists()) continue;
                    bl = true;
                    string2 = string2 + moduleDescriptorBean.getUri();
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                    FileInputStream fileInputStream = new FileInputStream(new File(file, moduleDescriptorBean.getUri()));
                    int n = fileInputStream.available();
                    byte[] byArray = new byte[n];
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                    zipOutputStream.write(byArray);
                    zipOutputStream.closeEntry();
                }
            }
            if (!bl) {
                return null;
            }
            zipOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    private boolean isStagedOnThisServer() {
        if (!this.isStaged()) {
            return false;
        }
        AppDeploymentMBean appDeploymentMBean = (AppDeploymentMBean)this.getMbean();
        return TargetHelper.isTargetedLocaly(appDeploymentMBean) || TargetHelper.isPinnedToServerInCluster(appDeploymentMBean);
    }
}

