/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.InvalidAttributeValueException;
import weblogic.application.ModuleListener;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.j2ee.DeploymentInfo;
import weblogic.j2ee.J2EEUtils;
import weblogic.logging.Loggable;
import weblogic.management.DistributedManagementException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementLogger;
import weblogic.management.bootstrap.BootStrap;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.ApplicationsDirPoller;
import weblogic.management.deploy.DeploymentCompatibilityEvent;
import weblogic.management.deploy.DeploymentCompatibilityEventHandler;
import weblogic.management.deploy.DeploymentCompatibilityEventManager;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class Application
extends ConfigurationMBeanCustomizer
implements DeploymentCompatibilityEventManager {
    private static final long serialVersionUID = -2233500325718755084L;
    private static final DebugCategory debugging = Debug.getCategory((String)"weblogic.deployment");
    private static final DebugCategory debugnotif = Debug.getCategory((String)"weblogic.deployment.notif");
    private transient String fullPath = null;
    private transient String deploymentType;
    private transient boolean delegationEnabled = false;
    private transient AppDeploymentMBean delegate = null;
    private String stagingMode = null;
    private boolean deployed = false;
    private boolean internal = false;
    private int internalType = 6;
    String path = null;
    String notes = null;
    private final CopyOnWriteArraySet handlers = new CopyOnWriteArraySet();

    public Application(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    private String lookupPath() {
        return ((ApplicationMBean)this.getMbean()).getPath();
    }

    public synchronized void unstageTargets(String[] stringArray) {
        int n;
        if (debugging.isEnabled()) {
            Debug.say((String)"Unstaging Targets");
        }
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = this.getApplication().getStagedTargets();
        if (stringArray2 == null || stringArray2.length == 0) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (n = 0; n < stringArray2.length; ++n) {
            treeSet.add(stringArray2[n]);
        }
        if (debugging.isEnabled()) {
            Debug.say((String)("Currently Staged Targets " + treeSet));
        }
        for (n = 0; n < stringArray.length; ++n) {
            Object object;
            String string = stringArray[n];
            if (treeSet.remove(string)) continue;
            ClusterMBean clusterMBean = ((DomainMBean)this.getMbean().getParent()).lookupCluster(string);
            if (clusterMBean != null) {
                if (debugging.isEnabled()) {
                    Debug.say((String)("Unstaging Cluster :" + string));
                }
                if ((object = clusterMBean.getServers()) == null) continue;
                for (int i = 0; i < ((ServerMBean[])object).length; ++i) {
                    String string2 = object[i].getName();
                    treeSet.remove(string2);
                    if (!debugging.isEnabled()) continue;
                    Debug.say((String)("Unstaged Clustered :" + string2));
                }
                continue;
            }
            object = ((DomainMBean)this.getMbean().getParent()).lookupVirtualHost(string);
            if (object == null) continue;
            if (debugging.isEnabled()) {
                Debug.say((String)("Unstaging VirtualHost :" + string));
            }
            TargetMBean[] targetMBeanArray = object.getTargets();
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                String string3 = targetMBeanArray[i].getName();
                treeSet.remove(string3);
                if (!debugging.isEnabled()) continue;
                Debug.say((String)("Unstaged Virtual Target : " + string3));
            }
        }
        String[] stringArray3 = new String[treeSet.size()];
        stringArray3 = treeSet.toArray(stringArray3);
        if (debugging.isEnabled()) {
            Debug.say((String)("Remaining Staged Targets" + treeSet));
        }
        this.getApplication().setStagedTargets(stringArray3);
    }

    public boolean useStagingDirectory(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean stagingEnabled(String string) {
        return "stage".equals(this.getStagingMode(string));
    }

    public boolean staged(String string) {
        List<Object> list;
        boolean bl = true;
        if (this.stagingEnabled(string) && ((list = Arrays.asList((Object[])this.getApplication().getStagedTargets())) == null || !list.contains(string))) {
            bl = false;
        }
        if (debugging.isEnabled()) {
            Debug.say((String)("isStaged  " + string + " = " + bl));
        }
        return bl;
    }

    public void sendAppLevelNotification(String string, String string2, String string3) {
        DeploymentCompatibilityEvent deploymentCompatibilityEvent = new DeploymentCompatibilityEvent("weblogic.deployment.application", string, this.getName(), string2, null, null, null, null, string3);
        this.sendNotification(deploymentCompatibilityEvent);
    }

    public void sendModuleNotification(String string, String string2, String string3, String string4, String string5, String string6, long l) {
        string4 = this.convertStateNamesTo81(string4);
        string5 = this.convertStateNamesTo81(string5);
        DeploymentCompatibilityEvent deploymentCompatibilityEvent = new DeploymentCompatibilityEvent("weblogic.deployment.application.module", string, this.getName(), null, string3, string2, string4, string5, string6);
        this.sendNotification(deploymentCompatibilityEvent);
    }

    private String convertStateNamesTo81(String string) {
        if (string.equals(((Object)ModuleListener.STATE_PREPARED).toString())) {
            return "unprepared".toString();
        }
        if (string.equals(((Object)ModuleListener.STATE_ADMIN).toString())) {
            return "prepared".toString();
        }
        if (string.equals(((Object)ModuleListener.STATE_ACTIVE).toString())) {
            return "active".toString();
        }
        if (debugnotif.isEnabled()) {
            Debug.say((String)("Illegal state " + string));
        }
        return null;
    }

    private String typeAsString(int n) {
        switch (n) {
            case 0: {
                return DeploymentInfo.TYPE_EAR;
            }
            case 2: {
                return DeploymentInfo.TYPE_EXPLODED_EAR;
            }
            case 1: {
                return DeploymentInfo.TYPE_COMPONENT;
            }
            case 3: {
                return DeploymentInfo.TYPE_EXPLODED_COMPONENT;
            }
        }
        return DeploymentInfo.TYPE_UNKNOWN;
    }

    private String getTypeFromNew(String string) {
        if (string == null) {
            return DeploymentInfo.TYPE_UNKNOWN;
        }
        if (string.equals(WebLogicModuleType.UNKNOWN.toString())) {
            return DeploymentInfo.TYPE_UNKNOWN;
        }
        if (string.equals(ModuleType.EAR.toString())) {
            return DeploymentInfo.TYPE_EAR;
        }
        return DeploymentInfo.TYPE_COMPONENT;
    }

    private int stringAsType(String string) {
        if (string.equals(DeploymentInfo.TYPE_EAR)) {
            return 0;
        }
        if (string.equals(DeploymentInfo.TYPE_EXPLODED_EAR)) {
            return 2;
        }
        if (string.equals(DeploymentInfo.TYPE_COMPONENT)) {
            return 1;
        }
        if (string.equals(DeploymentInfo.TYPE_EXPLODED_COMPONENT)) {
            return 3;
        }
        return 4;
    }

    public int findExplodedEar() {
        int n = 0;
        if (this.isAdmin()) {
            File file = new File(this.getFullPath());
            n = file.isDirectory() ? 1 : 0;
        }
        return n;
    }

    public boolean isInternalApp() {
        if (this.getAppDeployment() == null) {
            return this.internal;
        }
        return this.getAppDeployment().isInternalApp();
    }

    public void setInternalApp(boolean bl) {
        if (this.getAppDeployment() == null) {
            this.internal = bl;
        } else {
            this.getAppDeployment().setInternalApp(bl);
        }
    }

    public void setStagingMode(String string) {
        this.stagingMode = string;
    }

    public String getStagingMode() {
        if (!this.isDelegationEnabled()) {
            return this.stagingMode;
        }
        if (this.getAppDeployment() != null) {
            return this.getAppDeployment().getStagingMode();
        }
        return null;
    }

    public boolean isDDEditingEnabled() {
        return false;
    }

    public String getDDEditingDisabledReason() {
        return "Not supported anymore.";
    }

    public String getFullPath() {
        File file;
        if (this.fullPath != null) {
            return this.fullPath;
        }
        try {
            file = BootStrap.apply((String)this.lookupPath());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Throwable)invalidAttributeValueException);
        }
        int n = this.getInternalType();
        if (n == 1 || n == 3 || n == 5) {
            ComponentMBean[] componentMBeanArray = this.getApplication().getComponents();
            if (componentMBeanArray != null && componentMBeanArray.length > 0) {
                String string = componentMBeanArray[0].getURI();
                if (string != null && string.length() > 0) {
                    file = new File(file, string);
                } else {
                    DeployerRuntimeLogger.logNoURI((String)this.getMbean().getName(), (String)componentMBeanArray[0].getName());
                    file = null;
                }
            } else {
                DeployerRuntimeLogger.logNoModules((String)this.getMbean().getName());
                file = null;
            }
        }
        if (file != null) {
            try {
                this.fullPath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                this.fullPath = file.getAbsolutePath();
            }
        }
        return this.fullPath;
    }

    public int getInternalType() {
        if (this.internalType == 6) {
            if (this.deploymentType != null && this.deploymentType != ApplicationMBean.TYPE_UNKNOWN) {
                this.internalType = this.stringAsType(this.deploymentType);
            } else {
                try {
                    this.internalType = J2EEUtils.getDeploymentCategory(this.getApplication());
                    this.deploymentType = this.typeAsString(this.internalType);
                }
                catch (IOException iOException) {
                    this.internalType = 4;
                    Loggable loggable = DeployerRuntimeLogger.logUnknownAppTypeLoggable((String)this.getMbean().getName(), (String)this.lookupPath());
                    loggable.log();
                }
            }
        }
        return this.internalType;
    }

    public String getDeploymentType() {
        String string;
        if (!this.isDelegationEnabled()) {
            if (this.deploymentType == null) {
                this.deploymentType = this.typeAsString(this.getInternalType());
            }
            return this.deploymentType;
        }
        AppDeploymentMBean appDeploymentMBean = this.getAppDeployment();
        if (appDeploymentMBean != null && (string = appDeploymentMBean.getModuleType()) != null) {
            return this.getTypeFromNew(string);
        }
        return DeploymentInfo.TYPE_UNKNOWN;
    }

    public void setDeploymentType(String string) {
        this.deploymentType = string;
    }

    public void setDeployed(boolean bl) {
        this.deployed = bl;
    }

    public boolean isDeployed() {
        AppDeploymentMBean appDeploymentMBean = this.getAppDeployment();
        if (appDeploymentMBean == null) {
            return this.deployed;
        }
        TargetMBean[] targetMBeanArray = appDeploymentMBean.getTargets();
        SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
        return targetMBeanArray != null && targetMBeanArray.length != 0 || subDeploymentMBeanArray != null && subDeploymentMBeanArray.length != 0;
    }

    private String getStagingMode(String string) {
        String string2 = this.getAppDeployment().getStagingMode();
        if (string2 == null || string2.length() == 0) {
            string2 = DeployHelper.getServerStagingMode(string);
            if (debugging.isEnabled()) {
                Debug.say((String)("Using " + string2 + " from serverMBean " + string));
            }
        } else if (debugging.isEnabled()) {
            Debug.say((String)(" Value of application's staging mode is " + string2));
        }
        return string2;
    }

    public boolean isEar() {
        int n = this.getInternalType();
        return n == 0 || n == 2;
    }

    boolean isExplodedEar() {
        return this.getInternalType() == 2;
    }

    public boolean isLoadedFromAppDir() {
        if (!this.isAdmin()) {
            return false;
        }
        return ApplicationsDirPoller.isInAppsDir(new File(DomainDir.getAppPollerDir()), this.lookupPath());
    }

    public void refreshDDsIfNeeded(String[] stringArray, String[] stringArray2) {
        HashSet<Object> hashSet = null;
        if (debugging.isEnabled()) {
            Debug.say((String)("app.refreshDDsIfNeeded " + stringArray2));
        }
        if (this.isConfig()) {
            return;
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            hashSet = new HashSet<Object>(Arrays.asList((Object[])stringArray2));
        }
        if (debugging.isEnabled()) {
            Debug.say((String)("app.refreshDDsIfNeeded " + hashSet));
        }
        ComponentMBean[] componentMBeanArray = this.getApplication().getComponents();
        for (int i = 0; i < componentMBeanArray.length; ++i) {
            if (hashSet != null && !hashSet.contains(componentMBeanArray[i].getName())) continue;
            componentMBeanArray[i].refreshDDsIfNeeded(stringArray);
        }
    }

    private boolean containsAppDD(String[] stringArray) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith("META-INF/application.xml") && !stringArray[i].endsWith("META-INF/weblogic-application.xml")) continue;
            return true;
        }
        return false;
    }

    public ComponentMBean[] getComponents() {
        HashSet hashSet = new HashSet();
        ApplicationMBean applicationMBean = (ApplicationMBean)this.getMbean();
        this.buildComponentSet(applicationMBean.getEJBComponents(), hashSet);
        this.buildComponentSet(applicationMBean.getWebAppComponents(), hashSet);
        this.buildComponentSet(applicationMBean.getWebServiceComponents(), hashSet);
        this.buildComponentSet(applicationMBean.getConnectorComponents(), hashSet);
        this.buildComponentSet(applicationMBean.getJDBCPoolComponents(), hashSet);
        return hashSet.toArray(new ComponentMBean[hashSet.size()]);
    }

    private void buildComponentSet(ComponentMBean[] componentMBeanArray, Set set) {
        if (componentMBeanArray != null && componentMBeanArray.length > 0) {
            List<Object> list = Arrays.asList((Object[])componentMBeanArray);
            set.addAll(list);
        }
    }

    private ApplicationMBean getApplication() {
        return (ApplicationMBean)this.getMbean();
    }

    public AppDeploymentMBean returnDeployableUnit() {
        return this.getAppDeployment();
    }

    public void setDelegationEnabled(boolean bl) {
        this.delegationEnabled = bl;
    }

    public boolean isDelegationEnabled() {
        return this.delegationEnabled;
    }

    public String getPath() {
        if (this.delegate == null) {
            this.getAppDeployment();
        }
        if (this.delegate != null) {
            return this.delegate.getSourcePath();
        }
        return this.path;
    }

    public void setPath(String string) {
        if (this.delegate == null) {
            this.getAppDeployment();
        }
        if (this.delegate != null) {
            this.delegate.setSourcePath(string);
            this.delegate.setModuleType(WebLogicModuleType.getFileModuleTypeAsString(new File(this.delegate.getLocalSourcePath())));
        } else {
            this.path = string;
        }
    }

    public String getNotes() {
        if (this.delegate == null) {
            this.getAppDeployment();
        }
        if (this.delegate != null) {
            return this.delegate.getNotes();
        }
        return this.notes;
    }

    public void setNotes(String string) throws InvalidAttributeValueException, DistributedManagementException {
        if (this.delegate == null) {
            this.getAppDeployment();
        }
        if (this.delegate != null) {
            this.delegate.setNotes(string);
        } else {
            this.notes = string;
        }
    }

    public AppDeploymentMBean getAppDeployment() {
        if (!this.delegationEnabled) {
            return null;
        }
        ApplicationMBean applicationMBean = (ApplicationMBean)this.getMbean();
        DomainMBean domainMBean = (DomainMBean)applicationMBean.getParent();
        if (domainMBean == null) {
            return null;
        }
        this.delegate = AppDeploymentHelper.lookupAppOrLib(applicationMBean.getName(), domainMBean);
        return this.delegate;
    }

    public void addHandler(DeploymentCompatibilityEventHandler deploymentCompatibilityEventHandler) {
        this.handlers.add(deploymentCompatibilityEventHandler);
    }

    private void sendNotification(DeploymentCompatibilityEvent deploymentCompatibilityEvent) {
        Object object;
        if (debugnotif.isEnabled()) {
            object = this.getMbean().getObjectName().getType().endsWith("Config") ? "LOCAL" : "REMOTE";
            Debug.say((String)((String)object + " " + deploymentCompatibilityEvent));
        }
        object = this.handlers.iterator();
        while (object.hasNext()) {
            try {
                ((DeploymentCompatibilityEventHandler)object.next()).handleEvent(deploymentCompatibilityEvent);
            }
            catch (Throwable throwable) {
                ManagementLogger.logExceptionInCustomizer((Throwable)throwable);
            }
        }
    }

    public boolean isTwoPhase() {
        return true;
    }
}

