/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.mbeans.custom;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.RuntimeOperationsException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.custom.ConfigurationMBeanCustomized;
import weblogic.management.provider.custom.ConfigurationMBeanCustomizer;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifecycleException;

public final class Cluster
extends ConfigurationMBeanCustomizer {
    private static final long serialVersionUID = 6825873886824636463L;
    private String multicastAddress;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public Cluster(ConfigurationMBeanCustomized configurationMBeanCustomized) {
        super(configurationMBeanCustomized);
    }

    public ServerMBean[] getServers() {
        HashSet<ServerMBean> hashSet = new HashSet<ServerMBean>();
        DomainMBean domainMBean = (DomainMBean)this.getMbean().getParent();
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        String string = this.getMbean().getName();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            ServerMBean serverMBean = serverMBeanArray[i];
            if (serverMBean.getCluster() == null || !serverMBean.getCluster().getName().equals(string)) continue;
            hashSet.add(serverMBean);
        }
        ServerMBean[] serverMBeanArray2 = new ServerMBean[hashSet.size()];
        return hashSet.toArray(serverMBeanArray2);
    }

    public MigratableTargetMBean[] getMigratableTargets() {
        HashSet<MigratableTargetMBean> hashSet = new HashSet<MigratableTargetMBean>();
        DomainMBean domainMBean = (DomainMBean)this.getMbean().getParent();
        MigratableTargetMBean[] migratableTargetMBeanArray = domainMBean.getMigratableTargets();
        String string = this.getMbean().getName();
        for (int i = 0; i < migratableTargetMBeanArray.length; ++i) {
            MigratableTargetMBean migratableTargetMBean = migratableTargetMBeanArray[i];
            if (migratableTargetMBean.getCluster() == null || !migratableTargetMBean.getCluster().getName().equals(string)) continue;
            hashSet.add(migratableTargetMBean);
        }
        MigratableTargetMBean[] migratableTargetMBeanArray2 = new MigratableTargetMBean[hashSet.size()];
        return hashSet.toArray(migratableTargetMBeanArray2);
    }

    public String getMulticastAddress() {
        String string = System.getProperty("weblogic.cluster.multicastAddress");
        if (string != null) {
            return string;
        }
        string = this.multicastAddress;
        if (string == null) {
            this.multicastAddress = string = "237.0.0.1";
        }
        return string;
    }

    public void setMulticastAddress(String string) {
        this.multicastAddress = string;
    }

    public HashMap start() throws RuntimeOperationsException {
        if (this.isConfig()) {
            return null;
        }
        ServerMBean[] serverMBeanArray = this.getServers();
        HashMap<String, ServerLifeCycleTaskRuntimeMBean> hashMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>();
        try {
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                ServerMBean serverMBean = serverMBeanArray[i];
                hashMap.put(serverMBean.getName(), this.getServerLifeCycleRuntime(serverMBean.getName()).start());
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (ServerLifecycleException serverLifecycleException) {
            RuntimeException runtimeException = new RuntimeException(serverLifecycleException);
            throw new RuntimeOperationsException(runtimeException);
        }
        return hashMap;
    }

    public HashMap kill() throws RuntimeOperationsException {
        if (this.isConfig()) {
            return null;
        }
        ServerMBean[] serverMBeanArray = this.getServers();
        HashMap<String, ServerLifeCycleTaskRuntimeMBean> hashMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>();
        try {
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                ServerMBean serverMBean = serverMBeanArray[i];
                hashMap.put(serverMBean.getName(), this.getServerLifeCycleRuntime(serverMBean.getName()).forceShutdown());
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (ServerLifecycleException serverLifecycleException) {
            RuntimeException runtimeException = new RuntimeException(serverLifecycleException);
            throw new RuntimeOperationsException(runtimeException);
        }
        return hashMap;
    }

    private ServerLifeCycleRuntimeMBean getServerLifeCycleRuntime(String string) {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
            return domainAccess.lookupServerLifecycleRuntime(string);
        }
        return null;
    }

    public Set getServerNames() {
        ServerMBean[] serverMBeanArray = this.getServers();
        HashSet<String> hashSet = new HashSet<String>(serverMBeanArray.length);
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            hashSet.add(serverMBeanArray[i].getName());
        }
        return hashSet;
    }
}

